/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.logicTree;

import com.google.common.base.Preconditions;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.opensha.commons.data.ShortNamed;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.AffectsAll;
import org.opensha.commons.logicTree.AffectsNone;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.FileNameUtils;

public abstract class LogicTreeLevel<E extends LogicTreeNode>
implements ShortNamed {
    private List<String> affected;
    private List<String> notAffected;
    private boolean affectsAll;
    private boolean affectsNone;

    public abstract Class<? extends E> getType();

    public abstract List<? extends E> getNodes();

    public abstract boolean isMember(LogicTreeNode var1);

    public String getFilePrefix() {
        return FileNameUtils.simplify(this.getShortName());
    }

    public boolean affects(String name, boolean affectedByDefault) {
        this.checkParseAnnotations();
        if (this.affectsAll) {
            return true;
        }
        if (this.affectsNone) {
            return false;
        }
        for (String affected : this.affected) {
            if (!name.equals(affected)) continue;
            return true;
        }
        for (String notAffected : this.notAffected) {
            if (!name.equals(notAffected)) continue;
            return false;
        }
        return affectedByDefault;
    }

    public final Collection<String> getAffected() {
        this.checkParseAnnotations();
        return Collections.unmodifiableCollection(this.affected);
    }

    public final Collection<String> getNotAffected() {
        this.checkParseAnnotations();
        return Collections.unmodifiableCollection(this.notAffected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkParseAnnotations() {
        if (this.affected == null) {
            LogicTreeLevel logicTreeLevel = this;
            synchronized (logicTreeLevel) {
                if (this.affected == null) {
                    DoesNotAffect.NotAffected multiNotAffected;
                    ArrayList<String> affected = new ArrayList<String>();
                    ArrayList<String> notAffected = new ArrayList<String>();
                    Class<E> type = this.getType();
                    Affects.Affected multAffected = type.getAnnotation(Affects.Affected.class);
                    if (multAffected != null) {
                        for (Affects affects : multAffected.value()) {
                            affected.add(affects.value());
                        }
                    } else {
                        Affects affects = type.getAnnotation(Affects.class);
                        if (affects != null) {
                            affected.add(affects.value());
                        }
                    }
                    if ((multiNotAffected = type.getAnnotation(DoesNotAffect.NotAffected.class)) != null) {
                        for (DoesNotAffect doesNot : multiNotAffected.value()) {
                            String name = doesNot.value();
                            Preconditions.checkState((!affected.contains(name) ? 1 : 0) != 0, (String)"Node type %s annotates '%s' as both affected and not affected!", (Object)type.getName(), (Object)name);
                            notAffected.add(name);
                        }
                    } else {
                        DoesNotAffect doesNot = type.getAnnotation(DoesNotAffect.class);
                        if (doesNot != null) {
                            String name = doesNot.value();
                            Preconditions.checkState((!affected.contains(name) ? 1 : 0) != 0, (String)"Node type %s annotates '%s' as both affected and not affected!", (Object)type.getName(), (Object)name);
                            notAffected.add(name);
                        }
                    }
                    AffectsNone noneAffected = type.getAnnotation(AffectsNone.class);
                    AffectsAll allAffected = type.getAnnotation(AffectsAll.class);
                    Preconditions.checkState((noneAffected == null || allAffected == null ? 1 : 0) != 0, (Object)"Can't specify both none and all affected");
                    if (noneAffected != null) {
                        Preconditions.checkState((affected.isEmpty() && notAffected.isEmpty() ? 1 : 0) != 0, (Object)"Supplied buth @AffectsNone and also individual @Affects/@DoesNotAffect annotation(s)");
                        this.affectsNone = true;
                    } else if (allAffected != null) {
                        Preconditions.checkState((affected.isEmpty() && notAffected.isEmpty() ? 1 : 0) != 0, (Object)"Supplied buth @AffectsNone and also individual @Affects/@DoesNotAffect annotation(s)");
                        this.affectsAll = true;
                    }
                    this.notAffected = notAffected;
                    this.affected = affected;
                }
            }
        }
    }

    public void setAffected(Collection<String> affected, Collection<String> notAffected, boolean processAnnotations) {
        Preconditions.checkNotNull(affected);
        Preconditions.checkNotNull(notAffected);
        if (processAnnotations) {
            this.checkParseAnnotations();
            ArrayList<String> allNew = new ArrayList<String>();
            if (affected != null) {
                allNew.addAll(affected);
            }
            if (notAffected != null) {
                allNew.addAll(notAffected);
            }
            for (String val : allNew) {
                this.affected.remove(val);
                this.notAffected.remove(val);
            }
            this.affected = new ArrayList<String>(this.affected);
            this.affected.addAll(affected);
            this.notAffected = new ArrayList<String>(this.notAffected);
            this.notAffected.addAll(notAffected);
        } else {
            this.affected = new ArrayList<String>(affected);
            this.notAffected = new ArrayList<String>(notAffected);
        }
    }

    public void setAffectsAll() {
        this.affected = List.of();
        this.notAffected = List.of();
        this.affectsAll = true;
        this.affectsNone = false;
    }

    public void setAffectsNone() {
        this.affected = List.of();
        this.notAffected = List.of();
        this.affectsAll = false;
        this.affectsNone = true;
    }

    public String toString() {
        return this.getName();
    }

    public boolean matchesType(Class<?> clazz) {
        Class<E> type = this.getType();
        return type.equals(clazz) || type.isAssignableFrom(clazz);
    }

    public static <E extends Enum<E>> EnumBackedLevel<E> forEnum(Class<E> type, String name, String shortName) {
        return new EnumBackedLevel<E>(name, shortName, type);
    }

    public static <E extends LogicTreeNode> EnumBackedLevel<E> forEnumUnchecked(Class<?> type, String name, String shortName) {
        return new EnumBackedLevel(name, shortName, type);
    }

    public static <E extends LogicTreeNode> EnumBackedLevel<E> forEnumUnchecked(Object enumValue, String name, String shortName) {
        Class<?> type = enumValue.getClass();
        if (!type.isEnum()) {
            type = type.getEnclosingClass();
        }
        Preconditions.checkState((boolean)type.isEnum(), (String)"Class is not an enum: %s", type);
        Preconditions.checkState((boolean)(enumValue instanceof LogicTreeNode));
        return new EnumBackedLevel(name, shortName, type);
    }

    public static void main(String[] args) throws IOException {
        LogicTree.read(new File("/home/kevin/OpenSHA/UCERF4/batch_inversions/2021_12_14-nshm23_draft_branches-coulomb-ineq-FM3_1-ZENGBB-Shaw09Mod-TotNuclRate-SubB1/logic_tree.json"));
    }

    public static class EnumBackedLevel<E extends LogicTreeNode>
    extends LogicTreeLevel<E> {
        private String name;
        private String shortName;
        private Class<E> type;

        public EnumBackedLevel(String name, String shortName, Class<E> type) {
            this.name = name;
            this.shortName = shortName;
            Preconditions.checkState((boolean)type.isEnum(), (Object)"Supplied type is not an enum");
            this.type = type;
        }

        @Override
        public String getShortName() {
            return this.shortName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class<E> getType() {
            return this.type;
        }

        @Override
        public List<E> getNodes() {
            return List.of((LogicTreeNode[])this.type.getEnumConstants());
        }

        @Override
        public boolean isMember(LogicTreeNode node) {
            return node != null && this.type.isAssignableFrom(node.getClass());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.shortName == null ? 0 : this.shortName.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnumBackedLevel other = (EnumBackedLevel)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.shortName == null ? other.shortName != null : !this.shortName.equals(other.shortName)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }

    public static class Adapter<E extends LogicTreeNode>
    extends TypeAdapter<LogicTreeLevel<? extends E>> {
        private boolean writeNodes;
        private LogicTreeBranch.NodeTypeAdapter nodeAdapter;
        private boolean forceFileBacked;

        public Adapter() {
            this(true);
        }

        public Adapter(boolean writeNodes) {
            this(writeNodes, false);
        }

        public Adapter(boolean writeNodes, boolean forceFileBacked) {
            this.writeNodes = writeNodes;
            this.forceFileBacked = forceFileBacked;
            this.nodeAdapter = new LogicTreeBranch.NodeTypeAdapter(null, forceFileBacked);
        }

        public void write(JsonWriter out, LogicTreeLevel<? extends E> level) throws IOException {
            Collection<String> notAffected;
            out.beginObject();
            out.name("name").value(level.getName());
            out.name("shortName").value(level.getShortName());
            if (level.getType().isEnum()) {
                out.name("enumClass").value(level.getType().getName());
            } else if (!(level instanceof FileBackedLevel)) {
                out.name("class").value(level.getClass().getName());
            }
            Collection<String> affected = level.getAffected();
            if (affected != null && !affected.isEmpty()) {
                out.name("affects").beginArray();
                for (String name : affected) {
                    out.value(name);
                }
                out.endArray();
            }
            if ((notAffected = level.getNotAffected()) != null && !notAffected.isEmpty()) {
                out.name("doesNotAffect").beginArray();
                for (String name : notAffected) {
                    out.value(name);
                }
                out.endArray();
            }
            if (level.affectsAll) {
                out.name("affectsAll").value(true);
            }
            if (level.affectsNone) {
                out.name("affectsNone").value(true);
            }
            if (this.writeNodes) {
                out.name("nodes").beginArray();
                for (LogicTreeNode node : level.getNodes()) {
                    this.nodeAdapter.write(out, node);
                }
                out.endArray();
            }
            out.endObject();
        }

        public LogicTreeLevel<E> read(JsonReader in) throws IOException {
            String name = null;
            String shortName = null;
            String enumClassName = null;
            String className = null;
            ArrayList<String> affected = new ArrayList<String>();
            ArrayList<String> notAffected = new ArrayList<String>();
            boolean affectsAll = false;
            boolean affectsNone = false;
            ArrayList<LogicTreeNode> nodes = new ArrayList<LogicTreeNode>();
            in.beginObject();
            block29: while (in.hasNext()) {
                switch (in.nextName()) {
                    case "name": {
                        name = in.nextString();
                        continue block29;
                    }
                    case "shortName": {
                        shortName = in.nextString();
                        continue block29;
                    }
                    case "enumClass": {
                        enumClassName = in.nextString();
                        continue block29;
                    }
                    case "class": {
                        className = in.nextString();
                        continue block29;
                    }
                    case "affects": {
                        in.beginArray();
                        while (in.hasNext()) {
                            affected.add(in.nextString());
                        }
                        in.endArray();
                        continue block29;
                    }
                    case "doesNotAffect": {
                        in.beginArray();
                        while (in.hasNext()) {
                            notAffected.add(in.nextString());
                        }
                        in.endArray();
                        continue block29;
                    }
                    case "affectsAll": {
                        affectsAll = in.nextBoolean();
                        continue block29;
                    }
                    case "affectsNone": {
                        affectsNone = in.nextBoolean();
                        continue block29;
                    }
                    case "nodes": {
                        in.beginArray();
                        while (in.hasNext()) {
                            nodes.add(this.nodeAdapter.read(in));
                        }
                        in.endArray();
                        continue block29;
                    }
                }
                in.skipValue();
            }
            if (affectsAll || affectsNone) {
                Preconditions.checkState((!affectsAll || !affectsNone ? 1 : 0) != 0, (Object)"both affectsAll and affectsNone are true?");
                Preconditions.checkState((boolean)affected.isEmpty(), (Object)"can't specify individual and blanket affectations");
                Preconditions.checkState((boolean)notAffected.isEmpty(), (Object)"can't specify individual and blanket affectations");
            }
            LogicTreeLevel level = null;
            if (!this.forceFileBacked && enumClassName != null) {
                try {
                    Class<?> rawClass = Class.forName(enumClassName);
                    level = LogicTreeLevel.forEnumUnchecked(rawClass, name, shortName);
                    for (LogicTreeNode node : nodes) {
                        if (level.isMember(node)) continue;
                        System.err.println("WARNING: Node " + node.getName() + " not found in enum " + enumClassName + ", reverting to file backed level");
                        level = null;
                        break;
                    }
                }
                catch (ClassNotFoundException e) {
                    System.err.println("WARNING: couldn't locate logic tree branch node enum class '" + enumClassName + "', loading plain/hardcoded version instead");
                }
                catch (ClassCastException e) {
                    System.err.println("WARNING: logic tree branch node class '" + enumClassName + "' is of the wrong type, loading plain/hardcoded version instead");
                }
                if (level != null) {
                    if (affectsAll) {
                        level.setAffectsAll();
                    } else if (affectsNone) {
                        level.setAffectsNone();
                    } else if (!affected.isEmpty() || !notAffected.isEmpty()) {
                        level.setAffected(affected, notAffected, true);
                    }
                }
            }
            if (!this.forceFileBacked && level == null && className != null) {
                try {
                    Class<?> rawClass;
                    Class<?> clazz = rawClass = Class.forName(className);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    level = (LogicTreeLevel)constructor.newInstance(new Object[0]);
                    if (level instanceof RandomlySampledLevel) {
                        ((RandomlySampledLevel)level).setNodes(nodes);
                    }
                    if (affectsAll) {
                        level.setAffectsAll();
                    } else if (affectsNone) {
                        level.setAffectsNone();
                    } else if (!affected.isEmpty() || !notAffected.isEmpty()) {
                        level.setAffected(affected, notAffected, true);
                    }
                }
                catch (ClassNotFoundException e) {
                    System.err.println("WARNING: couldn't locate logic tree branch node class '" + className + "', loading plain/hardcoded version instead");
                }
                catch (ClassCastException e) {
                    System.err.println("WARNING: logic tree branch node class '" + className + "' is of the wrong type, loading plain/hardcoded version instead");
                }
                catch (Exception e) {
                    System.err.println("Couldn't instantiate default no-arg constructor of declared logic tree node class, loading plain/hardcoded version instead");
                }
            }
            if (level == null) {
                FileBackedLevel fileLevel = new FileBackedLevel(name, shortName);
                if (affectsAll) {
                    fileLevel.setAffectsAll();
                } else if (affectsNone) {
                    fileLevel.setAffectsNone();
                } else {
                    fileLevel.setAffected(affected, notAffected, false);
                }
                level = fileLevel;
                if (nodes != null) {
                    for (LogicTreeNode node : nodes) {
                        LogicTreeNode.FileBackedNode fileNode = node instanceof LogicTreeNode.FileBackedNode ? (LogicTreeNode.FileBackedNode)node : new LogicTreeNode.FileBackedNode(node.getName(), node.getShortName(), node.getNodeWeight(null), node.getFilePrefix());
                        fileLevel.addChoice(fileNode);
                    }
                }
            }
            in.endObject();
            return level;
        }
    }

    public static abstract class RandomlySampledLevel<E extends LogicTreeNode.RandomlySampledNode>
    extends LogicTreeLevel<E> {
        private List<? extends E> nodes;

        public void buildNodes(Random rand, int num) {
            double weightEach = 1.0 / (double)num;
            this.buildNodes(rand, num, weightEach);
        }

        public void buildNodes(Random rand, int num, double weightEach) {
            ArrayList<E> nodes = new ArrayList<E>(num);
            Preconditions.checkState((num >= 1 ? 1 : 0) != 0);
            for (int i = 0; i < num; ++i) {
                nodes.add(this.buildNodeInstance(i, rand.nextLong(), weightEach));
            }
            this.nodes = nodes;
        }

        public void buildNodes(List<Long> seeds, double weightEach) {
            ArrayList<E> nodes = new ArrayList<E>(seeds.size());
            Preconditions.checkState((seeds.size() >= 1 ? 1 : 0) != 0);
            for (int i = 0; i < seeds.size(); ++i) {
                nodes.add(this.buildNodeInstance(i, seeds.get(i), weightEach));
            }
            this.nodes = nodes;
        }

        public void setNodes(List<? extends LogicTreeNode> nodes) {
            ArrayList<LogicTreeNode.RandomlySampledNode> cast = new ArrayList<LogicTreeNode.RandomlySampledNode>(nodes.size());
            for (LogicTreeNode logicTreeNode : nodes) {
                Preconditions.checkState((boolean)(logicTreeNode instanceof LogicTreeNode.RandomlySampledNode));
                Preconditions.checkState((boolean)this.getType().isInstance(logicTreeNode));
                cast.add((LogicTreeNode.RandomlySampledNode)logicTreeNode);
            }
            this.nodes = cast;
        }

        @Override
        public List<E> getNodes() {
            Preconditions.checkNotNull(this.nodes, (Object)"Nodes have not yet been built/set");
            return Collections.unmodifiableList(this.nodes);
        }

        public abstract E buildNodeInstance(int var1, long var2, double var4);

        @Override
        public boolean isMember(LogicTreeNode node) {
            if (!(node instanceof LogicTreeNode.RandomlySampledNode)) {
                return false;
            }
            long seed = ((LogicTreeNode.RandomlySampledNode)node).getSeed();
            for (LogicTreeNode.RandomlySampledNode nodeTest : this.getNodes()) {
                if (!node.equals(nodeTest) && seed != nodeTest.getSeed()) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class AdapterBackedLevel
    extends LogicTreeLevel<LogicTreeNode> {
        String name;
        String shortName;
        Class<? extends LogicTreeNode> nodeType;

        public AdapterBackedLevel(String name, String shortName, Class<? extends LogicTreeNode> nodeType) {
            this.name = name;
            this.shortName = shortName;
            this.nodeType = nodeType;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getShortName() {
            return this.shortName;
        }

        @Override
        public Class<? extends LogicTreeNode> getType() {
            return this.nodeType;
        }

        @Override
        public List<? extends LogicTreeNode> getNodes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isMember(LogicTreeNode node) {
            return node.getClass() == this.getType();
        }

        public boolean equals(Object o) {
            if (o instanceof AdapterBackedLevel) {
                AdapterBackedLevel other = (AdapterBackedLevel)o;
                return other.getName() == this.getName() && other.getType() == this.getType();
            }
            return false;
        }
    }

    public static class FileBackedLevel
    extends LogicTreeLevel<LogicTreeNode.FileBackedNode> {
        private String name;
        private String shortName;
        private List<LogicTreeNode.FileBackedNode> choices;

        FileBackedLevel(String name, String shortName) {
            this(name, shortName, new ArrayList<LogicTreeNode.FileBackedNode>());
        }

        FileBackedLevel(String name, String shortName, LogicTreeNode.FileBackedNode choice) {
            this(name, shortName, new ArrayList<LogicTreeNode.FileBackedNode>());
            if (choice != null) {
                this.addChoice(choice);
            }
        }

        public FileBackedLevel(String name, String shortName, List<LogicTreeNode.FileBackedNode> choices) {
            this.name = name;
            this.shortName = shortName;
            if (choices == null) {
                choices = new ArrayList<LogicTreeNode.FileBackedNode>();
            }
            this.choices = choices;
        }

        @Override
        public String getShortName() {
            return this.shortName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class<LogicTreeNode.FileBackedNode> getType() {
            return LogicTreeNode.FileBackedNode.class;
        }

        void addChoice(LogicTreeNode.FileBackedNode choice) {
            Preconditions.checkNotNull((Object)choice);
            this.choices.add(choice);
        }

        @Override
        public List<LogicTreeNode.FileBackedNode> getNodes() {
            return this.choices;
        }

        @Override
        public boolean isMember(LogicTreeNode node) {
            return this.choices.contains(node);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.shortName == null ? 0 : this.shortName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileBackedLevel other = (FileBackedLevel)obj;
            if (this.choices != null && other.choices != null && !this.choices.equals(other.choices)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.shortName == null ? other.shortName != null : !this.shortName.equals(other.shortName));
        }
    }
}

