/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.mapping.gmt;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.mapping.gmt.elements.CoastAttributes;
import org.opensha.commons.mapping.gmt.elements.PSText;
import org.opensha.commons.mapping.gmt.elements.PSXYPolygon;
import org.opensha.commons.mapping.gmt.elements.PSXYSymbol;
import org.opensha.commons.mapping.gmt.elements.PSXYSymbolSet;
import org.opensha.commons.mapping.gmt.elements.TopographicSlopeFile;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.cybershake.maps.GMT_InterpolationSettings;

public class GMT_Map
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Region region;
    private String cptFile = null;
    private String cptCustomFileName = "cptFile.cpt";
    private CPT cpt = null;
    private boolean rescaleCPT = true;
    private double griddedDataInc;
    private GeoDataSet griddedData = null;
    private String customGRDPath;
    private String customIntenPath;
    private HighwayFile highwayFile = null;
    public static Region ca_topo_region = new Region(new Location(32.0, -126.0), new Location(43.0, -115.0));
    public static Region us_topo_region = new Region(new Location(20.0, -128.0), new Location(52.0, -60.0));
    private TopographicSlopeFile topoResolution = null;
    private CoastAttributes coast = new CoastAttributes();
    private double imageWidth = 6.5;
    private boolean hideColorbar = false;
    private String customLabel = null;
    private Integer labelSize = null;
    private Integer labelTickSize = null;
    private Double customScaleMin = null;
    private Double customScaleMax = null;
    private boolean cptEqualSpacing = false;
    private Double cptCustomInterval = null;
    private int dpi = 72;
    private boolean useGMTSmoothing = true;
    private boolean useGRDView = false;
    private boolean blackBackground = true;
    private boolean logPlot = false;
    private boolean drawScaleKM = true;
    private String xyzFileName = "map_data.txt";
    private String psFileName = "map.ps";
    private String pdfFileName = "map.pdf";
    private String pngFileName = "map.png";
    private String jpgFileName = "map.jpg";
    private String gmtScriptFileName = "map_GMT_Script.txt";
    private ArrayList<PSXYSymbol> xySymbols = new ArrayList();
    private ArrayList<PSXYPolygon> xyLines = new ArrayList();
    private ArrayList<PSText> xyText = new ArrayList();
    private PSXYSymbolSet xySymbolSet = null;
    private boolean generateKML = false;
    private GMT_InterpolationSettings interpSettings;
    private boolean maskIfNotRectangular = false;
    private double contourIncrement = 0.0;
    private boolean contourOnly = false;
    private Map<String, String> gmtSetVals;

    public GMT_Map(Region region, GeoDataSet griddedData, double griddedDataInc, String cptFile) {
        this.region = region;
        this.setGriddedData(griddedData, griddedDataInc, cptFile);
    }

    public GMT_Map(Region region, GeoDataSet griddedData, double griddedDataInc, CPT cpt) {
        this.region = region;
        this.setGriddedData(griddedData, griddedDataInc, cpt);
    }

    public void setGriddedData(GeoDataSet griddedData, double griddedDataInc, String cptFile) {
        this.griddedData = griddedData;
        this.griddedDataInc = griddedDataInc;
        this.cptFile = cptFile;
        this.cpt = null;
    }

    public void setGriddedData(GeoDataSet griddedData, double griddedDataInc, CPT cpt) {
        this.griddedData = griddedData;
        this.griddedDataInc = griddedDataInc;
        this.cptFile = null;
        this.cpt = cpt;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public String getCptFile() {
        return this.cptFile;
    }

    public void setCptFile(String cptFile) {
        this.cptFile = cptFile;
    }

    public void setCustomCptFileName(String cptCustomFileName) {
        this.cptCustomFileName = cptCustomFileName;
    }

    public String getCustomCptFileName() {
        return this.cptCustomFileName;
    }

    public CPT getCpt() {
        return this.cpt;
    }

    public void setCpt(CPT cpt) {
        this.cpt = cpt;
    }

    public boolean isRescaleCPT() {
        return this.rescaleCPT;
    }

    public void setRescaleCPT(boolean rescaleCPT) {
        this.rescaleCPT = rescaleCPT;
    }

    public boolean isCPTEqualSpacing() {
        return this.cptEqualSpacing;
    }

    public void setCPTEqualSpacing(boolean cptEqualSpacing) {
        this.cptEqualSpacing = cptEqualSpacing;
    }

    public Double getCPTCustomInterval() {
        return this.cptCustomInterval;
    }

    public void setCPTCustomInterval(Double cptCustomInterval) {
        this.cptCustomInterval = cptCustomInterval;
    }

    public double getGriddedDataInc() {
        return this.griddedDataInc;
    }

    public void setGriddedDataInc(double griddedDataInc) {
        this.griddedDataInc = griddedDataInc;
    }

    public GeoDataSet getGriddedData() {
        return this.griddedData;
    }

    public void setGriddedData(GeoDataSet griddedData) {
        this.griddedData = griddedData;
    }

    public HighwayFile getHighwayFile() {
        return this.highwayFile;
    }

    public void setHighwayFile(HighwayFile highwayFile) {
        this.highwayFile = highwayFile;
    }

    public TopographicSlopeFile getTopoResolution() {
        return this.topoResolution;
    }

    public void setTopoResolution(TopographicSlopeFile topoResolution) {
        this.topoResolution = topoResolution;
    }

    public CoastAttributes getCoast() {
        return this.coast;
    }

    public void setCoast(CoastAttributes coast) {
        this.coast = coast;
    }

    public double getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(double imageWidth) {
        this.imageWidth = imageWidth;
    }

    public String getCustomLabel() {
        return this.customLabel;
    }

    public void setCustomLabel(String customLabel) {
        this.customLabel = customLabel;
    }

    public void setHideColorbar(boolean hideColorbar) {
        this.hideColorbar = hideColorbar;
    }

    public boolean isHideColorbar() {
        return this.hideColorbar;
    }

    public void setLabelSize(Integer labelSize) {
        this.labelSize = labelSize;
    }

    public Integer getLabelSize() {
        return this.labelSize;
    }

    public void setLabelTickSize(Integer labelTickSize) {
        this.labelTickSize = labelTickSize;
    }

    public Integer getLabelTickSize() {
        return this.labelTickSize;
    }

    public boolean isCustomScale() {
        return this.customScaleMin != null && this.customScaleMax != null && this.customScaleMin < this.customScaleMax;
    }

    public void clearCustomScale() {
        this.customScaleMin = null;
        this.customScaleMax = null;
    }

    public Double getCustomScaleMin() {
        return this.customScaleMin;
    }

    public void setCustomScaleMin(Double customScaleMin) {
        this.customScaleMin = customScaleMin;
    }

    public Double getCustomScaleMax() {
        return this.customScaleMax;
    }

    public void setCustomScaleMax(Double customScaleMax) {
        this.customScaleMax = customScaleMax;
    }

    public int getDpi() {
        return this.dpi;
    }

    public void setDpi(int dpi) {
        this.dpi = dpi;
    }

    public boolean isUseGMTSmoothing() {
        return this.useGMTSmoothing;
    }

    public void setUseGMTSmoothing(boolean useGMTSmoothing) {
        this.useGMTSmoothing = useGMTSmoothing;
    }

    public boolean isBlackBackground() {
        return this.blackBackground;
    }

    public void setBlackBackground(boolean blackBackground) {
        this.blackBackground = blackBackground;
    }

    public boolean isLogPlot() {
        return this.logPlot;
    }

    public void setLogPlot(boolean logPlot) {
        this.logPlot = logPlot;
    }

    public String getXyzFileName() {
        return this.xyzFileName;
    }

    public void setXyzFileName(String xyzFileName) {
        this.xyzFileName = xyzFileName;
    }

    public String getPSFileName() {
        return this.psFileName;
    }

    public void setPSFileName(String psFileName) {
        this.psFileName = psFileName;
    }

    public String getPDFFileName() {
        return this.pdfFileName;
    }

    public void setPDFFileName(String pdfFileName) {
        this.pdfFileName = pdfFileName;
    }

    public String getPNGFileName() {
        return this.pngFileName;
    }

    public void setPNGFileName(String pngFileName) {
        this.pngFileName = pngFileName;
    }

    public String getJPGFileName() {
        return this.jpgFileName;
    }

    public void setJPGFileName(String jpgFileName) {
        this.jpgFileName = jpgFileName;
    }

    public String getGmtScriptFileName() {
        return this.gmtScriptFileName;
    }

    public void setGmtScriptFileName(String gmtScriptFileName) {
        this.gmtScriptFileName = gmtScriptFileName;
    }

    public ArrayList<PSXYSymbol> getSymbols() {
        return this.xySymbols;
    }

    public void setSymbols(ArrayList<PSXYSymbol> xySymbols) {
        this.xySymbols = xySymbols;
    }

    public void addSymbol(PSXYSymbol symbol) {
        this.xySymbols.add(symbol);
    }

    public ArrayList<PSXYPolygon> getPolys() {
        return this.xyLines;
    }

    public void setPolys(ArrayList<PSXYPolygon> xyLines) {
        this.xyLines = xyLines;
    }

    public void addPolys(PSXYPolygon line) {
        this.xyLines.add(line);
    }

    public PSXYSymbolSet getSymbolSet() {
        return this.xySymbolSet;
    }

    public void setSymbolSet(PSXYSymbolSet xySymbolSet) {
        this.xySymbolSet = xySymbolSet;
    }

    public ArrayList<PSText> getText() {
        return this.xyText;
    }

    public void setText(ArrayList<PSText> xyText) {
        this.xyText = xyText;
    }

    public void addText(PSText text) {
        this.xyText.add(text);
    }

    public boolean isGenerateKML() {
        return this.generateKML;
    }

    public void setGenerateKML(boolean generateKML) {
        this.generateKML = generateKML;
    }

    public GMT_InterpolationSettings getInterpSettings() {
        return this.interpSettings;
    }

    public void setInterpSettings(GMT_InterpolationSettings interpSettings) {
        this.interpSettings = interpSettings;
    }

    public boolean isMaskIfNotRectangular() {
        return this.maskIfNotRectangular;
    }

    public void setMaskIfNotRectangular(boolean maskIfNotRectangular) {
        this.maskIfNotRectangular = maskIfNotRectangular;
    }

    public double getContourIncrement() {
        return this.contourIncrement;
    }

    public void setContourIncrement(double contourIncrement) {
        this.contourIncrement = contourIncrement;
    }

    public boolean isContourOnly() {
        return this.contourOnly;
    }

    public void setContourOnly(boolean contourOnly) {
        this.contourOnly = contourOnly;
    }

    public boolean isDrawScaleKM() {
        return this.drawScaleKM;
    }

    public void setDrawScaleKM(boolean drawScaleKM) {
        this.drawScaleKM = drawScaleKM;
    }

    public String getCustomGRDPath() {
        return this.customGRDPath;
    }

    public void setCustomGRDPath(String customGRDPath) {
        this.customGRDPath = customGRDPath;
    }

    public String getCustomIntenPath() {
        return this.customIntenPath;
    }

    public void setCustomIntenPath(String customIntenPath) {
        this.customIntenPath = customIntenPath;
    }

    public void setGMT_Param(String name, String value) {
        if (this.gmtSetVals == null) {
            this.gmtSetVals = new HashMap<String, String>();
        }
        this.gmtSetVals.put(name, value);
    }

    public Map<String, String> getGMT_Params() {
        return this.gmtSetVals;
    }

    public boolean isUseGRDView() {
        return this.useGRDView;
    }

    public void setUseGRDView(boolean useGRDView) {
        this.useGRDView = useGRDView;
    }

    public static enum HighwayFile {
        ALL("CA All", "ca_hiwys.all.xy"),
        MAIN("CA Main", "ca_hiwys.main.xy"),
        OTHER("CA Other", "ca_hiwys.other.xy");

        private final String name;
        private final String fileName;

        private HighwayFile(String name, String fileName) {
            this.name = name;
            this.fileName = fileName;
        }

        public String fileName() {
            return this.fileName;
        }

        public String description() {
            return this.name;
        }
    }
}

