/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.mapping.gmt.gui;

import java.awt.GridBagLayout;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.mapping.gmt.GMT_MapGenerator;
import org.opensha.commons.mapping.gmt.gui.ImageViewerWindow;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;

public class GMT_MapGuiBean
extends ParameterListEditor
implements ParameterChangeListener {
    protected static final String C = "MapGuiBean";
    protected static final boolean D = false;
    protected static final String GMT_TITLE = new String("Map Attributes");
    protected GMT_MapGenerator gmtMap = new GMT_MapGenerator();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    protected boolean showMapInSeperateWindow = true;
    protected String imgName = null;
    protected String dirName = null;

    public GMT_MapGuiBean() {
        try {
            this.initParamListAndEditor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initParamListAndEditor() {
        ListIterator it = this.gmtMap.getAdjustableParamsIterator();
        this.parameterList = new ParameterList();
        while (it.hasNext()) {
            this.parameterList.addParameter((Parameter)it.next());
        }
        this.editorPanel.removeAll();
        this.addParameters();
        this.setTitle(GMT_TITLE);
        this.parameterList.getParameter("Color Scale Limits").addParameterChangeListener(this);
        this.parameterList.getParameter("Custom Scale Label").addParameterChangeListener(this);
        this.changeColorScaleModeValue("From Data");
        this.getParameterEditor("Use GMT WebService").setVisible(false);
        this.getParameterEditor("Scale Label").setVisible(false);
    }

    public void showRegionParams(boolean regionParamsFlag) {
        this.getParameterEditor("Max Latitude").setVisible(regionParamsFlag);
        this.getParameterEditor("Min Latitude").setVisible(regionParamsFlag);
        this.getParameterEditor("Max Longitude").setVisible(regionParamsFlag);
        this.getParameterEditor("Min Longitude").setVisible(regionParamsFlag);
        this.getParameterEditor("Grid Spacing").setVisible(regionParamsFlag);
    }

    public void setRegionParams(double minLat, double maxLat, double minLon, double maxLon, double gridSpacing) {
        this.getParameterList().getParameter("Min Latitude").setValue(minLat);
        this.getParameterList().getParameter("Max Latitude").setValue(maxLat);
        this.getParameterList().getParameter("Min Longitude").setValue(minLon);
        this.getParameterList().getParameter("Max Longitude").setValue(maxLon);
        this.getParameterList().getParameter("Grid Spacing").setValue(gridSpacing);
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String name = e.getParameterName();
        if (name.equalsIgnoreCase("Color Scale Limits")) {
            this.changeColorScaleModeValue((String)e.getNewValue());
        } else if (name.equalsIgnoreCase("Custom Scale Label")) {
            boolean boolVal = (Boolean)e.getNewValue();
            this.showCustomScaleLabel(boolVal);
        }
    }

    protected void showCustomScaleLabel(boolean showLabel) {
        this.getParameterEditor("Scale Label").setVisible(showLabel);
    }

    protected void changeColorScaleModeValue(String val) {
        if (val.equalsIgnoreCase("From Data")) {
            this.getParameterEditor("Color-Scale Max").setVisible(false);
            this.getParameterEditor("Color-Scale Min").setVisible(false);
        } else {
            this.getParameterEditor("Color-Scale Max").setVisible(true);
            this.getParameterEditor("Color-Scale Min").setVisible(true);
        }
    }

    public GriddedRegion getEvenlyGriddedGeographicRegion() {
        return this.gmtMap.getEvenlyGriddedGeographicRegion();
    }

    public static String getClickHereHTML(String webaddr) {
        return "<br><p>Click:  <a href=\"" + webaddr + "\">here</a> (" + webaddr + ") to download files (images and data). They will be deleted at midnight</p>";
    }

    public void makeMap(GeoDataSet xyzVals, String metadataAsHTML) {
        boolean gmtServerCheck = true;
        if (gmtServerCheck) {
            try {
                this.imgName = this.gmtMap.makeMapUsingServlet(xyzVals, " ", (String)metadataAsHTML, this.dirName);
                metadataAsHTML = (String)metadataAsHTML + GMT_MapGuiBean.getClickHereHTML(this.gmtMap.getGMTFilesWebAddress());
            }
            catch (GMT_MapException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Incorrect GMT params ", 1);
                return;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e.getMessage(), "Server Problem", 1);
                return;
            }
        }
        try {
            this.imgName = this.gmtMap.makeMapLocally(xyzVals, " ", (String)metadataAsHTML, this.dirName);
        }
        catch (GMT_MapException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Incorrect GMT params ", 1);
            return;
        }
        catch (RuntimeException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
            return;
        }
        if (this.showMapInSeperateWindow) {
            ImageViewerWindow imageViewerWindow = new ImageViewerWindow(this.imgName, (String)metadataAsHTML, gmtServerCheck);
        }
        this.dirName = null;
    }

    public void setMapToBeShownInSeperateWindow(boolean flag) {
        this.showMapInSeperateWindow = flag;
    }

    public GMT_MapGenerator getGMTObject() {
        return this.gmtMap;
    }

    public void setDirectoryName(String dirName) {
        this.dirName = dirName;
    }
}

