/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.mapping.gmt.gui;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.lang3.SystemUtils;
import org.opensha.commons.util.BrowserUtils;
import org.opensha.commons.util.FileUtils;

public class ImageViewerWindow
extends JFrame
implements HyperlinkListener {
    private static final int W = 650;
    private static final int H = 730;
    private static final String MAP_WINDOW = "Maps using GMT";
    private JSplitPane mapSplitPane = new JSplitPane();
    private JScrollPane mapScrollPane = new JScrollPane();
    private boolean gmtFromServer = true;
    JMenuBar menuBar = new JMenuBar();
    JMenu fileMenu = new JMenu();
    JMenuItem fileSaveMenu = new JMenuItem();
    JToolBar jToolBar = new JToolBar();
    JButton saveButton = new JButton();
    ImageIcon saveFileImage = new ImageIcon(FileUtils.loadImage("icons/saveFile.jpg"));
    private String mapInfoAsHTML;
    private String mapInfoAsString;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JScrollPane mapInfoScrollPane = new JScrollPane();
    private JPanel mapPanel = new JPanel();
    private GridBagLayout layout = new GridBagLayout();
    private JTextPane mapText = new JTextPane();
    private String[] imgFileNames;

    public ImageViewerWindow(String imageFileName, String mapInfoAsHTML, boolean gmtFromServer) throws RuntimeException {
        this.mapInfoAsHTML = mapInfoAsHTML;
        String lf = SystemUtils.LINE_SEPARATOR;
        this.mapInfoAsString = mapInfoAsHTML.replaceAll("<br>", lf);
        this.mapInfoAsString = this.mapInfoAsString.replaceAll("</br>", "");
        this.mapInfoAsString = this.mapInfoAsString.replaceAll("<p>", lf);
        this.mapInfoAsString = this.mapInfoAsString.replaceAll("</p>", "");
        this.mapInfoAsString = this.mapInfoAsString.replaceAll("&nbsp;", "  ");
        this.gmtFromServer = gmtFromServer;
        this.imgFileNames = new String[1];
        this.imgFileNames[0] = imageFileName;
        try {
            this.jbInit();
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.addImageToWindow(imageFileName);
        this.setVisible(true);
    }

    public ImageViewerWindow(String[] imageFileNames, String mapInfo, boolean gmtFromServer) throws RuntimeException {
        this.mapInfoAsHTML = mapInfo;
        String lf = SystemUtils.LINE_SEPARATOR;
        this.mapInfoAsString = this.mapInfoAsHTML.replaceAll("<br>", lf);
        this.mapInfoAsString = this.mapInfoAsString.replaceAll("</br>", "");
        this.mapInfoAsString = this.mapInfoAsString.replaceAll("<p>", lf);
        this.mapInfoAsString = this.mapInfoAsString.replaceAll("</p>", "");
        this.mapInfoAsString = this.mapInfoAsString.replaceAll("&nbsp;", "  ");
        this.gmtFromServer = gmtFromServer;
        this.imgFileNames = imageFileNames;
        try {
            this.jbInit();
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.addImagesToWindow(imageFileNames);
        this.setVisible(true);
    }

    protected void jbInit() throws RuntimeException {
        this.setDefaultCloseOperation(2);
        this.setSize(650, 730);
        this.setTitle(MAP_WINDOW);
        this.getContentPane().setLayout(this.borderLayout1);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewerWindow.this.saveButton_actionPerformed(actionEvent);
            }
        });
        this.fileSaveMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageViewerWindow.this.fileSaveMenu_actionPerformed(e);
            }
        });
        this.fileSaveMenu.setText("Save");
        this.fileMenu.setText("File");
        this.menuBar.add(this.fileMenu);
        this.fileMenu.add(this.fileSaveMenu);
        this.setJMenuBar(this.menuBar);
        Dimension d = this.saveButton.getSize();
        this.jToolBar.add(this.saveButton);
        this.saveButton.setIcon(this.saveFileImage);
        this.saveButton.setToolTipText("Save Graph as image");
        this.saveButton.setSize(d);
        this.jToolBar.add(this.saveButton);
        this.jToolBar.setFloatable(false);
        this.getContentPane().add((Component)this.jToolBar, "North");
        this.mapSplitPane.setOrientation(0);
        this.mapInfoScrollPane.getViewport().add((Component)this.mapText, null);
        this.mapText.setContentType("text/html");
        this.mapText.setText(this.mapInfoAsHTML);
        this.mapText.setEditable(false);
        this.mapText.setForeground(Color.blue);
        this.mapText.setEditable(false);
        this.mapText.setSelectedTextColor(new Color(80, 80, 133));
        this.mapText.setSelectionColor(Color.blue);
        this.mapText.addHyperlinkListener(this);
        this.getContentPane().add((Component)this.mapSplitPane, "Center");
        this.mapSplitPane.add((Component)this.mapScrollPane, "top");
        this.mapSplitPane.add((Component)this.mapInfoScrollPane, "bottom");
        this.mapPanel.setLayout(this.layout);
        this.mapScrollPane.getViewport().add((Component)this.mapPanel, null);
        this.mapSplitPane.setDividerLocation(480);
    }

    private void addImagesToWindow(String[] imageURLs) {
        int size = imageURLs.length;
        JLabel[] mapLabel = new JLabel[size];
        for (int i = 0; i < size; ++i) {
            mapLabel[i] = new JLabel();
            if (this.gmtFromServer) {
                try {
                    mapLabel[i].setIcon(new ImageIcon(new URL(imageURLs[i])));
                }
                catch (Exception e) {
                    throw new RuntimeException("No Internet connection available");
                }
            } else {
                mapLabel[i].setIcon(new ImageIcon(imageURLs[i]));
            }
            this.mapPanel.add((Component)mapLabel[i], new GridBagConstraints(0, i, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 3, 5, 5), 0, 0));
        }
    }

    private void addImageToWindow(String imageFile) {
        JLabel mapLabel = new JLabel();
        if (!this.gmtFromServer) {
            mapLabel.setIcon(new ImageIcon(imageFile));
        } else {
            try {
                mapLabel.setIcon(new ImageIcon(new URL(imageFile)));
            }
            catch (Exception e) {
                throw new RuntimeException("No Internet connection available");
            }
        }
        this.mapPanel.add((Component)mapLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 3, 5, 5), 0, 0));
    }

    protected void save() throws IOException {
        JFileChooser fileChooser = new JFileChooser();
        int option = fileChooser.showSaveDialog(this);
        Object fileName = null;
        if (option == 0) {
            fileName = fileChooser.getSelectedFile().getAbsolutePath();
            if (!((String)fileName).endsWith(".pdf")) {
                fileName = (String)fileName + ".pdf";
            }
        } else {
            return;
        }
        this.saveAsPDF((String)fileName);
    }

    protected void saveAsPDF(String fileName) throws IOException {
        Document document = new Document();
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(fileName));
            writer.setStrictImageSequence(true);
            document.open();
            int numImages = this.imgFileNames.length;
            for (int i = 0; i < numImages; ++i) {
                Image img = Image.getInstance((URL)new URL(this.imgFileNames[i]));
                img.setAlignment(2);
                document.add((Element)img);
            }
            document.add((Element)new Paragraph(this.mapInfoAsString));
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        document.close();
    }

    private void saveButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.save();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Save File Error", 0);
            return;
        }
    }

    private void fileSaveMenu_actionPerformed(ActionEvent actionEvent) {
        try {
            this.save();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Save File Error", 0);
            return;
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        HyperlinkEvent.EventType type = e.getEventType();
        if (type == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                BrowserUtils.launch(e.getURL().toURI());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

