/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.opensha.commons.gui.LabeledBorderPanel;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.util.ClassUtils;

public abstract class AbstractParameterEditor<E>
extends LabeledBorderPanel
implements ParameterEditor<E> {
    private static final long serialVersionUID = 1L;
    private Parameter<E> param;
    private JComponent widget;
    protected static final Dimension LABEL_DIM = new Dimension(100, 20);
    protected static final Dimension LABEL_PANEL_DIM = new Dimension(120, 20);
    protected static final Dimension WIGET_PANEL_DIM = new Dimension(120, 28);
    public static Font DEFAULT_FONT = new Font("SansSerif", 0, 11);
    protected static final Border CONST_BORDER = BorderFactory.createLineBorder(Color.blue, 1);
    protected static final Border FOCUS_BORDER = BorderFactory.createLineBorder(Color.orange, 1);
    protected static final Border ETCHED = BorderFactory.createEtchedBorder();
    private boolean showDisabledStatusInTitle = false;

    public AbstractParameterEditor() {
        this((Parameter<E>)null);
    }

    public AbstractParameterEditor(Parameter<E> param) {
        super(new BorderLayout(), true, false);
        super.initParameterLookAndFeel();
        this.setParameter(param);
    }

    @Override
    public final void setValue(E value) throws NullPointerException {
        this.param.setValue(value);
        this.refreshParamEditor();
    }

    @Override
    public final E getValue() throws NullPointerException {
        return this.param.getValue();
    }

    @Override
    public void unableToSetValue(Object value) {
        this.param.unableToSetValue(value);
    }

    @Override
    public final Parameter<E> getParameter() {
        return this.param;
    }

    @Override
    public final void setParameter(Parameter<E> model) {
        if (!this.isParameterSupported(model)) {
            if (model == null) {
                throw new IllegalArgumentException("null parameters not supported by this editor");
            }
            throw new IllegalArgumentException("Parameter '" + model.getName() + "' of type '" + ClassUtils.getClassNameWithoutPackage(model.getClass()) + "' not supported by this editor");
        }
        this.param = model;
        this.updateTitle();
        this.refreshParamEditor();
    }

    public abstract boolean isParameterSupported(Parameter<E> var1);

    public void setShowDisabledStatusInTitle(boolean showDisabledStatusInTitle) {
        this.showDisabledStatusInTitle = showDisabledStatusInTitle;
    }

    protected void updateTitle() {
        Object label;
        if (this.param == null) {
            label = "";
        } else {
            label = this.param.getName();
            String units = this.param.getUnits();
            if (label == null) {
                label = "";
            } else {
                if (units != null && !units.equals("")) {
                    label = (String)label + " (" + units + ")";
                }
                label = (String)label + ":";
            }
            if (this.showDisabledStatusInTitle && !this.isEnabled()) {
                label = "(disabled) " + (String)label;
            }
        }
        super.setTitle((String)label);
    }

    @Override
    public final void setFocusEnabled(boolean newFocusEnabled) {
    }

    @Override
    public final boolean isFocusEnabled() {
        return false;
    }

    @Override
    public final JComponent getComponent() {
        return this;
    }

    @Override
    public final void refreshParamEditor() {
        if (this.widget == null) {
            this.widget = this.buildWidget();
            this.add(this.widget);
        } else {
            JComponent updated = this.updateWidget();
            if (updated == null) {
                updated = this.buildWidget();
            }
            if (updated != this.widget) {
                this.removeWidget();
                this.widget = updated;
                this.add(this.widget);
            }
        }
        if (this.showDisabledStatusInTitle) {
            this.updateTitle();
        }
        this.widget.validate();
        this.validate();
        super.setToolTipText(this.getLabelToolTipText());
        this.widget.setToolTipText(this.getWidgetToolTipText());
        this.editorPanel.invalidate();
    }

    @Override
    public abstract void setEnabled(boolean var1);

    protected abstract JComponent buildWidget();

    protected abstract JComponent updateWidget();

    protected String getLabelToolTipText() {
        if (this.param == null) {
            return null;
        }
        String info = this.param.getInfo();
        if (info == null || info.length() == 0 || info.equals(" ")) {
            return null;
        }
        return "<html>" + info.replaceAll("\n", "<br>") + "</html>";
    }

    protected String getWidgetToolTipText() {
        return this.getLabelToolTipText();
    }

    protected void removeWidget() {
        if (this.widget != null) {
            super.remove(this.widget);
        }
    }

    public final JComponent getWidget() {
        return this.widget;
    }

    @Override
    public void setEditorBorder(Border border) {
        this.mainPanel.setBorder(border);
    }

    public static JLabel makeSingleConstraintValueLabel(String label) {
        JLabel l = new JLabel();
        l.setPreferredSize(LABEL_DIM);
        l.setMinimumSize(LABEL_DIM);
        l.setForeground(Color.blue);
        l.setBorder(CONST_BORDER);
        l.setText(label);
        return l;
    }
}

