/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.AbstractParameterEditor;
import org.opensha.commons.param.impl.ButtonParameter;

public class ButtonParameterEditor
extends AbstractParameterEditor<Integer>
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton button;

    public ButtonParameterEditor(ButtonParameter buttonParameter) {
        super(buttonParameter);
    }

    @Override
    public boolean isParameterSupported(Parameter<Integer> param) {
        return param instanceof ButtonParameter;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.button != null) {
            this.button.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.button != null && this.button.isEnabled();
    }

    @Override
    protected JComponent buildWidget() {
        if (this.button == null) {
            this.button = new JButton();
            this.button.addActionListener(this);
        }
        return this.updateWidget();
    }

    @Override
    protected JComponent updateWidget() {
        ButtonParameter buttonParam = (ButtonParameter)this.getParameter();
        this.button.setText(buttonParam.getButtonText());
        return this.button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button) {
            Parameter<Integer> param = this.getParameter();
            param.setValue((Integer)param.getValue() + 1);
        }
    }
}

