/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.opensha.commons.mapping.gmt.gui.CPTListCellRenderer;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.ListBasedConstraint;
import org.opensha.commons.param.editor.AbstractParameterEditor;
import org.opensha.commons.util.cpt.CPT;

public class ConstrainedCPTParameterEditor
extends AbstractParameterEditor<CPT>
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private JComboBox combo;

    public ConstrainedCPTParameterEditor(Parameter<CPT> param) {
        super(param);
    }

    @Override
    public boolean isParameterSupported(Parameter<CPT> param) {
        if (param == null) {
            return false;
        }
        if (param.getValue() == null) {
            return false;
        }
        if (!(param.getValue() instanceof CPT)) {
            return false;
        }
        ParameterConstraint constraint = param.getConstraint();
        if (constraint == null) {
            return false;
        }
        if (!(constraint instanceof ListBasedConstraint)) {
            return false;
        }
        ListBasedConstraint lconst = (ListBasedConstraint)constraint;
        return lconst.getAllowed().size() >= 1;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.combo != null) {
            this.combo.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.combo != null && this.combo.isEnabled();
    }

    private ListBasedConstraint<CPT> getListConst() {
        return (ListBasedConstraint)this.getParameter().getConstraint();
    }

    @Override
    protected JComponent buildWidget() {
        ListBasedConstraint<CPT> lconst = this.getListConst();
        this.combo = new JComboBox<Object>(lconst.getAllowed().toArray());
        this.combo.setRenderer(new CPTListCellRenderer(this.combo));
        this.combo.setSelectedItem(this.getValue());
        this.combo.addItemListener(this);
        return this.combo;
    }

    @Override
    protected JComponent updateWidget() {
        ListBasedConstraint<CPT> lconst = this.getListConst();
        this.combo.removeItemListener(this);
        this.combo.setModel(new DefaultComboBoxModel<Object>(lconst.getAllowed().toArray()));
        this.combo.setSelectedItem(this.getValue());
        this.combo.addItemListener(this);
        return this.combo;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.combo) {
            CPT selection = (CPT)this.combo.getSelectedItem();
            this.setValue(selection);
        }
    }
}

