/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.LocationConstraint;
import org.opensha.commons.param.editor.AbstractParameterEditorConverter;
import org.opensha.commons.param.impl.StringParameter;

public class ConstrainedDiscreteLocationParameterEditor
extends AbstractParameterEditorConverter<Location, String> {
    private HashMap<String, Location> map;

    public ConstrainedDiscreteLocationParameterEditor() {
    }

    public ConstrainedDiscreteLocationParameterEditor(Parameter<Location> param) {
        super(param);
    }

    @Override
    protected Parameter<String> buildParameter(Parameter<Location> myParam) {
        ParameterConstraint constraint = myParam.getConstraint();
        Preconditions.checkArgument((boolean)(constraint instanceof LocationConstraint), (Object)"constraint must be of type LocationConstraint");
        LocationConstraint locConst = (LocationConstraint)constraint;
        List<Location> allowed = locConst.getAllowedValues();
        ArrayList<String> strings = new ArrayList<String>();
        this.map = new HashMap();
        for (Location loc : allowed) {
            String val = this.convertFromNative(loc);
            strings.add(val);
            this.map.put(val, loc);
        }
        StringParameter param = new StringParameter(myParam.getName(), strings, myParam.getValue().toString());
        return param;
    }

    @Override
    protected String convertFromNative(Location value) {
        return value.toString();
    }

    @Override
    protected Location convertToNative(String value) {
        return this.map.get(value);
    }
}

