/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import com.google.common.base.Preconditions;
import java.awt.GridLayout;
import javax.swing.JPanel;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;

public class GriddedParameterListEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ParameterList paramList;

    public GriddedParameterListEditor() {
        this((ParameterList)null);
    }

    public GriddedParameterListEditor(ParameterList paramList) {
        this(paramList, 2);
    }

    public GriddedParameterListEditor(ParameterList paramList, int cols) {
        this(paramList, 0, cols);
    }

    public GriddedParameterListEditor(ParameterList paramList, int rows, int cols) {
        if (paramList != null) {
            int numParams = paramList.size();
            if (numParams == 0) {
                return;
            }
            if (numParams < cols) {
                cols = numParams;
            }
        }
        Preconditions.checkState((rows > 0 || cols > 0 ? 1 : 0) != 0, (Object)"You must give a non zero value for rows or columns!");
        this.setLayout(new GridLayout(rows, cols));
        this.setParameterList(paramList);
    }

    public void setParameterList(ParameterList paramList) {
        this.removeAll();
        this.paramList = paramList;
        if (paramList != null) {
            for (Parameter<?> param : paramList) {
                this.add(param.getEditor().getComponent());
            }
        }
        this.validate();
    }

    public ParameterList getParameterList() {
        return this.paramList;
    }
}

