/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jfree.data.Range;
import org.opensha.commons.exceptions.WarningException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.AbstractParameterEditor;
import org.opensha.commons.param.editor.impl.NumericTextField;

public class RangeParameterEditor
extends AbstractParameterEditor<Range>
implements FocusListener,
KeyListener {
    private NumericTextField lowerField;
    private NumericTextField upperField;
    private JPanel panel;
    private boolean keyTypeProcessing;
    private boolean focusLostProcessing;

    public RangeParameterEditor(Parameter<Range> param) {
        super(param);
    }

    @Override
    public boolean isParameterSupported(Parameter<Range> param) {
        return param != null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.lowerField.setEnabled(enabled);
        this.upperField.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.lowerField != null && this.lowerField.isEnabled();
    }

    @Override
    protected JComponent buildWidget() {
        Dimension sizeDim = new Dimension((int)(LABEL_DIM.getWidth() * 0.6), (int)LABEL_DIM.getHeight());
        this.lowerField = new NumericTextField();
        this.lowerField.setMinimumSize(sizeDim);
        this.lowerField.setPreferredSize(sizeDim);
        this.lowerField.setBorder(ETCHED);
        this.lowerField.setFont(DEFAULT_FONT);
        this.lowerField.addFocusListener(this);
        this.lowerField.addKeyListener(this);
        this.upperField = new NumericTextField();
        this.upperField.setMinimumSize(sizeDim);
        this.upperField.setPreferredSize(sizeDim);
        this.upperField.setBorder(ETCHED);
        this.upperField.setFont(DEFAULT_FONT);
        this.upperField.addFocusListener(this);
        this.upperField.addKeyListener(this);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)this.lowerField, "West");
        this.panel.add((Component)this.upperField, "East");
        this.updateWidget();
        return this.panel;
    }

    @Override
    protected JComponent updateWidget() {
        Range val = (Range)this.getValue();
        if (val == null) {
            this.lowerField.setText("");
            this.upperField.setText("");
        } else {
            this.lowerField.setText("" + val.getLowerBound());
            this.lowerField.setCaretPosition(0);
            this.upperField.setText("" + val.getUpperBound());
            this.upperField.setCaretPosition(0);
        }
        return this.panel;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        String S = "LabeledBorderPanel: keyTyped(): ";
        this.keyTypeProcessing = false;
        if (this.focusLostProcessing) {
            return;
        }
        if (e.getKeyChar() == '\n') {
            this.keyTypeProcessing = true;
            this.setParamFromField();
        }
        this.keyTypeProcessing = false;
    }

    @Override
    public void focusLost(FocusEvent e) {
        String S = "LabeledBorderPanel: focusLost(): ";
        this.focusLostProcessing = false;
        if (this.keyTypeProcessing) {
            return;
        }
        this.focusLostProcessing = true;
        this.setParamFromField();
        this.focusLostProcessing = false;
    }

    private void setParamFromField() {
        String lowerValue = this.lowerField.getText();
        String upperValue = this.upperField.getText();
        try {
            Double lowerVal = lowerValue.equals("") ? null : Double.valueOf(Double.parseDouble(lowerValue));
            Double upperVal = upperValue.equals("") ? null : Double.valueOf(Double.parseDouble(upperValue));
            if (lowerVal == null || upperVal == null) {
                this.setValue(null);
            } else {
                if (lowerVal > upperVal) {
                    double t = upperVal;
                    upperVal = lowerVal;
                    lowerVal = t;
                }
                this.setValue(new Range(lowerVal.doubleValue(), upperVal.doubleValue()));
            }
            this.refreshParamEditor();
            this.panel.validate();
            this.panel.repaint();
        }
        catch (WarningException ee) {
            this.refreshParamEditor();
            this.panel.validate();
            this.panel.repaint();
        }
        catch (Exception ee) {
            this.unableToSetValue(lowerValue + ", " + upperValue);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }
}

