/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.editor.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.AbstractParameterEditorOld;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.ParameterListParameter;
import org.opensha.commons.param.impl.RegionParameter;

public class RegionParameterEditor
extends AbstractParameterEditorOld
implements ActionListener,
ParameterChangeListener {
    private static final long serialVersionUID = 1L;
    protected static final String C = "RegionParameterEditor";
    private RegionParameter param;
    private ParameterListEditor editor;
    private boolean parameterChangeFlag = true;
    protected JDialog frame;
    private boolean showEditorAsPanel = false;
    protected static final Dimension WIGET_PANEL_DIM = new Dimension(140, 220);

    public RegionParameterEditor() {
    }

    public RegionParameterEditor(Parameter model) {
        this(model, false);
    }

    public RegionParameterEditor(Parameter model, boolean showEditorAsPanel) {
        this.showEditorAsPanel = showEditorAsPanel;
        try {
            this.jbInit();
            this.setParameter(model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
    }

    @Override
    public void setParameter(Parameter param) {
        int fillConstraint;
        this.setParameterInEditor(param);
        this.param = (RegionParameter)param;
        this.initParamListAndEditor();
        if (!this.showEditorAsPanel) {
            this.valueEditor = new JButton(param.getName());
            ((JButton)this.valueEditor).addActionListener(this);
            fillConstraint = 2;
            this.editor.setTitle("Set " + param.getName());
        } else {
            this.valueEditor = this.editor;
            fillConstraint = 1;
            this.valueEditor.setMinimumSize(WIGET_PANEL_DIM);
            this.valueEditor.setPreferredSize(WIGET_PANEL_DIM);
            this.editor.setTitle(param.getName());
        }
        this.add((Component)this.valueEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, fillConstraint, new Insets(0, 0, 0, 0), 0, 0));
        String S = "RegionParameterEditor: Constructor(): ";
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.parameterChangeFlag = true;
    }

    protected void initParamListAndEditor() {
        ParameterList paramList = (ParameterList)((ParameterListParameter)this.param.getRegionParameter()).getValue();
        ListIterator<Parameter<?>> it = paramList.getParametersIterator();
        while (it.hasNext()) {
            it.next().addParameterChangeListener(this);
        }
        this.editor = new ParameterListEditor(paramList);
    }

    protected void button_actionPerformed(ActionEvent e) {
        if (this.parameterChangeFlag) {
            Region region = new Region(new Location(this.param.getMinLatitude(), this.param.getMinLongitude()), new Location(this.param.getMaxLatitude(), this.param.getMaxLongitude()));
            this.param.setValue(region);
        }
        this.frame.dispose();
    }

    public void setEditorTitle(String title) {
        this.editor.setTitle(title);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.editor.setEnabled(isEnabled);
    }

    public void setParameterVisible(String parameterName, boolean visible) {
        this.editor.setParameterVisible(parameterName, visible);
    }

    @Override
    public void refreshParamEditor() {
        this.editor.refreshParamEditor();
    }

    public Parameter getParameter(String paramName) {
        return this.editor.getParameterList().getParameter(paramName);
    }

    public ParameterList getParameterList() {
        return this.editor.getParameterList();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.frame = new JDialog();
        this.frame.setModal(true);
        this.frame.setSize(300, 400);
        this.frame.setTitle(this.param.getName());
        this.frame.getContentPane().setLayout(new GridBagLayout());
        this.frame.getContentPane().add((Component)this.editor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        JButton button = new JButton();
        button.setText("Update " + this.param.getName());
        button.setForeground(new Color(80, 80, 133));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegionParameterEditor.this.button_actionPerformed(e);
            }
        });
        this.frame.getContentPane().add((Component)button, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.frame.setVisible(true);
        this.frame.pack();
    }
}

