/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.impl;

import com.google.common.collect.Iterables;
import java.util.EnumSet;
import org.dom4j.Element;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.EnumConstraint;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.EnumParameterEditor;

public class EnumParameter<E extends Enum<E>>
extends AbstractParameter<E> {
    private EnumParameterEditor<E> editor;
    private String nullOption;
    private Class<E> clazz;
    private EnumSet<E> choices;

    private EnumParameter() {
    }

    public EnumParameter(String name, EnumSet<E> choices, E defaultValue, String nullOption) {
        super(name, new EnumConstraint<E>(choices, nullOption != null), null, defaultValue);
        this.clazz = ((Enum)Iterables.getFirst(choices, null)).getClass();
        this.choices = choices;
        if (choices.size() > 1 && !this.clazz.isEnum()) {
            this.clazz = this.clazz.getEnclosingClass();
        }
        this.nullOption = nullOption;
        this.setDefaultValue(defaultValue);
    }

    @Override
    public ParameterEditor<E> getEditor() {
        if (this.editor == null) {
            this.editor = new EnumParameterEditor<E>(this, this.clazz);
        }
        return this.editor;
    }

    @Override
    public boolean isEditorBuilt() {
        return this.editor != null;
    }

    @Override
    public Object clone() {
        EnumParameter<E> ep = new EnumParameter<E>();
        ep.nullOption = this.nullOption;
        ep.constraint = (ParameterConstraint)this.constraint.clone();
        ep.defaultValue = this.defaultValue;
        ep.value = this.value;
        ep.name = this.name;
        ep.choices = this.choices;
        return ep;
    }

    @Override
    protected boolean setIndividualParamValueFromXML(Element el) {
        String val = el.attributeValue("value");
        for (Enum choice : this.choices) {
            if (!choice.toString().equals(val)) continue;
            this.setValue(choice);
            return true;
        }
        return false;
    }

    public String getNullOption() {
        return this.nullOption;
    }

    @Override
    public EnumConstraint<E> getConstraint() {
        return (EnumConstraint)super.getConstraint();
    }
}

