/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.impl;

import org.dom4j.Element;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.IntegerConstraint;
import org.opensha.commons.param.constraint.impl.IntegerDiscreteConstraint;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.ConstrainedIntegerDiscreteParameterEditor;
import org.opensha.commons.param.editor.impl.ConstrainedIntegerParameterEditor;
import org.opensha.commons.param.editor.impl.IntegerParameterEditor;

public class IntegerParameter
extends AbstractParameter<Integer>
implements Parameter<Integer> {
    private static final long serialVersionUID = 1L;
    protected static final String C = "IntegerParameter";
    protected static final boolean D = false;
    private transient ParameterEditor paramEdit = null;

    public IntegerParameter(String name) {
        super(name, null, null, null);
    }

    public IntegerParameter(String name, String units) throws ConstraintException {
        this(name, null, units, null);
    }

    public IntegerParameter(String name, int min, int max) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), null, null);
    }

    public IntegerParameter(String name, int min, int max, String units) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), null, null);
    }

    public IntegerParameter(String name, Integer min, Integer max) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), null, null);
    }

    public IntegerParameter(String name, Integer min, Integer max, String units) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), null, null);
    }

    public IntegerParameter(String name, ParameterConstraint<Integer> constraint) throws ConstraintException {
        super(name, constraint, null, null);
    }

    public IntegerParameter(String name, ParameterConstraint<Integer> constraint, String units) throws ConstraintException {
        super(name, constraint, units, null);
    }

    public IntegerParameter(String name, Integer value) {
        super(name, null, null, value);
    }

    public IntegerParameter(String name, String units, Integer value) throws ConstraintException {
        super(name, null, units, value);
    }

    public IntegerParameter(String name, int min, int max, Integer value) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), null, value);
    }

    public IntegerParameter(String name, Integer min, Integer max, Integer value) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), null, value);
    }

    public IntegerParameter(String name, ParameterConstraint<Integer> constraint, Integer value) throws ConstraintException {
        super(name, constraint, null, value);
    }

    public IntegerParameter(String name, int min, int max, String units, Integer value) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), units, value);
    }

    public IntegerParameter(String name, Integer min, Integer max, String units, Integer value) throws ConstraintException {
        super(name, new IntegerConstraint(min, max), units, value);
    }

    public IntegerParameter(String name, ParameterConstraint<Integer> constraint, String units, Integer value) throws ConstraintException {
        super(name, constraint, units, value);
    }

    @Override
    public void setConstraint(ParameterConstraint constraint) throws ParameterException {
        String S = "IntegerParameter: setConstraint(): ";
        this.checkEditable(S);
        if (!(constraint instanceof IntegerConstraint) && !(constraint instanceof IntegerDiscreteConstraint)) {
            throw new ParameterException(S + "This parameter only accepts IntegerConstraints, unable to set the constraint.");
        }
        super.setConstraint(constraint);
    }

    @Override
    public boolean isAllowed(int i) {
        return this.isAllowed(Integer.valueOf(i));
    }

    public Integer getMin() throws Exception {
        if (this.constraint != null) {
            return ((IntegerConstraint)this.constraint).getMin();
        }
        return null;
    }

    public Integer getMax() {
        if (this.constraint != null) {
            return ((IntegerConstraint)this.constraint).getMax();
        }
        return null;
    }

    @Override
    public String getType() {
        Object type = C;
        ParameterConstraint constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + (String)type;
        }
        return type;
    }

    @Override
    public Object clone() {
        IntegerConstraint c1 = null;
        if (this.constraint != null) {
            c1 = (IntegerConstraint)this.constraint.clone();
        }
        IntegerParameter param = null;
        param = this.value == null ? new IntegerParameter(this.name, (ParameterConstraint<Integer>)c1, this.units) : new IntegerParameter(this.name, (ParameterConstraint<Integer>)c1, this.units, Integer.valueOf(((Integer)this.value).toString()));
        if (param == null) {
            return null;
        }
        param.editable = true;
        param.info = this.info;
        return param;
    }

    @Override
    public boolean setIndividualParamValueFromXML(Element el) {
        try {
            int val = Integer.parseInt(el.attributeValue("value"));
            this.setValue(val);
            return true;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public ParameterEditor getEditor() {
        block6: {
            if (this.paramEdit == null) {
                try {
                    if (this.constraint == null) {
                        this.paramEdit = new IntegerParameterEditor((Parameter)this);
                        break block6;
                    }
                    if (this.constraint instanceof IntegerConstraint) {
                        this.paramEdit = new ConstrainedIntegerParameterEditor((Parameter)this);
                        break block6;
                    }
                    if (this.constraint instanceof IntegerDiscreteConstraint) {
                        this.paramEdit = new ConstrainedIntegerDiscreteParameterEditor(this);
                        break block6;
                    }
                    throw new IllegalStateException("unknown constraint type: " + String.valueOf(this.constraint));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.paramEdit;
    }

    @Override
    public boolean isEditorBuilt() {
        return this.paramEdit != null;
    }
}

