/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.impl;

import java.util.ArrayList;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.exceptions.WarningException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.WarningParameter;
import org.opensha.commons.param.constraint.AbstractParameterConstraint;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.IntegerConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeWarningEvent;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.IntegerParameter;

public class WarningIntegerParameter
extends IntegerParameter
implements WarningParameter<Integer> {
    private static final long serialVersionUID = 1L;
    protected static final String C = "WarningIntegerParameter";
    protected static final boolean D = false;
    protected IntegerConstraint warningConstraint = null;
    protected transient ArrayList<ParameterChangeWarningListener> warningListeners = null;
    private boolean ignoreWarning;

    public WarningIntegerParameter(String name) {
        super(name);
    }

    public WarningIntegerParameter(String name, String units) {
        super(name, units);
    }

    public WarningIntegerParameter(String name, int min, int max) throws ConstraintException {
        super(name, min, max);
    }

    public WarningIntegerParameter(String name, int min, int max, String units) throws ConstraintException {
        super(name, min, max, units);
    }

    public WarningIntegerParameter(String name, Integer min, Integer max) throws ConstraintException {
        super(name, min, max);
    }

    public WarningIntegerParameter(String name, Integer min, Integer max, String units) throws ConstraintException {
        super(name, min, max, units);
    }

    public WarningIntegerParameter(String name, IntegerConstraint constraint) throws ConstraintException {
        super(name, constraint);
    }

    public WarningIntegerParameter(String name, IntegerConstraint constraint, String units) throws ConstraintException {
        super(name, (ParameterConstraint<Integer>)constraint, units);
    }

    public WarningIntegerParameter(String name, Integer value) {
        super(name, value);
    }

    public WarningIntegerParameter(String name, String units, Integer value) throws ConstraintException {
        super(name, units, value);
    }

    public WarningIntegerParameter(String name, int min, int max, Integer value) throws ConstraintException {
        super(name, min, max, value);
    }

    public WarningIntegerParameter(String name, IntegerConstraint constraint, Integer value) throws ConstraintException {
        super(name, (ParameterConstraint<Integer>)constraint, value);
    }

    public WarningIntegerParameter(String name, int min, int max, String units, Integer value) throws ConstraintException {
        super(name, min, max, units, value);
    }

    public WarningIntegerParameter(String name, Integer min, Integer max, String units, Integer value) throws ConstraintException {
        super(name, min, max, units, value);
    }

    public WarningIntegerParameter(String name, IntegerConstraint constraint, String units, Integer value) throws ConstraintException {
        super(name, (ParameterConstraint<Integer>)constraint, units, value);
    }

    @Override
    public synchronized void addParameterChangeWarningListener(ParameterChangeWarningListener listener) throws EditableException {
        String S = "WarningIntegerParameter: addParameterChangeWarningListener(): ";
        if (this.warningListeners == null) {
            this.warningListeners = new ArrayList();
        }
        if (!this.warningListeners.contains(listener)) {
            this.warningListeners.add(listener);
        }
    }

    @Override
    public synchronized void removeParameterChangeWarningListener(ParameterChangeWarningListener listener) throws EditableException {
        String S = "WarningIntegerParameter: removeParameterChangeWarningListener(): ";
        if (this.warningListeners != null && this.warningListeners.contains(listener)) {
            this.warningListeners.remove(listener);
        }
    }

    @Override
    public void setWarningConstraint(AbstractParameterConstraint warningConstraint) throws ParameterException, EditableException {
        String S = "WarningIntegerParameter: setWarningConstraint(): ";
        this.checkEditable(S);
        this.warningConstraint = (IntegerConstraint)warningConstraint;
    }

    @Override
    public AbstractParameterConstraint getWarningConstraint() throws ParameterException {
        return this.warningConstraint;
    }

    @Override
    public Integer getWarningMin() {
        if (this.warningConstraint != null) {
            return this.warningConstraint.getMin();
        }
        return null;
    }

    @Override
    public Integer getWarningMax() {
        if (this.warningConstraint != null) {
            return this.warningConstraint.getMax();
        }
        return null;
    }

    @Override
    public synchronized void setValue(Integer value) throws ConstraintException, WarningException {
        String S = this.getName() + ": setValue(): ";
        if (!this.isAllowed(value)) {
            String err = S + "Value is not allowed: ";
            if (value != null) {
                err = err + value.toString();
            }
            throw new ConstraintException(err);
        }
        if (value == null) {
            this.value = null;
        } else {
            if (!this.ignoreWarning && !this.isRecommended(value)) {
                ParameterChangeWarningEvent event = new ParameterChangeWarningEvent(this, this, this.value, value);
                this.fireParameterChangeWarning(event);
                throw new WarningException(S + "Value is not recommended: " + value.toString());
            }
            this.value = value;
            ParameterChangeEvent event = new ParameterChangeEvent(this, this.getName(), this.getValue(), value);
            this.firePropertyChange(event);
        }
    }

    @Override
    public void setValueIgnoreWarning(Integer value) throws ConstraintException, ParameterException {
        String S = "WarningIntegerParameter: setValueIgnoreWarning(): ";
        this.value = value;
    }

    @Override
    public boolean isRecommended(Integer obj) {
        if (this.warningConstraint != null) {
            return this.warningConstraint.isAllowed(obj);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireParameterChangeWarning(ParameterChangeWarningEvent event) {
        ArrayList vector;
        String S = "WarningIntegerParameter: firePropertyChange(): ";
        WarningIntegerParameter warningIntegerParameter = this;
        synchronized (warningIntegerParameter) {
            if (this.warningListeners == null) {
                return;
            }
            vector = (ArrayList)this.warningListeners.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ParameterChangeWarningListener listener = (ParameterChangeWarningListener)vector.get(i);
            listener.parameterChangeWarning(event);
        }
    }

    @Override
    public Object clone() {
        String S = "WarningIntegerParameter:clone(): ";
        IntegerConstraint c1 = null;
        IntegerConstraint c2 = null;
        if (this.constraint != null) {
            c1 = (IntegerConstraint)this.constraint.clone();
        }
        if (this.warningConstraint != null) {
            c2 = (IntegerConstraint)this.warningConstraint.clone();
        }
        WarningIntegerParameter param = null;
        param = this.value == null ? new WarningIntegerParameter(this.name, c1, this.units) : new WarningIntegerParameter(this.name, c1, this.units, Integer.valueOf(((Integer)this.value).toString()));
        if (param == null) {
            return null;
        }
        param.setWarningConstraint(c2);
        for (Parameter<?> p1 : this.getIndependentParameterList()) {
            Parameter p2 = (Parameter)p1.clone();
            param.addIndependentParameter(p2);
        }
        if (this.warningListeners != null) {
            for (ParameterChangeWarningListener listener : this.warningListeners) {
                param.addParameterChangeWarningListener(listener);
            }
        }
        param.setInfo(this.info);
        param.setIgnoreWarning(this.ignoreWarning);
        param.editable = true;
        return param;
    }

    @Override
    public void setIgnoreWarning(boolean ignoreWarning) {
        this.ignoreWarning = ignoreWarning;
    }

    @Override
    public boolean isIgnoreWarning() {
        return this.ignoreWarning;
    }
}

