/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.param.impl;

import org.dom4j.Element;
import org.opensha.commons.data.WeightedList;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.WeightedListParameterEditor;

public class WeightedListParameter<E>
extends AbstractParameter<WeightedList<E>> {
    private static final long serialVersionUID = 1L;
    WeightedListParameterEditor paramEdit;

    public WeightedListParameter(String name, WeightedList<E> value) {
        super(name, null, null, value);
    }

    @Override
    public ParameterEditor getEditor() {
        if (this.paramEdit == null) {
            this.paramEdit = new WeightedListParameterEditor((Parameter)this);
        }
        return this.paramEdit;
    }

    @Override
    public boolean isEditorBuilt() {
        return this.paramEdit != null;
    }

    @Override
    public boolean setIndividualParamValueFromXML(Element el) {
        if (this.value == null) {
            return false;
        }
        Element valEl = el.element("ComplexValue");
        Element listEl = valEl.element("WeightedList");
        ((WeightedList)this.value).setWeightsFromXMLMetadata(listEl);
        return true;
    }

    @Override
    public String getMetadataString() {
        WeightedList val = (WeightedList)this.getValue();
        if (val != null) {
            String str = this.name + " = [";
            for (int i = 0; i < val.size(); ++i) {
                if (i > 0) {
                    str = str + ", ";
                }
                String name = WeightedList.getName(val.get(i));
                str = str + "'" + name + "': " + val.getWeight(i);
            }
            str = str + "]";
            return str;
        }
        return this.name + " = null";
    }

    @Override
    public Object clone() {
        return null;
    }
}

