/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import com.google.common.base.Throwables;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Desktop;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class BrowserUtils {
    public static void launch(String url) {
        try {
            BrowserUtils.launch(new URL(url));
        }
        catch (MalformedURLException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public static void launch(URL url) {
        try {
            BrowserUtils.launch(url.toURI());
        }
        catch (URISyntaxException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public static void launch(URI uri) {
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (Throwable t) {
            try {
                new BrowserLauncher().openURLinBrowser(uri.toString());
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
    }
}

