/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ComparablePairing<C extends Comparable<C>, E>
implements Comparable<ComparablePairing<C, E>> {
    private C comparable;
    private E data;
    private Comparator<C> comparator;

    public ComparablePairing(C comparable, E data) {
        this.comparable = comparable;
        this.data = data;
    }

    public ComparablePairing(C comparable, E data, Comparator<C> comparator) {
        this.comparable = comparable;
        this.data = data;
        this.comparator = comparator;
    }

    @Override
    public int compareTo(ComparablePairing<C, E> o) {
        if (this.comparator != null) {
            return this.comparator.compare(this.comparable, o.comparable);
        }
        return this.comparable.compareTo(o.comparable);
    }

    public E getData() {
        return this.data;
    }

    public C getComparable() {
        return this.comparable;
    }

    public static <C extends Comparable<C>, E> List<ComparablePairing<C, E>> build(List<C> comparables, List<E> datas) {
        Preconditions.checkArgument((comparables.size() == datas.size() ? 1 : 0) != 0);
        ArrayList<ComparablePairing<C, ComparablePairing<Comparable, E>>> list = new ArrayList<ComparablePairing<C, ComparablePairing<Comparable, E>>>(datas.size());
        for (int i = 0; i < comparables.size(); ++i) {
            list.add(new ComparablePairing<Comparable, E>((Comparable)comparables.get(i), datas.get(i)));
        }
        return list;
    }

    public static <C extends Comparable<C>, E> List<E> getSortedData(Map<E, C> dataCompMap) {
        ArrayList<Comparable> comps = new ArrayList<Comparable>(dataCompMap.size());
        ArrayList<E> datas = new ArrayList<E>(dataCompMap.size());
        for (E data : dataCompMap.keySet()) {
            datas.add(data);
            comps.add((Comparable)dataCompMap.get(data));
        }
        return ComparablePairing.getSortedData(comps, datas);
    }

    public static <C extends Comparable<C>, E> List<E> getSortedData(List<C> comparables, List<E> datas) {
        List<ComparablePairing<C, E>> list = ComparablePairing.build(comparables, datas);
        Collections.sort(list);
        ArrayList<E> sortedDatas = new ArrayList<E>(list.size());
        for (ComparablePairing<C, E> elem : list) {
            sortedDatas.add(elem.getData());
        }
        return sortedDatas;
    }
}

