/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.SystemUtils;

public class FileUtils {
    protected static final String C = "FileUtils";
    protected static final boolean D = false;
    private static final String imagePath = "/images/";

    public static ArrayList<String> loadFile(String fileName) throws FileNotFoundException, IOException {
        return FileUtils.loadFile(fileName, true);
    }

    public static ArrayList<String> loadFile(String fileName, boolean skipBlankLines) throws FileNotFoundException, IOException {
        String S = "FileUtils: loadFile(): ";
        ArrayList<String> list = new ArrayList<String>();
        File f = new File(fileName);
        if (f.exists()) {
            boolean ok = true;
            boolean counter = false;
            FileReader in = new FileReader(fileName);
            LineNumberReader lin = new LineNumberReader(in);
            while (ok) {
                try {
                    String str = lin.readLine();
                    if (str != null) {
                        if (skipBlankLines && str.trim().equals("")) continue;
                        list.add(str);
                        continue;
                    }
                    ok = false;
                }
                catch (IOException e) {
                    ok = false;
                }
            }
            lin.close();
            in.close();
        }
        return list;
    }

    public static ArrayList<String> loadFile(URL url) throws IOException {
        URLConnection uc = url.openConnection();
        return FileUtils.loadStream((InputStream)uc.getContent());
    }

    public static ArrayList<String> loadStream(InputStream is) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader tis = new BufferedReader(new InputStreamReader(is));
        String str = tis.readLine();
        while (str != null) {
            list.add(str);
            str = tis.readLine();
        }
        tis.close();
        return list;
    }

    public static ArrayList<String> loadJarFile(String fileName) throws FileNotFoundException, IOException {
        try {
            if (!((String)fileName).startsWith("/")) {
                fileName = "/" + (String)fileName;
            }
            return FileUtils.loadFile(FileUtils.class.getResource((String)fileName));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveObjectInFile(String fileName, Object obj) throws IOException {
        FileOutputStream fileOut = new FileOutputStream(fileName);
        ObjectOutputStream objectStream = new ObjectOutputStream(fileOut);
        objectStream.writeObject(obj);
        objectStream.close();
        fileOut.close();
    }

    public static Object loadObjectFromURL(URL url) {
        try {
            URLConnection uc = url.openConnection();
            ObjectInputStream tis = new ObjectInputStream((InputStream)uc.getContent());
            Object obj = tis.readObject();
            tis.close();
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void createZipFile(File zipFile, File dir, boolean topLevelChildren) throws IOException {
        ArrayList<String> fileNames = new ArrayList<String>();
        if (topLevelChildren) {
            for (File file : dir.listFiles()) {
                FileUtils.populateZipFilePaths(fileNames, file, "");
            }
            FileUtils.createZipFile(zipFile.getAbsolutePath(), dir.getAbsolutePath(), fileNames);
        } else {
            FileUtils.populateZipFilePaths(fileNames, dir, "");
            FileUtils.createZipFile(zipFile.getAbsolutePath(), dir.getParentFile().getAbsolutePath(), fileNames);
        }
    }

    private static void populateZipFilePaths(ArrayList<String> fileNames, File file, String path) {
        if (file.isDirectory()) {
            path = (String)path + file.getName() + "/";
            for (File sub : file.listFiles()) {
                FileUtils.populateZipFilePaths(fileNames, sub, (String)path);
            }
        } else if (((String)path).isEmpty()) {
            fileNames.add(file.getName());
        } else {
            fileNames.add((String)path + file.getName());
        }
    }

    public static void createZipFile(String zipFile, String dir, Collection<String> fileNames) throws IOException {
        byte[] buffer = new byte[18024];
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
        if (((String)dir).length() > 0 && !((String)dir).endsWith(File.separator)) {
            dir = (String)dir + File.separator;
        }
        out.setLevel(-1);
        for (String file : fileNames) {
            int len;
            out.putNextEntry(new ZipEntry(file));
            File f = new File((String)dir + file);
            if (f.isDirectory()) continue;
            FileInputStream in = new FileInputStream(f);
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.closeEntry();
            in.close();
        }
        out.close();
    }

    public static void createZipFile(String filesPath) {
        int BUFFER = 8192;
        String zipFileName = "allFiles.zip";
        if (!((String)filesPath).endsWith(SystemUtils.FILE_SEPARATOR)) {
            filesPath = (String)filesPath + SystemUtils.FILE_SEPARATOR;
        }
        try {
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream((String)filesPath + zipFileName);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            out.setMethod(8);
            byte[] data = new byte[BUFFER];
            File f = new File((String)filesPath);
            String[] files = f.list();
            for (int i = 0; i < files.length; ++i) {
                int count;
                if (files[i].equals(zipFileName)) continue;
                System.out.println("Adding: " + files[i]);
                FileInputStream fi = new FileInputStream((String)filesPath + files[i]);
                origin = new BufferedInputStream(fi, BUFFER);
                ZipEntry entry = new ZipEntry(files[i]);
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, BUFFER)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unzipFile(File zipFile, File directory) throws FileNotFoundException, IOException {
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                new File(directory, entry.getName()).mkdir();
                continue;
            }
            FileUtils.copyInputStream(zip.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(new File(directory, entry.getName()))));
        }
        zip.close();
    }

    public static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static Object loadObject(String fileName) {
        try {
            FileInputStream fin = new FileInputStream(fileName);
            ObjectInputStream tis = new ObjectInputStream(fin);
            Object obj = tis.readObject();
            tis.close();
            fin.close();
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File createTempDir() throws IOException {
        File tempDir;
        String tempDirProp = System.getProperty("TempDir");
        if (tempDirProp != null) {
            Random r = new Random();
            tempDir = new File(tempDirProp, "openSHA" + r.nextInt(10000) + "temp");
            while (tempDir.exists()) {
                tempDir = new File(tempDirProp, "openSHA" + r.nextInt(10000) + "temp");
            }
        } else {
            tempDir = File.createTempFile("openSHA", "temp");
        }
        tempDir.delete();
        tempDir.mkdir();
        return tempDir;
    }

    public static boolean deleteRecursive(File f) {
        if (f.isFile()) {
            return f.delete();
        }
        for (File child : f.listFiles()) {
            FileUtils.deleteRecursive(child);
        }
        return f.delete();
    }

    public static Image loadImage(String fileName) {
        String imageFileName = imagePath + fileName;
        URL url = FileUtils.class.getResource(imageFileName);
        Image img = Toolkit.getDefaultToolkit().getImage(url);
        return img;
    }

    public static void downloadURL(String addr, File outFile) throws IOException {
        FileUtils.downloadURL(new URL(addr), outFile);
    }

    public static void downloadURL(URL url, File outFile) throws IOException {
        int bytesRead;
        InputStream in = url.openStream();
        System.out.println("Downloading " + String.valueOf(url) + " to " + outFile.getAbsolutePath());
        FileOutputStream out = new FileOutputStream(outFile);
        byte[] buf = new byte[4096];
        while ((bytesRead = in.read(buf)) > 0) {
            out.write(buf, 0, bytesRead);
        }
        in.close();
        out.close();
        System.out.println("DONE");
    }

    public static void print(PrintJob pjob, Graphics pg, String textToPrint) {
        int margin = 60;
        int pageNum = 1;
        int linesForThisPage = 0;
        int linesForThisJob = 0;
        if (!(pg instanceof PrintGraphics)) {
            throw new IllegalArgumentException("Graphics context not PrintGraphics");
        }
        StringReader sr = new StringReader(textToPrint);
        LineNumberReader lnr = new LineNumberReader(sr);
        int pageHeight = pjob.getPageDimension().height - margin;
        Font helv = new Font("Monaco", 0, 12);
        pg.setFont(helv);
        FontMetrics fm = pg.getFontMetrics(helv);
        int fontHeight = fm.getHeight();
        int fontDescent = fm.getDescent();
        int curHeight = margin;
        try {
            String nextLine;
            do {
                if ((nextLine = lnr.readLine()) == null) continue;
                if (curHeight + fontHeight > pageHeight) {
                    if (linesForThisPage == 0) break;
                    ++pageNum;
                    linesForThisPage = 0;
                    pg.dispose();
                    pg = pjob.getGraphics();
                    if (pg != null) {
                        pg.setFont(helv);
                    }
                    curHeight = 0;
                }
                curHeight += fontHeight;
                if (pg == null) continue;
                pg.drawString(nextLine, margin, curHeight - fontDescent);
                ++linesForThisPage;
                ++linesForThisJob;
            } while (nextLine != null);
        }
        catch (EOFException eOFException) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void save(String fileName, String dataToSave) {
        try {
            FileWriter fw = new FileWriter(fileName);
            fw.write(dataToSave);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

