/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.opensha.commons.data.xyz.ArbDiscrXYZ_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class GMT_GrdFile {
    private NetcdfFile file;
    private int xDim;
    private int yDim;
    private double xSpacing;
    private double ySpacing;
    private Array xData;
    private Array yData;
    private Array zData = null;
    private Index zInd = null;
    private Variable zVar;
    private static int[] singleShape = new int[]{1, 1};
    private Region region = null;

    public GMT_GrdFile(String fileName) throws IOException {
        this(fileName, true);
    }

    public GMT_GrdFile(String fileName, boolean cacheZ) throws IOException {
        this(NetcdfFile.open((String)fileName), cacheZ);
    }

    public GMT_GrdFile(URI uri) throws IOException {
        this(NetcdfFile.openInMemory((URI)uri), true);
    }

    public GMT_GrdFile(NetcdfFile file, boolean cacheZ) throws IOException {
        this.file = file;
        List dims = file.getDimensions();
        this.xDim = ((Dimension)dims.get(0)).getLength();
        this.yDim = ((Dimension)dims.get(1)).getLength();
        List vars = file.getVariables();
        Variable xVar = (Variable)vars.get(0);
        Variable yVar = (Variable)vars.get(1);
        this.xData = xVar.read();
        this.xSpacing = this.calcSpacing(this.xData);
        this.yData = yVar.read();
        this.ySpacing = this.calcSpacing(this.yData);
        this.zVar = (Variable)vars.get(2);
        if (cacheZ) {
            this.cacheZData();
        }
    }

    private double calcSpacing(Array data) {
        long max = 100L;
        if (max > data.getSize()) {
            max = data.getSize();
        }
        double tot = 0.0;
        int cnt = 0;
        int i = 0;
        while ((long)i < max - 1L) {
            double val1 = data.getDouble(i);
            double val2 = data.getDouble(i + 1);
            tot += Math.abs(val2 - val1);
            ++cnt;
            ++i;
        }
        return tot / (double)cnt;
    }

    public int getNumX() {
        return this.xDim;
    }

    public int getNumY() {
        return this.yDim;
    }

    public double getXSpacing() {
        return this.xSpacing;
    }

    public double getYSpacing() {
        return this.ySpacing;
    }

    public double getX(int x) {
        return this.xData.getDouble(x);
    }

    public Array getXData() {
        return this.xData;
    }

    public double getY(int y) {
        return this.yData.getDouble(y);
    }

    public Array getYData() {
        return this.yData;
    }

    public boolean isValidX_index(int x) {
        return x > 0 && x < this.getNumX();
    }

    public boolean isValidY_index(int y) {
        return y > 0 && y < this.getNumY();
    }

    public Location getLoc(int x, int y) {
        return new Location(this.getY(y), this.getX(x));
    }

    private double[] getFloatIndexes(Location loc) {
        double[] ret = new double[]{this.getFloatIndexY(loc), this.getFloatIndexX(loc)};
        return ret;
    }

    private double getFloatIndexX(Location loc) {
        double lon = loc.getLongitude();
        double minLon = this.getMinX();
        return (lon - minLon) / this.xSpacing;
    }

    private double getFloatIndexY(Location loc) {
        double lat = loc.getLatitude();
        double minLat = this.getMinY();
        return (lat - minLat) / this.ySpacing;
    }

    public double getWtAveZ(Location loc) throws IOException, InvalidRangeException {
        double[] ind = this.getFloatIndexes(loc);
        double x = ind[1];
        double y = ind[0];
        int x0 = (int)ind[1];
        int y0 = (int)ind[0];
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        double z00 = Double.NaN;
        double z01 = Double.NaN;
        double z10 = Double.NaN;
        double z11 = Double.NaN;
        boolean v00 = false;
        boolean v01 = false;
        boolean v10 = false;
        boolean v11 = false;
        if (this.isValidX_index(x0) && this.isValidY_index(y0)) {
            v00 = true;
            z00 = this.getZ(x0, y0);
        }
        if (this.isValidX_index(x1) && this.isValidY_index(y0)) {
            v10 = true;
            z10 = this.getZ(x1, y0);
        }
        if (this.isValidX_index(x0) && this.isValidY_index(y1)) {
            v01 = true;
            z01 = this.getZ(x0, y1);
        }
        if (this.isValidX_index(x1) && this.isValidY_index(y1)) {
            v11 = true;
            z11 = this.getZ(x1, y1);
        }
        double d00 = Math.sqrt((x - (double)x0) * (x - (double)x0) + (y - (double)y0) * (y - (double)y0));
        double d10 = Math.sqrt((x - (double)x1) * (x - (double)x1) + (y - (double)y0) * (y - (double)y0));
        double d01 = Math.sqrt((x - (double)x0) * (x - (double)x0) + (y - (double)y1) * (y - (double)y1));
        double d11 = Math.sqrt((x - (double)x1) * (x - (double)x1) + (y - (double)y1) * (y - (double)y1));
        double meanZ = 0.0;
        double wt = 0.0;
        if (!Double.isNaN(z00) & v00) {
            meanZ += z00 * d00;
            wt += d00;
        }
        if (!Double.isNaN(z10) && v10) {
            meanZ += z10 * d10;
            wt += d10;
        }
        if (!Double.isNaN(z01) & v01) {
            meanZ += z01 * d01;
            wt += d01;
        }
        if (!Double.isNaN(z11) & v11) {
            meanZ += z11 * d11;
            wt += d11;
        }
        return meanZ /= wt;
    }

    public double getInterpolatedZ(Location loc) throws IOException, InvalidRangeException {
        double[] ind = this.getFloatIndexes(loc);
        int x0 = (int)ind[1];
        int y0 = (int)ind[0];
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        float xfrac = (float)(ind[1] - (double)x0);
        float yfrac = (float)(ind[0] - (double)y0);
        float s00 = (float)this.getZ(x0, y0);
        float s01 = (float)this.getZ(x1, y0);
        float s10 = (float)this.getZ(x0, y1);
        float s11 = (float)this.getZ(x1, y1);
        float interp = GMT_GrdFile.interpolate(s00, s01, s10, s11, xfrac, yfrac);
        return interp;
    }

    private static float interpolate(float s00, float s01, float s10, float s11, float xfrac, float yfrac) {
        float s0 = (s01 - s00) * xfrac + s00;
        float s1 = (s11 - s10) * xfrac + s10;
        return (s1 - s0) * yfrac + s0;
    }

    public int[] getClosestPt(Location loc) {
        double[] fltPt = this.getFloatIndexes(loc);
        int y = (int)(fltPt[0] + 0.5);
        int x = (int)(fltPt[1] + 0.5);
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x >= this.xDim) {
            x = this.xDim - 1;
        }
        if (y >= this.yDim) {
            y = this.yDim - 1;
        }
        int[] pt = new int[]{y, x};
        return pt;
    }

    public double getClosestZ(Location loc) throws IOException, InvalidRangeException {
        return this.getZ(this.getClosestPt(loc));
    }

    public double getZ(int x, int y) throws IOException, InvalidRangeException {
        int[] pt = new int[]{y, x};
        return this.getZ(pt);
    }

    public double getZ(int[] pt) throws IOException, InvalidRangeException {
        if (this.zData != null) {
            this.zInd.set(pt);
            return this.zData.getDouble(this.zInd);
        }
        Array data = this.zVar.read(pt, singleShape).reduce();
        return data.getDouble(0);
    }

    public void cacheZData() throws IOException {
        if (this.zData == null) {
            this.zData = this.zVar.read();
            this.zInd = this.zData.getIndex();
        }
    }

    public Array getZData() throws IOException {
        this.cacheZData();
        return this.zData;
    }

    public String getZName() {
        return this.zVar.getName();
    }

    public double getMinX() {
        return this.getX(0);
    }

    public double getMaxX() {
        return this.getX(this.getNumX() - 1);
    }

    public double getMinY() {
        return this.getY(0);
    }

    public double getMaxY() {
        return this.getY(this.getNumY() - 1);
    }

    public Region getRegion() {
        if (this.region == null) {
            Location loc1 = new Location(this.getMinY(), this.getMinX());
            Location loc2 = new Location(this.getMaxY(), this.getMaxX());
            this.region = new Region(loc1, loc2);
        }
        return this.region;
    }

    public ArbDiscrXYZ_DataSet getXYZDataset(boolean latIsX) {
        ArbDiscrXYZ_DataSet xyz = new ArbDiscrXYZ_DataSet();
        for (int xInd = 0; xInd < this.getNumX(); ++xInd) {
            for (int yInd = 0; yInd < this.getNumY(); ++yInd) {
                double y;
                double x;
                if (latIsX) {
                    x = this.getY(yInd);
                    y = this.getX(xInd);
                } else {
                    y = this.getY(yInd);
                    x = this.getX(xInd);
                }
                try {
                    double z = this.getZ(xInd, yInd);
                    xyz.set(x, y, z);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return xyz;
    }

    public static void main(String[] args) throws IOException, InvalidRangeException, URISyntaxException {
        boolean cacheZ = true;
        GMT_GrdFile grd = new GMT_GrdFile(new URI("http://geohazards.cr.usgs.gov/staffweb/ghayes/Site/Slab1.0_files/sum_slab1.0_clip.grd"));
        System.out.println("NumX: " + grd.getNumX() + " NumY: " + grd.getNumY());
        System.out.println("SpacingX: " + grd.getXSpacing() + " SpacingY: " + grd.getYSpacing());
        System.out.println(grd.getRegion());
        int x = 1649;
        int y = 146;
        System.out.println(String.valueOf(grd.getLoc(x, y)) + ": " + grd.getZ(x, y));
        Location newLoc = new Location(-8.804, 123.9);
        System.out.println(String.valueOf(newLoc) + ": interp: " + grd.getInterpolatedZ(newLoc));
        System.out.println(String.valueOf(newLoc) + ":  close: " + grd.getClosestZ(newLoc));
    }
}

