/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import com.google.common.base.Preconditions;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.opensha.commons.util.ExceptionUtils;

public class LazilyInitializedList<E>
extends AbstractList<E> {
    private int size;
    private Callable<List<E>> callable;
    private List<E> list;

    public LazilyInitializedList(Callable<List<E>> callable) {
        this(-1, callable);
    }

    public LazilyInitializedList(int size, Callable<List<E>> callable) {
        this.size = size;
        this.callable = callable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInit() {
        if (this.list == null) {
            LazilyInitializedList lazilyInitializedList = this;
            synchronized (lazilyInitializedList) {
                if (this.list == null) {
                    List<E> list;
                    try {
                        list = this.callable.call();
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                    if (this.size < 0) {
                        this.size = list.size();
                    } else {
                        Preconditions.checkState((list.size() == this.size ? 1 : 0) != 0, (String)"Expected list of size=%s, have size=%s", (int)this.size, (int)list.size());
                    }
                    this.list = list;
                }
            }
        }
    }

    @Override
    public E get(int index) {
        this.checkInit();
        return this.list.get(index);
    }

    @Override
    public int size() {
        if (this.size < 0) {
            this.checkInit();
        }
        if (this.list == null) {
            return this.size;
        }
        return this.list.size();
    }

    @Override
    public boolean add(E e) {
        this.checkInit();
        return this.list.add(e);
    }

    @Override
    public E set(int index, E element) {
        this.checkInit();
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this.checkInit();
        this.list.add(index, element);
    }

    @Override
    public E remove(int index) {
        this.checkInit();
        return this.list.remove(index);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.checkInit();
        return this.list.addAll(index, c);
    }
}

