/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public final class MailUtil {
    public static MailProps loadMailPropsFromFile(String fileName) throws FileNotFoundException, IOException {
        Properties p = new Properties();
        p.load(new FileInputStream(fileName));
        return new MailProps(p);
    }

    public static void sendMail(String host, String from, String to, String mailSubject, String mailMessage) {
        MailProps p = new MailProps(to, host, mailSubject, from, true);
        MailUtil.sendMail(p, mailMessage);
    }

    public static void sendMail(MailProps p, String mailMessage) {
        if (!p.isEmailEnabled) {
            return;
        }
        try {
            Properties props = System.getProperties();
            props.put("mail.smtp.host", p.getSmtpHost());
            Session session = Session.getDefaultInstance((Properties)props, null);
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(p.getEmailFrom()));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(p.getEmailTo()));
            message.setSubject(p.getEmailSubject());
            message.setText(mailMessage);
            Transport.send((Message)message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
    }

    public static class MailProps {
        private String emailTo;
        private String smtpHost;
        private String emailSubject;
        private String emailFrom;
        private boolean isEmailEnabled;

        public MailProps(Properties p) {
            this.emailTo = (String)p.get("EmailTo");
            this.smtpHost = (String)p.get("SmtpHost");
            this.emailSubject = (String)p.get("Subject");
            this.emailFrom = (String)p.get("EmailFrom");
            this.isEmailEnabled = Boolean.valueOf((String)p.get("EmailEnabled"));
        }

        public MailProps(String emailTo, String smtpHost, String emailSubject, String emailFrom, boolean isEmailEnabled) {
            this.emailTo = emailTo;
            this.smtpHost = smtpHost;
            this.emailSubject = emailSubject;
            this.emailFrom = emailFrom;
            this.isEmailEnabled = isEmailEnabled;
        }

        public String getEmailTo() {
            return this.emailTo;
        }

        public void setEmailTo(String emailTo) {
            this.emailTo = emailTo;
        }

        public String getSmtpHost() {
            return this.smtpHost;
        }

        public void setSmtpHost(String smtpHost) {
            this.smtpHost = smtpHost;
        }

        public String getEmailSubject() {
            return this.emailSubject;
        }

        public void setEmailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
        }

        public String getEmailFrom() {
            return this.emailFrom;
        }

        public void setEmailFrom(String emailFrom) {
            this.emailFrom = emailFrom;
        }

        public boolean isEmailEnabled() {
            return this.isEmailEnabled;
        }

        public void setEmailEnabled(boolean isEmailEnabled) {
            this.isEmailEnabled = isEmailEnabled;
        }
    }
}

