/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;

public class XYZClosestPointFinder {
    private GeoDataSet dataset;

    public XYZClosestPointFinder(GeoDataSet dataset) {
        this.dataset = dataset;
    }

    public XYZClosestPointFinder(String fileName, boolean latitudeX) throws FileNotFoundException, IOException {
        this(ArbDiscrGeoDataSet.loadXYZFile(fileName, latitudeX));
    }

    public double getClosestVal(Location loc) {
        return this.getClosestVal(loc, Double.MAX_VALUE);
    }

    public double getClosestVal(double lat, double lon) {
        return this.getClosestVal(new Location(lat, lon), Double.MAX_VALUE);
    }

    public double getClosestVal(Location pt1, double tolerance) {
        Location closest = this.getClosestLoc(pt1, tolerance);
        if (closest != null) {
            return this.dataset.get(closest);
        }
        return Double.NaN;
    }

    public Location getClosestLoc(Location pt1, double tolerance) {
        int index;
        if (this.dataset instanceof GriddedGeoDataSet && (index = this.dataset.indexOf(pt1)) >= 0) {
            return this.dataset.getLocation(index);
        }
        double closest = Double.MAX_VALUE;
        Location closestLoc = null;
        for (int i = 0; i < this.dataset.size(); ++i) {
            Location pt2 = this.dataset.getLocation(i);
            double dist = LocationUtils.horzDistanceFast(pt1, pt2);
            if (!(dist < closest)) continue;
            closest = dist;
            closestLoc = pt2;
        }
        if (closest < tolerance) {
            return closestLoc;
        }
        return null;
    }

    public double getClosestVal(double lat, double lon, double tolerance) {
        return this.getClosestVal(new Location(lat, lon), tolerance);
    }
}

