/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.bugReports.knownBugImpl;

import org.opensha.commons.util.bugReports.BugReport;
import org.opensha.commons.util.bugReports.KnownBugDetector;

public class ExceptionTypeKnownBugDetector
implements KnownBugDetector {
    private Class<? extends Throwable> exceptionClass;
    private String desc;
    private String message;
    private boolean messageIsRegex = false;
    private String throwingClassName;
    private String methodName;
    private boolean canIgnore;

    public ExceptionTypeKnownBugDetector(Class<? extends Throwable> exceptionClass, String desc, boolean canIgnore) {
        this(exceptionClass, null, desc, canIgnore);
    }

    public ExceptionTypeKnownBugDetector(Class<? extends Throwable> exceptionClass, String message, String desc, boolean canIgnore) {
        this.init(exceptionClass, null, null, message, desc, canIgnore);
    }

    public ExceptionTypeKnownBugDetector(Class<? extends Throwable> exceptionClass, Class<?> throwingClass, String methodName, String message, String desc, boolean canIgnore) {
        this(exceptionClass, throwingClass.getName(), methodName, message, desc, canIgnore);
    }

    public ExceptionTypeKnownBugDetector(Class<? extends Throwable> exceptionClass, String throwingClassName, String methodName, String message, String desc, boolean canIgnore) {
        this.init(exceptionClass, throwingClassName, methodName, message, desc, canIgnore);
    }

    private void init(Class<? extends Throwable> exceptionClass, String throwingClassName, String methodName, String message, String desc, boolean canIgnore) {
        this.exceptionClass = exceptionClass;
        this.throwingClassName = throwingClassName;
        this.methodName = methodName;
        this.desc = desc;
        this.message = message;
        this.canIgnore = canIgnore;
    }

    public ExceptionTypeKnownBugDetector setMessageAsRegex() {
        this.messageIsRegex = true;
        return this;
    }

    @Override
    public boolean isKnownBug(BugReport bug) {
        Throwable t = bug.getThrowable();
        return this.isExceptionMatch(t);
    }

    private boolean isExceptionMatch(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t.getCause() != null && this.isExceptionMatch(t.getCause())) {
            return true;
        }
        if (t.getClass().equals(this.exceptionClass)) {
            String actualMethodName;
            String className;
            if (this.throwingClassName != null && !this.throwingClassName.isEmpty() && !(className = t.getStackTrace()[0].getClassName()).startsWith(this.throwingClassName)) {
                return false;
            }
            if (this.methodName != null && !this.methodName.equals(actualMethodName = t.getStackTrace()[0].getMethodName())) {
                return false;
            }
            if (this.message == null) {
                return true;
            }
            if (t.getMessage() != null) {
                if (this.messageIsRegex) {
                    return t.getMessage().matches(this.message);
                }
                return t.getMessage().startsWith(this.message);
            }
        }
        return false;
    }

    @Override
    public String getKnownBugDescription() {
        return this.desc;
    }

    @Override
    public boolean canIgnore() {
        return this.canIgnore;
    }
}

