/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.cpt;

import java.awt.Color;
import java.io.Serializable;
import org.dom4j.Element;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.util.XMLUtils;
import org.opensha.commons.util.cpt.CPT;

public class CPTVal
implements Comparable<CPTVal>,
Serializable,
Cloneable,
XMLSaveable {
    public static final String XML_METADATA_NAME = "CPTVal";
    public Color minColor;
    public Color maxColor;
    public double start;
    public double end;

    public CPTVal(double start, int minR, int minG, int minB, double end, int maxR, int maxG, int maxB) {
        this.minColor = new Color(minR, minG, minB);
        this.maxColor = new Color(maxR, maxG, maxB);
        this.start = start;
        this.end = end;
        if (start > end) {
            throw new IllegalArgumentException("Start value: [" + this.start + "] is greater than end value of: [" + this.end + "].");
        }
    }

    public CPTVal(double start, Color minColor, double end, Color maxColor) {
        this.minColor = minColor;
        this.maxColor = maxColor;
        this.start = start;
        this.end = end;
        if (start > end) {
            throw new IllegalArgumentException("Start value: [" + this.start + "] is greater than end value of: [" + this.end + "].");
        }
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element xml = root.addElement(XML_METADATA_NAME);
        Element start = xml.addElement("Start");
        XMLUtils.colorToXML(start, this.minColor);
        start.addAttribute("value", "" + this.start);
        Element end = xml.addElement("End");
        XMLUtils.colorToXML(end, this.maxColor);
        end.addAttribute("value", "" + this.end);
        return root;
    }

    public static CPTVal fromXMLMetadata(Element valElem) {
        Element startEl = valElem.element("Start");
        Color startColor = XMLUtils.colorFromXML(startEl.element("Color"));
        double minVal = Double.parseDouble(startEl.attributeValue("value"));
        Element endEl = valElem.element("End");
        Color endColor = XMLUtils.colorFromXML(endEl.element("Color"));
        double maxVal = Double.parseDouble(endEl.attributeValue("value"));
        return new CPTVal(minVal, startColor, maxVal, endColor);
    }

    @Override
    public int compareTo(CPTVal other) {
        if ((float)this.end <= (float)other.start) {
            return -1;
        }
        if ((float)this.start >= (float)other.end) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits((float)this.end);
        result = 31 * result + (this.maxColor == null ? 0 : this.maxColor.hashCode());
        result = 31 * result + (this.minColor == null ? 0 : this.minColor.hashCode());
        result = 31 * result + Float.floatToIntBits((float)this.start);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CPTVal other = (CPTVal)obj;
        if (Double.doubleToLongBits(this.end) != Double.doubleToLongBits(other.end)) {
            return false;
        }
        if (this.maxColor == null ? other.maxColor != null : !this.maxColor.equals(other.maxColor)) {
            return false;
        }
        if (this.minColor == null ? other.minColor != null : !this.minColor.equals(other.minColor)) {
            return false;
        }
        return Double.doubleToLongBits(this.start) == Double.doubleToLongBits(other.start);
    }

    public boolean contains(float value) {
        return (float)this.start <= value && value < (float)this.end;
    }

    public String toString() {
        return (float)this.start + "\t" + CPT.tabDelimColor(this.minColor) + "\t" + (float)this.end + "\t" + CPT.tabDelimColor(this.maxColor);
    }

    public Object clone() {
        return new CPTVal(this.start, this.minColor, this.end, this.maxColor);
    }
}

