/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.io.archive;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.StringConcatFactory;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarFile;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.opensha.commons.data.Named;

public interface ArchiveInput
extends Named,
Closeable {
    public boolean hasEntry(String var1) throws IOException;

    default public boolean isDirecotry(String name) {
        return name.endsWith("/");
    }

    public InputStream getInputStream(String var1) throws IOException;

    default public Iterable<String> getEntries() throws IOException {
        Stream<String> stream = this.entryStream();
        return () -> stream.iterator();
    }

    public Stream<String> entryStream() throws IOException;

    public static ArchiveInput getDefaultInput(File file) throws IOException {
        if (file.isDirectory()) {
            return new DirectoryInput(file.toPath());
        }
        String name = file.getName().toLowerCase();
        if (name.endsWith(".tar")) {
            return new TarFileInput(file);
        }
        return new ZipFileInput(file);
    }

    public static class DirectoryInput
    extends AbstractFileSystemInput
    implements FileBacked {
        private Path dirPath;

        public DirectoryInput(Path path) throws IOException {
            super(DirectoryInput.checkPath(path));
            this.dirPath = path.toAbsolutePath();
        }

        private static Path checkPath(Path path) throws IOException {
            Preconditions.checkState((Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]) ? 1 : 0) != 0, (String)"Path already exists and is not a directory: %s", (Object)path);
            return path.toAbsolutePath();
        }

        @Override
        public String getName() {
            return this.dirPath.toString();
        }

        @Override
        public File getInputFile() {
            return this.dirPath.toFile();
        }

        @Override
        public void close() throws IOException {
            this.fs = null;
        }
    }

    public static class TarFileInput
    extends AbstractTarInput
    implements FileBacked {
        private File tarFile;

        public TarFileInput(File tarFile) throws IOException {
            super(new TarFile(tarFile));
            this.tarFile = tarFile;
        }

        @Override
        public File getInputFile() {
            return this.tarFile;
        }
    }

    public static class ZipFileInput
    implements FileBacked {
        private File inputFile;
        java.util.zip.ZipFile zip;
        private ZipEntry prevEntry;

        public ZipFileInput(File file) throws IOException {
            this(new java.util.zip.ZipFile(file));
            this.inputFile = file;
        }

        public ZipFileInput(java.util.zip.ZipFile zip) {
            this.zip = zip;
            this.inputFile = new File(zip.getName());
        }

        @Override
        public boolean hasEntry(String name) {
            return this.getEntry(name) != null;
        }

        protected ZipEntry getEntry(String name) {
            ZipEntry cached = this.prevEntry;
            if (cached != null && cached.getName().equals(name)) {
                return cached;
            }
            ZipEntry entry = this.zip.getEntry(name);
            if (entry != null) {
                this.prevEntry = entry;
            }
            return entry;
        }

        @Override
        public InputStream getInputStream(String name) throws IOException {
            ZipEntry entry = this.getEntry(name);
            Preconditions.checkNotNull((Object)entry, (String)"Couldn't locate entry: %s", (Object)name);
            return this.zip.getInputStream(entry);
        }

        @Override
        public Iterable<String> getEntries() throws IOException {
            Stream<String> stream = this.entryStream();
            return () -> stream.iterator();
        }

        @Override
        public Stream<String> entryStream() throws IOException {
            return this.zip.stream().map(ZipEntry::getName);
        }

        @Override
        public String getName() {
            return this.zip.getName();
        }

        @Override
        public void close() throws IOException {
            this.zip.close();
        }

        @Override
        public File getInputFile() {
            return this.inputFile;
        }
    }

    public static class ZipFileSystemInput
    extends AbstractFileSystemInput
    implements FileBacked {
        private Path zipPath;

        public ZipFileSystemInput(Path path) throws IOException {
            super(ZipFileSystemInput.initFS(path));
            this.zipPath = path.toAbsolutePath();
        }

        private static FileSystem initFS(Path path) throws IOException {
            URI uri = URI.create("jar:" + path.toUri().toString());
            Map<String, String> env = Map.of("create", "false");
            return FileSystems.newFileSystem(uri, env);
        }

        @Override
        public String getName() {
            return this.zipPath.toString();
        }

        @Override
        public File getInputFile() {
            return this.zipPath.toFile();
        }
    }

    public static abstract class AbstractFileSystemInput
    implements ArchiveInput {
        protected FileSystem fs;
        private Path upstream;
        private String prevName;
        private Path prevPath;

        public AbstractFileSystemInput(FileSystem fs) {
            this.fs = fs;
        }

        public AbstractFileSystemInput(Path upstream) {
            this.upstream = upstream;
        }

        @Override
        public boolean hasEntry(String name) throws IOException {
            return this.getPath(name) != null;
        }

        private Path getPath(String name) {
            Path cached = this.prevPath;
            if (cached != null && this.prevName.equals(name)) {
                return cached;
            }
            Path path = this.upstream != null ? this.upstream.resolve(name) : this.fs.getPath(name, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            this.prevName = name;
            this.prevPath = path;
            return path;
        }

        @Override
        public InputStream getInputStream(String name) throws IOException {
            Path path = this.getPath(name);
            return new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
        }

        @Override
        public Stream<String> entryStream() throws IOException {
            int trimSize;
            Path root;
            if (this.upstream != null) {
                root = this.upstream;
                String rootStr = root.toString();
                trimSize = rootStr.length() + (!rootStr.endsWith("/") || !rootStr.endsWith("\\") ? 1 : 0);
            } else {
                root = this.fs.getRootDirectories().iterator().next();
                trimSize = 1;
            }
            return Files.walk(root, new FileVisitOption[0]).filter(P -> !Files.isDirectory(P, new LinkOption[0])).map(Path::toString).map(S -> S.substring(trimSize)).filter(S -> !S.isBlank());
        }

        @Override
        public void close() throws IOException {
            if (this.fs == null) {
                return;
            }
            this.fs.close();
            this.fs = null;
        }
    }

    public static abstract class AbstractTarInput
    implements ArchiveInput {
        private TarFile tar;
        private List<TarArchiveEntry> entries;
        private Map<String, TarArchiveEntry> entryMap;

        public AbstractTarInput(TarFile tar) {
            this.tar = tar;
            this.entries = tar.getEntries();
            this.entryMap = this.entries.stream().collect(Collectors.toMap(TarArchiveEntry::getName, entry -> entry));
        }

        @Override
        public boolean hasEntry(String name) {
            return this.entryMap.containsKey(name);
        }

        TarArchiveEntry getEntry(String name) {
            return this.entryMap.get(name);
        }

        @Override
        public InputStream getInputStream(String name) throws IOException {
            return this.tar.getInputStream(this.getEntry(name));
        }

        @Override
        public Stream<String> entryStream() throws IOException {
            return this.entryMap.keySet().stream();
        }

        @Override
        public void close() throws IOException {
            this.tar.close();
        }
    }

    public static class ApacheZipFileInput
    extends AbstractApacheZipInput
    implements FileBacked {
        private File file;

        public ApacheZipFileInput(File file) throws IOException {
            super(((ZipFile.Builder)ZipFile.builder().setFile(file)).get());
            this.file = file;
        }

        @Override
        public File getInputFile() {
            return this.file;
        }
    }

    public static class InMemoryZipInput
    extends AbstractApacheZipInput {
        public InMemoryZipInput(SeekableByteChannel byteChannel) throws IOException {
            super(ZipFile.builder().setSeekableByteChannel(byteChannel).get());
        }

        @Override
        public String getName() {
            return "In Memory";
        }
    }

    public static abstract class AbstractApacheZipInput
    implements ArchiveInput {
        private ZipFile zip;
        private ZipArchiveEntry prevEntry;

        public AbstractApacheZipInput(ZipFile zip) {
            this.zip = zip;
        }

        @Override
        public boolean hasEntry(String name) {
            return this.getEntry(name) != null;
        }

        ZipArchiveEntry getEntry(String name) {
            ZipArchiveEntry cached = this.prevEntry;
            if (cached != null && cached.getName().equals(name)) {
                return cached;
            }
            ZipArchiveEntry entry = this.zip.getEntry(name);
            if (entry != null) {
                this.prevEntry = entry;
            }
            return entry;
        }

        InputStream getRawInputStream(ZipArchiveEntry entry) throws IOException {
            return this.zip.getRawInputStream(entry);
        }

        @Override
        public InputStream getInputStream(String name) throws IOException {
            ZipArchiveEntry entry = this.getEntry(name);
            Preconditions.checkNotNull((Object)entry, (String)"Couldn't locate entry: %s", (Object)name);
            return this.zip.getInputStream(entry);
        }

        private Spliterator<String> entryNameSpliterator() {
            return Spliterators.spliteratorUnknownSize(new Iterator<String>(){
                private final Enumeration<? extends ZipArchiveEntry> entries;
                {
                    this.entries = zip.getEntries();
                }

                @Override
                public boolean hasNext() {
                    return this.entries.hasMoreElements();
                }

                @Override
                public String next() {
                    return this.entries.nextElement().getName();
                }
            }, 16);
        }

        @Override
        public Stream<String> entryStream() throws IOException {
            return StreamSupport.stream(this.entryNameSpliterator(), false);
        }

        @Override
        public void close() throws IOException {
            this.zip.close();
        }
    }

    public static class PreloadingZipFileInput
    extends ZipFileInput {
        public PreloadingZipFileInput(File file) throws IOException {
            super(file);
        }

        public PreloadingZipFileInput(java.util.zip.ZipFile zip) throws IOException {
            super(zip);
        }

        @Override
        public synchronized InputStream getInputStream(String name) throws IOException {
            ZipEntry entry = this.getEntry(name);
            long size = entry.getSize();
            if (size < 0L) {
                try (InputStream is = this.zip.getInputStream(entry);){
                    ByteArrayInputStream byteArrayInputStream;
                    try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                        int len;
                        byte[] buffer = new byte[8192];
                        while ((len = is.read(buffer)) != -1) {
                            baos.write(buffer, 0, len);
                        }
                        byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
                    }
                    return byteArrayInputStream;
                }
            }
            if (size > Integer.MAX_VALUE) {
                throw new IOException("Entry too large to fit in memory: " + size + " bytes");
            }
            byte[] data = new byte[(int)size];
            try (InputStream is = this.zip.getInputStream(entry);){
                int read;
                for (int offset = 0; offset < data.length; offset += read) {
                    read = is.read(data, offset, data.length - offset);
                    if (read != -1) continue;
                    throw new IOException("Unexpected end of stream for entry: " + entry.getName());
                }
            }
            return new ByteArrayInputStream(data);
        }
    }

    public static interface FileBacked
    extends ArchiveInput {
        public File getInputFile();

        @Override
        default public String getName() {
            File inputFile = this.getInputFile();
            if (inputFile == null) {
                return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"null"});
            }
            return this.getInputFile().getAbsolutePath();
        }
    }
}

