/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.io.archive;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.io.archive.CopyAvoidantInMemorySeekableByteChannel;

class AsynchronousApacheZipper {
    private CopyAvoidantInMemorySeekableByteChannel uncompressedData = new CopyAvoidantInMemorySeekableByteChannel(0x2000000);
    private CopyAvoidantInMemorySeekableByteChannel compressedData;
    private WriteShieldAfterCloseOutputStream currentOutput;
    private String entrySourceName;
    private String entryDestName;
    private boolean externalInput;
    private ArchiveInput.AbstractApacheZipInput entryInput;

    AsynchronousApacheZipper() {
        this.uncompressedData.setCloseable(false);
        this.compressedData = new CopyAvoidantInMemorySeekableByteChannel(0x500000);
        this.compressedData.setCloseable(false);
    }

    public void reset() {
        this.entrySourceName = null;
        this.entryDestName = null;
        this.entryInput = null;
        this.externalInput = false;
        this.uncompressedData.truncate(0L);
        this.compressedData.truncate(0L);
    }

    public boolean hasEntry() {
        return this.entryDestName != null;
    }

    public boolean hasEntryData() {
        Preconditions.checkState((boolean)this.hasEntry());
        return this.entryInput != null;
    }

    public String getEntrySourceName() {
        return this.entrySourceName;
    }

    public String getEntryDestName() {
        return this.entrySourceName;
    }

    CopyAvoidantInMemorySeekableByteChannel swapCompressedDataBuffer(CopyAvoidantInMemorySeekableByteChannel newBuffer) {
        if (newBuffer == null) {
            newBuffer = new CopyAvoidantInMemorySeekableByteChannel(Integer.max(0x500000, (int)this.compressedData.size()));
            newBuffer.setCloseable(false);
        }
        CopyAvoidantInMemorySeekableByteChannel oldBuffer = this.compressedData;
        this.compressedData = newBuffer;
        return oldBuffer;
    }

    public void rawTransferEntryTo(ArchiveOutput.AbstractApacheZipOutput output) throws IOException {
        output.rawTransferApache(this.entryInput, this.entrySourceName, this.entryDestName);
        if (!this.externalInput) {
            this.entryInput.close();
        }
        this.entryInput = null;
    }

    public CompletableFuture<Void> rawTransferFuture(final ArchiveOutput.AbstractApacheZipOutput output) {
        final boolean externalInput = this.externalInput;
        final ArchiveInput.AbstractApacheZipInput myInput = this.entryInput;
        final String entrySourceName = this.entrySourceName;
        final String entryDestName = this.entryDestName;
        this.entryInput = null;
        return CompletableFuture.runAsync(new Runnable(){
            final /* synthetic */ AsynchronousApacheZipper this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    output.rawTransferApache(myInput, entrySourceName, entryDestName);
                    if (!externalInput) {
                        myInput.close();
                    }
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException((Throwable)e);
                }
            }
        });
    }

    public void putNextEntry(String name) {
        Preconditions.checkState((this.entrySourceName == null ? 1 : 0) != 0, (Object)"didn't close prior entry");
        Preconditions.checkState((this.currentOutput == null ? 1 : 0) != 0, (Object)"didn't close prior entry");
        this.entrySourceName = name;
        this.entryDestName = name;
    }

    public OutputStream getOutputStream() {
        Preconditions.checkNotNull((Object)this.entrySourceName, (Object)"Not currently writing");
        Preconditions.checkState((this.currentOutput == null ? 1 : 0) != 0, (String)"Already called getOutputStream() for entry '%s'", (Object)this.entryDestName);
        this.currentOutput = new WriteShieldAfterCloseOutputStream(this.uncompressedData.getOutputStream());
        return this.currentOutput;
    }

    public CompletableFuture<AsynchronousApacheZipper> transferFrom(ArchiveInput input, String sourceName, String destName) throws IOException {
        Preconditions.checkState((this.entrySourceName == null ? 1 : 0) != 0, (Object)"didn't close prior entry");
        if (input instanceof ArchiveInput.AbstractApacheZipInput) {
            this.entryInput = (ArchiveInput.AbstractApacheZipInput)input;
            this.entrySourceName = sourceName;
            this.entryDestName = destName;
            this.externalInput = true;
            return CompletableFuture.completedFuture(this);
        }
        this.putNextEntry(destName);
        input.getInputStream(sourceName).transferTo(this.getOutputStream());
        return this.closeEntry();
    }

    public CompletableFuture<AsynchronousApacheZipper> closeEntry() throws IOException {
        if (this.currentOutput != null) {
            this.currentOutput.flush();
            this.currentOutput.lock();
            this.currentOutput = null;
        }
        if (this.uncompressedData.size() == 0L) {
            return CompletableFuture.completedFuture(this);
        }
        return CompletableFuture.supplyAsync(new Supplier<AsynchronousApacheZipper>(){

            @Override
            public AsynchronousApacheZipper get() {
                try {
                    Preconditions.checkState((AsynchronousApacheZipper.this.compressedData.size() == 0L ? 1 : 0) != 0);
                    Preconditions.checkState((AsynchronousApacheZipper.this.compressedData.position() == 0L ? 1 : 0) != 0);
                    ZipArchiveOutputStream zout = new ZipArchiveOutputStream((SeekableByteChannel)AsynchronousApacheZipper.this.compressedData);
                    ZipArchiveEntry entry = new ZipArchiveEntry(AsynchronousApacheZipper.this.entryDestName);
                    zout.putArchiveEntry(entry);
                    long compressedPosPrior = AsynchronousApacheZipper.this.compressedData.position();
                    AsynchronousApacheZipper.this.uncompressedData.position(0L);
                    Preconditions.checkState((AsynchronousApacheZipper.this.uncompressedData.position() == 0L ? 1 : 0) != 0);
                    AsynchronousApacheZipper.this.uncompressedData.getInputStream().transferTo((OutputStream)zout);
                    zout.flush();
                    zout.closeArchiveEntry();
                    zout.close();
                    long compressedPosAfter = AsynchronousApacheZipper.this.compressedData.position();
                    long uncompressedPos = AsynchronousApacheZipper.this.uncompressedData.position();
                    long uncompressedSize = AsynchronousApacheZipper.this.uncompressedData.size();
                    Preconditions.checkState((uncompressedPos == uncompressedSize ? 1 : 0) != 0, (String)"uncompressedData.position()=%s after write, uncompressedData.size()=%s", (long)uncompressedPos, (long)uncompressedSize);
                    Preconditions.checkState((compressedPosAfter > compressedPosPrior ? 1 : 0) != 0, (String)"compressedData.position()=%s after write, compressedData.position()=%s before write", (long)compressedPosAfter, (long)compressedPosPrior);
                    Preconditions.checkState((AsynchronousApacheZipper.this.compressedData.size() > 0L ? 1 : 0) != 0);
                    AsynchronousApacheZipper.this.compressedData.position(0L);
                    AsynchronousApacheZipper.this.entryInput = new ArchiveInput.InMemoryZipInput(AsynchronousApacheZipper.this.compressedData);
                    return AsynchronousApacheZipper.this;
                }
                catch (IOException e) {
                    throw new RuntimeException("Exception writing " + AsynchronousApacheZipper.this.entryDestName, e);
                }
            }
        });
    }

    static class WriteShieldAfterCloseOutputStream
    extends OutputStream {
        private OutputStream out;
        private boolean locked = false;

        public WriteShieldAfterCloseOutputStream(OutputStream out) {
            this.out = out;
        }

        public void lock() {
            this.locked = true;
        }

        public boolean isLocked() {
            return this.locked;
        }

        @Override
        public void write(int b) throws IOException {
            Preconditions.checkState((!this.locked ? 1 : 0) != 0, (Object)"Tried to write to an entry's OutputStream after it was already closed?");
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Preconditions.checkState((!this.locked ? 1 : 0) != 0, (Object)"Tried to write to an entry's OutputStream after it was already closed?");
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            Preconditions.checkState((!this.locked ? 1 : 0) != 0, (Object)"Tried to flush an entry's OutputStream after it was already closed?");
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            throw new IllegalStateException("Should never call close() on the archive's OutputStream, only flush()");
        }
    }
}

