/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.modules;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.zip.ZipFile;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.ModuleContainer;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.commons.util.modules.SubModule;

public class ModuleArchive<E extends OpenSHA_Module>
extends ModuleContainer<E> {
    private ArchiveInput input;
    public static final String MODULE_FILE_NAME = "modules.json";
    private static Gson manifestGson = null;

    public ModuleArchive() {
    }

    public ModuleArchive(File file) throws IOException {
        this(file, null);
    }

    public ModuleArchive(File file, Class<? extends E> preloadClass) throws IOException {
        this(new ArchiveInput.ZipFileInput(file), preloadClass);
    }

    public ModuleArchive(ZipFile zip) throws IOException {
        this(zip, null);
    }

    public ModuleArchive(ZipFile zip, Class<? extends E> preloadClass) throws IOException {
        this(new ArchiveInput.ZipFileInput(zip), preloadClass);
    }

    public ModuleArchive(ArchiveInput input) throws IOException {
        this(input, null);
    }

    public ModuleArchive(ArchiveInput input, Class<? extends E> preloadClass) throws IOException {
        this.input = input;
        if (this.verbose) {
            System.out.println("------------ LOADING ARCHIVE ------------");
            System.out.println("Archive: " + input.getName());
        }
        ModuleArchive.loadModules(this, input, ModuleArchive.getPrefix(null, this.getNestingPrefix()), preloadClass, new HashSet<String>(), this.verbose);
        List modules = this.getModules(false);
        if (this.verbose && !modules.isEmpty()) {
            System.out.println("Loaded " + modules.size() + " top-level modules");
        }
        List availableModules = this.getAvailableModules();
        if (this.verbose && !availableModules.isEmpty()) {
            System.out.println("Loaded " + availableModules.size() + " available top-level modules");
        }
        if (this.verbose) {
            System.out.println("---------- END LOADING ARCHIVE ----------");
        }
    }

    public ArchiveInput getInput() {
        return this.input;
    }

    public static <E extends OpenSHA_Module> void loadModules(ModuleContainer<E> container, ArchiveInput input, String prefix, Class<? extends E> preloadClass, HashSet<String> prevPrefixes, boolean verbose) throws IOException {
        prefix = prefix == null ? "" : prefix.trim();
        Preconditions.checkState((!prevPrefixes.contains(prefix) ? 1 : 0) != 0, (String)"Found container with duplicate path, we've already loaded a container with path: '%s'", (Object)prefix);
        prevPrefixes.add(prefix);
        String entryName = prefix + MODULE_FILE_NAME;
        if (!input.hasEntry(entryName)) {
            if (verbose) {
                System.out.println("Modules index not found in zip file, skipping loading sub-modules: " + entryName);
            }
            return;
        }
        InputStream zin = input.getInputStream(entryName);
        List<ModuleRecord> records = ModuleArchive.loadModulesManifest(zin);
        for (ModuleRecord record : records) {
            Class<?> moduleClass;
            Class<?> clazz;
            if (verbose) {
                System.out.println("\tFound available module '" + record.name + "' with path='" + record.path + "'");
            }
            try {
                clazz = Class.forName(record.className);
            }
            catch (Exception e) {
                System.err.println("WARNING: Skipping module '" + record.name + "', couldn't locate class: " + record.className);
                continue;
            }
            try {
                moduleClass = clazz;
            }
            catch (Exception e) {
                System.err.println("WARNING: cannot load module '" + record.name + "' as the loading class isn't of the specified type: " + e.getMessage());
                continue;
            }
            if (ModuleContainer.class.isAssignableFrom(moduleClass)) {
                record.path = record.path.trim();
                Preconditions.checkState((!record.path.isBlank() ? 1 : 0) != 0, (String)"Module '%s' is also a container but does not supply a path.Container modules must always supply a custom path, otherwise we would keep loading the same top-level modules.json file in an infinite loop.", (Object)record.name);
                Preconditions.checkState((prefix.isBlank() || record.path.startsWith(prefix) ? 1 : 0) != 0, (String)"Module '%s' is a container but it's supplied path ('%s') is not nested within the parent module's path ('%s')", (Object)record.name, (Object)record.path, (Object)prefix);
                Preconditions.checkState((!prevPrefixes.contains(record.path) ? 1 : 0) != 0, (String)"Module '%s' is a container with a duplicate path, we've already loaded a container with path: '%s'", (Object)record.name, (Object)record.path);
            }
            ArchiveLoadCallable call = new ArchiveLoadCallable(record, moduleClass, input, container, prevPrefixes, verbose);
            if (preloadClass != null && preloadClass.isAssignableFrom(moduleClass)) {
                Object module = null;
                try {
                    module = call.call();
                }
                catch (Exception e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
                if (module == null) {
                    throw new IllegalStateException("Failed to load module that matches pre-load class", call.t);
                }
                container.addModule(module);
                continue;
            }
            container.addAvailableModule(call, moduleClass);
        }
        zin.close();
    }

    public <M extends E> M loadUnlistedModule(Class<? extends M> loadingClass, String entryPrefix) {
        return this.loadUnlistedModule(loadingClass, entryPrefix, this);
    }

    public synchronized <M extends E> M loadUnlistedModule(Class<? extends M> loadingClass, String entryPrefix, ModuleContainer<E> container) {
        ModuleRecord record = new ModuleRecord("Unlisted Module", loadingClass.getName(), entryPrefix, null);
        Preconditions.checkNotNull((Object)this.input, (Object)"Can only unlisted modules for an archives loaded from an existing archives");
        ArchiveLoadCallable<M> call = new ArchiveLoadCallable<M>(record, loadingClass, this.input, container, new HashSet<String>(), this.verbose);
        try {
            Object module = call.call();
            container.addModule(module);
            return (M)module;
        }
        catch (ClassCastException e) {
            throw e;
        }
        catch (Exception e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    public void write(File outputFile) throws IOException {
        this.write(outputFile, this.input != null);
    }

    public void write(File outputFile, boolean copySourceFiles) throws IOException {
        this.write(ArchiveOutput.getDefaultOutput(outputFile, this.input), copySourceFiles);
    }

    public void write(ArchiveOutput output) throws IOException {
        this.write(output, this.input != null);
    }

    public void write(ArchiveOutput output, boolean copySourceFiles) throws IOException {
        ArchiveOutput.FileBacked fb = null;
        if (this.verbose) {
            System.out.println("------------ WRITING ARCHIVE ------------");
            if (output instanceof ArchiveOutput.FileBacked) {
                fb = (ArchiveOutput.FileBacked)output;
                if (!fb.getDestinationFile().equals(fb.getInProgressFile())) {
                    System.out.println("Temporary archive: " + fb.getInProgressFile().getAbsolutePath());
                } else {
                    System.out.println("Archive: " + output.getName());
                }
            } else {
                System.out.println("Archive: " + output.getName());
            }
        }
        copySourceFiles = copySourceFiles && this.input != null;
        EntryTrackingArchiveOutput trackOutput = new EntryTrackingArchiveOutput(output);
        ModuleArchive.writeModules(this, trackOutput, null, new HashSet<String>(), this.verbose);
        if (copySourceFiles) {
            for (String entry : this.input.getEntries()) {
                if (trackOutput.writtenEntries.contains(entry)) continue;
                if (this.verbose) {
                    System.out.println("Copying over unknown file from previous archive: " + entry);
                }
                trackOutput.transferFrom(this.input, entry);
            }
        }
        if (this.verbose && fb != null && !fb.getDestinationFile().equals(fb.getInProgressFile())) {
            System.out.println("Moving to " + fb.getDestinationFile().getAbsolutePath());
        }
        trackOutput.close();
        if (this.verbose) {
            System.out.println("---------- END WRITING ARCHIVE ----------");
        }
    }

    public static <E extends OpenSHA_Module> boolean writeModules(ModuleContainer<E> container, ArchiveOutput output, String prefix, HashSet<String> prevPrefixes, boolean verbose) throws IOException {
        EntryTrackingArchiveOutput trackOutput = output instanceof EntryTrackingArchiveOutput ? (EntryTrackingArchiveOutput)output : new EntryTrackingArchiveOutput(output);
        ArrayList<ModuleRecord> records = new ArrayList<ModuleRecord>();
        prefix = prefix == null ? "" : prefix.trim();
        Preconditions.checkState((!prevPrefixes.contains(prefix) ? 1 : 0) != 0, (String)"Duplicate prefix detected in archive: %s", (Object)prefix);
        prevPrefixes.add(prefix);
        Object moduleStr = container.getClass().equals(ModuleArchive.class) ? "modules" : (container instanceof OpenSHA_Module ? "nested modules from '" + ((OpenSHA_Module)((Object)container)).getName() + "'" : "nested modules from '" + container.getClass().getName() + "'");
        if (verbose) {
            System.out.println("Writing " + container.getModules().size() + " " + (String)moduleStr + (String)(prefix.isBlank() ? "" : " with prefix='" + prefix + "'"));
        }
        for (OpenSHA_Module module : container.getModules(true)) {
            if (module instanceof ArchivableModule) {
                Object modulePrefix;
                ArchivableModule archivable = (ArchivableModule)module;
                if (verbose) {
                    System.out.println("\tWriting module: " + module.getName());
                }
                try {
                    Preconditions.checkNotNull(archivable.getLoadingClass().getDeclaredConstructor(new Class[0]));
                }
                catch (Throwable t) {
                    System.err.println("WARNING: Loading class for module doesn't contain a no-arg constructor, loading from a zip file will fail: " + archivable.getLoadingClass().getName());
                }
                ArrayList<String> moduleAssets = new ArrayList<String>();
                if (module instanceof ModuleContainer && module != container) {
                    ModuleContainer archive = (ModuleContainer)((Object)module);
                    String nestingPrefix = archive.getNestingPrefix();
                    Preconditions.checkState((nestingPrefix != null && !nestingPrefix.isEmpty() ? 1 : 0) != 0, (String)"Module '%s' is a nested archive but does not override getNestingPrefix() to provide a non-empty nesting prefix (supplied: '%s')", (Object)module.getName(), (Object)nestingPrefix);
                    String downstreamPrefix = prefix + nestingPrefix;
                    output.putNextEntry(downstreamPrefix);
                    output.closeEntry();
                    if (ModuleArchive.writeModules(archive, trackOutput, downstreamPrefix, prevPrefixes, verbose)) {
                        moduleAssets.add(MODULE_FILE_NAME);
                    }
                    modulePrefix = downstreamPrefix;
                } else {
                    modulePrefix = prefix;
                }
                trackOutput.initNewModule((String)modulePrefix);
                archivable.writeToArchive(trackOutput, (String)modulePrefix);
                moduleAssets.addAll(trackOutput.endCurrentModuleEntries());
                Collections.sort(moduleAssets);
                records.add(new ModuleRecord(archivable.getName(), archivable.getLoadingClass().getName(), (String)modulePrefix, moduleAssets));
                continue;
            }
            if (!verbose) continue;
            System.out.println("\tSkipping transient module: " + module.getName());
        }
        if (!records.isEmpty()) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String entryName = prefix + MODULE_FILE_NAME;
            if (verbose) {
                System.out.println("Wrote " + records.size() + " modules, writing index to " + entryName);
            }
            trackOutput.putNextEntry(entryName);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(trackOutput.getOutputStream()));
            gson.toJson(records, (Appendable)writer);
            writer.write("\n");
            writer.flush();
            trackOutput.closeEntry();
            return true;
        }
        return false;
    }

    public static synchronized List<ModuleRecord> loadModulesManifest(InputStream is) throws IOException {
        if (manifestGson == null) {
            manifestGson = new GsonBuilder().create();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        List records = (List)manifestGson.fromJson((Reader)reader, TypeToken.getParameterized(List.class, (Type[])new Type[]{ModuleRecord.class}).getType());
        reader.close();
        return records;
    }

    private static String getPrefix(String upstreamPrefix, String nestingPrefix) {
        String ret = upstreamPrefix == null ? "" : upstreamPrefix;
        return nestingPrefix == null ? ret : ret + nestingPrefix;
    }

    public static class ModuleRecord {
        public String name;
        public String className;
        public String path;
        private List<String> assets;

        public ModuleRecord() {
        }

        public ModuleRecord(String name, String className, String path, List<String> assets) {
            this.name = name;
            this.className = className;
            if (path != null && path.isBlank()) {
                path = null;
            }
            this.path = path;
            this.assets = assets;
        }
    }

    private static class ArchiveLoadCallable<E extends OpenSHA_Module>
    implements Callable<E> {
        private ModuleRecord record;
        private Class<E> clazz;
        private ArchiveInput input;
        private ModuleContainer<E> container;
        private HashSet<String> prevPrefixes;
        private Throwable t;
        private boolean verbose;

        public ArchiveLoadCallable(ModuleRecord record, Class<E> clazz, ArchiveInput input, ModuleContainer<E> container, HashSet<String> prevPrefixes, boolean verbose) {
            this.record = record;
            this.clazz = clazz;
            this.input = input;
            this.container = container;
            this.prevPrefixes = prevPrefixes;
            this.verbose = verbose;
        }

        @Override
        public E call() throws Exception {
            Constructor<E> constructor;
            if (!ArchivableModule.class.isAssignableFrom(this.clazz)) {
                System.err.println("WARNING: Module class is not an ArchivableModule, skipping: " + this.record.className);
                return null;
            }
            try {
                constructor = this.clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (Exception e) {
                System.err.println("WARNING: cannot load module '" + this.record.name + "' as the loading class doesn't have a no-arg constructor: " + this.clazz.getName());
                this.t = e;
                return null;
            }
            try {
                constructor.setAccessible(true);
            }
            catch (Exception e) {
                System.err.println("WANRING: couldn't make constructor accessible, loading will likely fail: " + e.getMessage());
                this.t = e;
            }
            try {
                OpenSHA_Module module;
                if (this.verbose) {
                    System.out.println("Building instance: " + this.clazz.getName());
                }
                if ((module = (OpenSHA_Module)constructor.newInstance(new Object[0])) instanceof SubModule) {
                    SubModule<ModuleContainer<OpenSHA_Module>> subModule;
                    try {
                        subModule = this.container.getAsSubModule(module);
                    }
                    catch (Exception e) {
                        System.err.println("WARNING: cannot load module '" + this.record.name + "' of type '" + this.clazz.getName() + "' as the it is a sub-module that is not applicable to the container of type '" + this.container.getClass().getName() + "'");
                        this.t = e;
                        return null;
                    }
                    subModule.setParent(this.container);
                }
                if (module instanceof ModuleContainer) {
                    ModuleContainer moduleContainer = (ModuleContainer)((Object)module);
                    ModuleArchive.loadModules(moduleContainer, this.input, this.record.path, null, this.prevPrefixes, this.verbose);
                    int availableModules = moduleContainer.getAvailableModules().size();
                    if (availableModules > 0 && this.verbose) {
                        System.out.println("Loaded " + availableModules + " available sub-modules");
                    }
                }
                ((ArchivableModule)module).initFromArchive(this.input, this.record.path);
                return (E)module;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Error loading module '" + this.record.name + "', skipping.");
                this.t = e;
                return null;
            }
        }
    }

    private static class EntryTrackingArchiveOutput
    implements ArchiveOutput {
        private ArchiveOutput out;
        private final HashSet<String> writtenEntries;
        private String modulePath;
        private List<String> moduleEntries;

        public EntryTrackingArchiveOutput(ArchiveOutput out) {
            this.out = out;
            this.writtenEntries = new HashSet();
        }

        public void initNewModule(String modulePath) {
            this.modulePath = modulePath;
            this.moduleEntries = new ArrayList<String>();
        }

        public List<String> endCurrentModuleEntries() {
            List<String> ret = this.moduleEntries;
            this.moduleEntries = null;
            return ret;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public String getName() {
            return this.out.getName();
        }

        @Override
        public void putNextEntry(String name) throws IOException {
            this.writtenEntries.add(name);
            if (this.moduleEntries != null && name.startsWith(this.modulePath)) {
                String subPath = name.substring(this.modulePath.length());
                this.moduleEntries.add(subPath);
            }
            this.out.putNextEntry(name);
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.out.getOutputStream();
        }

        @Override
        public void closeEntry() throws IOException {
            this.out.closeEntry();
        }

        @Override
        public void transferFrom(ArchiveInput input, String name) throws IOException {
            this.writtenEntries.add(name);
            this.out.transferFrom(input, name);
        }

        @Override
        public void transferFrom(ArchiveInput input, String sourceName, String destName) throws IOException {
            this.writtenEntries.add(destName);
            this.out.transferFrom(input, sourceName, destName);
        }

        @Override
        public void transferFrom(InputStream is, String name) throws IOException {
            this.writtenEntries.add(name);
            this.out.transferFrom(is, name);
        }

        @Override
        public ArchiveInput getCompletedInput() throws IOException {
            return this.out.getCompletedInput();
        }
    }
}

