/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.threads;

import java.util.ArrayList;
import java.util.Stack;
import java.util.TimerTask;
import org.opensha.commons.util.threads.TaskProgressListener;

public class StackPrecentWatcher
extends TimerTask {
    private Stack<?> stack;
    private int precentMod;
    private int initialSize;
    ArrayList<Integer> notifications = new ArrayList();
    private ArrayList<TaskProgressListener> listeners;

    public StackPrecentWatcher(Stack<?> stack, int precentMod, ArrayList<TaskProgressListener> listeners) {
        this.stack = stack;
        this.precentMod = precentMod;
        this.initialSize = stack.size();
        this.listeners = listeners;
    }

    @Override
    public void run() {
        int tasksLeft = this.stack.size();
        int tasksDone = this.initialSize - tasksLeft;
        double pdone = (double)tasksDone / (double)this.initialSize * 100.0;
        Integer pDivMod = (int)(pdone / (double)this.precentMod);
        if (this.notifications.contains(pDivMod)) {
            return;
        }
        this.notifications.add(pDivMod);
        for (TaskProgressListener listener : this.listeners) {
            listener.taskProgressUpdate(tasksDone, tasksLeft, this.initialSize);
        }
    }
}

