/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.threads;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import org.opensha.commons.util.threads.StackPrecentWatcher;
import org.opensha.commons.util.threads.Task;
import org.opensha.commons.util.threads.TaskProgressListener;

public class ThreadedTaskComputer
implements Runnable {
    private Stack<? extends Task> stack;
    private TimerTask progressTimerTask = null;
    private int timerPeriodMilis = 5000;

    public ThreadedTaskComputer(Collection<? extends Task> tasks) {
        this(tasks, true);
    }

    private static Stack<Task> colToStack(Collection<? extends Task> tasks) {
        Stack<Task> stack = new Stack<Task>();
        for (Task task : tasks) {
            stack.push(task);
        }
        return stack;
    }

    public ThreadedTaskComputer(Collection<? extends Task> tasks, boolean shuffle) {
        this(ThreadedTaskComputer.colToStack(tasks), shuffle);
    }

    public ThreadedTaskComputer(Stack<? extends Task> stack, boolean shuffle) {
        this.stack = stack;
        if (shuffle) {
            Collections.shuffle(stack);
        }
    }

    private synchronized Task getNextTask() {
        return this.stack.pop();
    }

    public void computeSingleThread() {
        this.run();
    }

    public void computeThreaded() throws InterruptedException {
        this.computeThreaded(Runtime.getRuntime().availableProcessors());
    }

    public void computeThreaded(int numThreads) throws InterruptedException {
        if (numThreads < 2) {
            this.computeSingleThread();
            return;
        }
        ArrayList<Thread> threads = new ArrayList<Thread>();
        Timer timer = null;
        for (int i = 0; i < numThreads; ++i) {
            Thread t = new Thread(this);
            threads.add(t);
        }
        if (this.progressTimerTask != null) {
            timer = new Timer();
            timer.schedule(this.progressTimerTask, 0L, (long)this.timerPeriodMilis);
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        if (timer != null) {
            timer.cancel();
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                Task task = this.getNextTask();
                task.compute();
            }
        }
        catch (EmptyStackException e) {
            return;
        }
    }

    public void setProgressTimer(TimerTask progressTimerTask) {
        this.progressTimerTask = progressTimerTask;
    }

    public void setProgressTimer(TaskProgressListener listener, int precentMod) {
        ArrayList<TaskProgressListener> listeners = new ArrayList<TaskProgressListener>();
        listeners.add(listener);
        this.setProgressTimer(listeners, precentMod);
    }

    public void setProgressTimer(ArrayList<TaskProgressListener> listeners, int precentMod) {
        this.progressTimerTask = new StackPrecentWatcher(this.stack, precentMod, listeners);
    }
}

