/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.calc;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.opensha.commons.data.Site;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.nshmp2.calc.ERF_ID;
import org.opensha.nshmp2.calc.HazardCalc;
import org.opensha.nshmp2.calc.HazardResult;
import org.opensha.nshmp2.calc.HazardResultWriter;
import org.opensha.nshmp2.util.Period;
import org.opensha.nshmp2.util.SourceIMR;
import org.opensha.sha.earthquake.EpistemicListERF;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.peter.ucerf3.calc.UC3_CalcUtils;

public class ThreadedHazardCalc {
    private LocationList locs;
    private Period period;
    private boolean epiUncert;
    private HazardResultWriter writer;
    private EpistemicListERF erfList;
    private SourceIMR imr = null;
    private boolean determ = false;

    public ThreadedHazardCalc(EpistemicListERF erfList, SourceIMR imr, LocationList locs, Period period, boolean epiUncert, HazardResultWriter writer, boolean determ) {
        this.locs = locs;
        this.period = period;
        this.writer = writer;
        this.epiUncert = epiUncert;
        this.imr = imr;
        this.erfList = erfList;
        this.determ = determ;
    }

    public ThreadedHazardCalc(ERF_ID erfID, SourceIMR imr, LocationList locs, Period period, boolean epiUncert, HazardResultWriter writer) {
        this.locs = locs;
        this.period = period;
        this.writer = writer;
        this.epiUncert = epiUncert;
        this.imr = imr;
        this.erfList = erfID.instance();
        this.erfList.updateForecast();
    }

    public ThreadedHazardCalc(String solPath, SourceIMR imr, LocationList locs, Period period, boolean epiUncert, IncludeBackgroundOption bg, HazardResultWriter writer, boolean nshmp) {
        this.locs = locs;
        this.period = period;
        this.writer = writer;
        this.epiUncert = epiUncert;
        this.imr = imr;
        System.out.println("Starting threaded hazard calc...");
        this.determ = nshmp && bg == IncludeBackgroundOption.EXCLUDE;
        FaultSystemSolutionERF erf = nshmp ? UC3_CalcUtils.getNSHMP_UC3_ERF(solPath, bg, false, true, 1.0) : UC3_CalcUtils.getUC3_ERF(solPath, bg, false, true, 1.0);
        this.erfList = ERF_ID.wrapInList(erf);
        this.erfList.updateForecast();
    }

    public ThreadedHazardCalc(String solPath, String branchID, LocationList locs, Period period, boolean epiUncert, HazardResultWriter writer) {
        this.locs = locs;
        this.period = period;
        this.writer = writer;
        this.epiUncert = epiUncert;
        FaultSystemSolutionERF erf = UC3_CalcUtils.getUC3_ERF(solPath, branchID, IncludeBackgroundOption.INCLUDE, false, true, 1.0);
        this.erfList = ERF_ID.wrapInList(erf);
        this.erfList.updateForecast();
    }

    public ThreadedHazardCalc(String solPath, int solIdx, LocationList locs, Period period, boolean epiUncert, HazardResultWriter writer) {
        this.locs = locs;
        this.period = period;
        this.writer = writer;
        this.epiUncert = epiUncert;
        FaultSystemSolutionERF erf = UC3_CalcUtils.getUC3_ERF(solPath, solIdx, IncludeBackgroundOption.INCLUDE, false, true, 1.0);
        this.erfList = ERF_ID.wrapInList(erf);
        this.erfList.updateForecast();
    }

    public void calculate(int[] indices) throws InterruptedException, ExecutionException, IOException {
        this.calculate(indices, Runtime.getRuntime().availableProcessors());
    }

    public void calculate(int[] indices, int numProc) throws InterruptedException, ExecutionException, IOException {
        if (indices == null) {
            indices = this.makeIndices(this.locs.size());
        }
        ExecutorService ex = Executors.newFixedThreadPool(numProc);
        ExecutorCompletionService<HazardResult> ecs = new ExecutorCompletionService<HazardResult>(ex);
        for (int index : indices) {
            Site site = new Site((Location)this.locs.get(index));
            HazardCalc hc = HazardCalc.create(this.erfList, this.imr, site, this.period, this.epiUncert, this.determ);
            ecs.submit(hc);
        }
        ex.shutdown();
        for (int i = 0; i < indices.length; ++i) {
            this.writer.write((HazardResult)ecs.take().get());
        }
    }

    private int[] makeIndices(int size) {
        int[] indices = new int[size];
        for (int i = 0; i < size; ++i) {
            indices[i] = i;
        }
        return indices;
    }
}

