/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf.source;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opensha.commons.geo.Direction;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.nshmp2.erf.source.GR_Data;
import org.opensha.nshmp2.erf.source.GridERF;
import org.opensha.nshmp2.erf.source.SourceFile;
import org.opensha.nshmp2.erf.source.SourceMgr;
import org.opensha.nshmp2.util.FaultCode;
import org.opensha.nshmp2.util.NSHMP_Utils;
import org.opensha.nshmp2.util.RateType;
import org.opensha.nshmp2.util.SourceIMR;
import org.opensha.nshmp2.util.SourceRegion;
import org.opensha.nshmp2.util.SourceType;
import org.opensha.nshmp2.util.Utils;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.FocalMech;

public class GridParser {
    private Logger log;
    private static final String GRD_PATH = "../conf/";
    private static final String DAT_PATH = "/data/nshmp/sources/";
    private String srcName;
    private SourceRegion srcRegion;
    private SourceIMR srcIMR;
    private double srcWt;
    private double minLat;
    private double maxLat;
    private double dLat;
    private double minLon;
    private double maxLon;
    private double dLon;
    private double[] depths;
    private Map<FocalMech, Double> mechWtMap;
    private double dR;
    private double rMax;
    private GR_Data grSrc;
    private FaultCode fltCode;
    private boolean bGrid;
    private boolean mMaxGrid;
    private boolean weightGrid;
    private double mTaper;
    private URL aGridURL;
    private URL bGridURL;
    private URL mMaxGridURL;
    private URL weightGridURL;
    private double timeSpan;
    private RateType rateType;
    private double strike = Double.NaN;
    private double[] aDat;
    private double[] bDat;
    private double[] mMinDat;
    private double[] mMaxDat;
    private double[] wgtDat;
    private LocationList srcLocs;
    private List<IncrementalMagFreqDist> mfdList;
    private Region border;
    private int[] srcIndices;
    private static double[] wtmj_cra = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.9, 0.7, 0.2, 0.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private static double[] wtmj_ext = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.9, 0.7, 0.7, 0.2, 0.0, 0.0, 0.0};
    private static double[] wtmab_cra = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.9, 0.9, 0.7, 0.2, 0.0, 0.0, 0.0, 0.0};
    private static double[] wtmab_ext = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.9, 0.7, 0.2, 0.0};
    private static boolean[] cratonFlags;
    private static boolean[] marginFlags;

    GridParser(Logger log) {
        this.log = log;
    }

    GridERF parse(SourceFile sf) {
        Iterator<String> it;
        this.srcName = sf.getName();
        this.srcRegion = sf.getRegion();
        this.srcWt = sf.getWeight();
        List<String> dat = sf.readLines();
        int numSta = NSHMP_Utils.readInt((it = dat.iterator()).next(), 0);
        Iterators.advance(it, (int)(numSta > 0 ? numSta : 2));
        it.next();
        this.readRuptureTop(it.next());
        this.readMechWeights(it.next());
        this.readLookupArrayDat(it.next());
        this.readSourceLatRange(it.next());
        this.readSourceLonRange(it.next());
        this.grSrc = new GR_Data(it.next(), SourceType.GRIDDED);
        String grdDatRaw = it.next();
        int[] grdDat = NSHMP_Utils.readInts(grdDatRaw, 3);
        this.fltCode = FaultCode.typeForID(grdDat[0]);
        this.bGrid = grdDat[1] > 0;
        this.mMaxGrid = grdDat[2] > 0;
        this.mTaper = NSHMP_Utils.readDouble(grdDatRaw, 3);
        boolean bl = this.weightGrid = this.mTaper > 0.0;
        if (this.bGrid) {
            this.bGridURL = this.readSourceURL(it.next());
        }
        if (this.mMaxGrid) {
            this.mMaxGridURL = this.readSourceURL(it.next());
        }
        if (this.weightGrid) {
            this.weightGridURL = this.readSourceURL(it.next());
        }
        this.aGridURL = this.readSourceURL(it.next());
        this.readRateInfo(it.next());
        if (this.fltCode == FaultCode.FIXED) {
            this.strike = NSHMP_Utils.readDouble(it.next(), 0);
        }
        this.srcIMR = SourceIMR.imrForSource(SourceType.GRIDDED, this.srcRegion, this.srcName, this.fltCode);
        GridERF erf = this.createGridSource();
        return erf;
    }

    private GridERF createGridSource() {
        this.initDataGrids();
        GriddedRegion region = new GriddedRegion(new Location(this.minLat, this.minLon), new Location(this.maxLat, this.maxLon), this.dLat, this.dLon, GriddedRegion.ANCHOR_0_0);
        this.generateMFDs(region);
        this.initSrcRegion(region);
        if (this.srcName.contains("2007all8")) {
            this.ceusScaleRates();
        }
        GridERF gs = new GridERF(this.srcName, this.generateInfo(), this.border, this.srcLocs, this.mfdList, this.depths, this.mechWtMap, this.fltCode, this.strike, this.srcRegion, this.srcIMR, this.srcWt, this.rMax, this.dR);
        return gs;
    }

    private void initSrcRegion(GriddedRegion region) {
        LocationList srcLocs = new LocationList();
        int currIdx = this.srcIndices[0];
        srcLocs.add(region.locationForIndex(currIdx));
        Direction startDir = Direction.WEST;
        Direction sweepDir = startDir.next();
        while (sweepDir != startDir) {
            int sweepIdx = region.move(currIdx, sweepDir);
            int nextIdx = Arrays.binarySearch(this.srcIndices, sweepIdx);
            if (nextIdx >= 0) {
                Location nextLoc = region.locationForIndex(this.srcIndices[nextIdx]);
                if (nextLoc.equals(srcLocs.get(0))) break;
                srcLocs.add(nextLoc);
                currIdx = this.srcIndices[nextIdx];
                startDir = sweepDir.opposite().next();
                sweepDir = startDir.next();
                continue;
            }
            sweepDir = sweepDir.next();
        }
        if (srcLocs.size() == 16) {
            for (int i = 0; i < srcLocs.size(); ++i) {
                if (i == 0 || i == 8) continue;
                double offset = i > 8 ? 0.01 : -0.01;
                Location ol = (Location)srcLocs.get(i);
                Location nl = new Location(ol.getLatitude() + offset, ol.getLongitude());
                srcLocs.set(i, nl);
            }
        }
        this.border = new Region(srcLocs, null);
    }

    private void generateMFDs(GriddedRegion region) {
        this.mfdList = Lists.newArrayList();
        this.srcLocs = new LocationList();
        ArrayList srcIndexList = Lists.newArrayList();
        for (int i = 0; i < this.aDat.length; ++i) {
            if (this.aDat[i] == 0.0) continue;
            double maxM = this.mMaxDat[i] <= 0.0 ? this.grSrc.mMax : this.mMaxDat[i];
            GR_Data gr = new GR_Data(this.aDat[i], this.bDat[i], this.mMinDat[i], maxM, this.grSrc.dMag);
            GutenbergRichterMagFreqDist mfd = new GutenbergRichterMagFreqDist(gr.mMin, gr.nMag, gr.dMag, 1.0, gr.bVal);
            mfd.scaleToIncrRate(gr.mMin, NSHMP_Utils.incrRate(gr.aVal, gr.bVal, gr.mMin));
            if (this.weightGrid && mfd.getMaxX() >= this.mTaper) {
                for (int j = mfd.getXIndex(this.mTaper + this.grSrc.dMag / 2.0); j < mfd.size(); ++j) {
                    mfd.set(j, mfd.getY(j) * this.wgtDat[i]);
                }
            }
            this.mfdList.add(mfd);
            this.srcLocs.add(region.locationForIndex(i));
            srcIndexList.add(i);
        }
        this.srcIndices = Ints.toArray((Collection)srcIndexList);
    }

    private void initDataGrids() {
        int nRows = (int)Math.rint((this.maxLat - this.minLat) / this.dLat) + 1;
        int nCols = (int)Math.rint((this.maxLon - this.minLon) / this.dLon) + 1;
        this.aDat = NSHMP_Utils.readGrid(this.aGridURL, nRows, nCols);
        this.bDat = this.bGrid ? NSHMP_Utils.readGrid(this.bGridURL, nRows, nCols) : this.makeGrid(this.aDat.length, this.grSrc.bVal);
        for (int i = 0; i < this.bDat.length; ++i) {
            if (this.bDat[i] != 0.0) continue;
            this.bDat[i] = this.grSrc.bVal;
        }
        this.mMinDat = this.makeGrid(this.aDat.length, this.grSrc.mMin);
        this.mMaxDat = this.mMaxGrid ? NSHMP_Utils.readGrid(this.mMaxGridURL, nRows, nCols) : this.makeGrid(this.aDat.length, this.grSrc.mMax);
        this.wgtDat = this.weightGrid ? NSHMP_Utils.readGrid(this.weightGridURL, nRows, nCols) : null;
    }

    private double[] makeGrid(int size, double value) {
        double[] dat = new double[size];
        Arrays.fill(dat, value);
        return dat;
    }

    private void readRuptureTop(String line) {
        double hiMagDepth;
        double loMagDepth;
        int numDepths = NSHMP_Utils.readInt(line, 0);
        double[] depthDat = NSHMP_Utils.readDoubles(line, 1 + 2 * numDepths);
        if (numDepths == 1) {
            loMagDepth = depthDat[1];
            hiMagDepth = depthDat[1];
        } else {
            loMagDepth = depthDat[4];
            hiMagDepth = depthDat[1];
        }
        this.depths = new double[]{loMagDepth, hiMagDepth};
    }

    private void readMechWeights(String line) {
        double[] weights = NSHMP_Utils.readDoubles(line, 3);
        this.mechWtMap = Maps.newEnumMap(FocalMech.class);
        this.mechWtMap.put(FocalMech.STRIKE_SLIP, weights[0]);
        this.mechWtMap.put(FocalMech.REVERSE, weights[1]);
        this.mechWtMap.put(FocalMech.NORMAL, weights[2]);
    }

    private void readLookupArrayDat(String line) {
        double[] rDat = NSHMP_Utils.readDoubles(line, 2);
        this.dR = (int)rDat[0];
        this.rMax = (int)rDat[1];
    }

    private void readSourceLatRange(String line) {
        double[] latDat = NSHMP_Utils.readDoubles(line, 3);
        this.minLat = latDat[0];
        this.maxLat = latDat[1];
        this.dLat = latDat[2];
    }

    private void readSourceLonRange(String line) {
        double[] lonDat = NSHMP_Utils.readDoubles(line, 3);
        this.minLon = lonDat[0];
        this.maxLon = lonDat[1];
        this.dLon = lonDat[2];
    }

    private URL readSourceURL(String path) {
        Preconditions.checkArgument((boolean)path.startsWith(GRD_PATH), (Object)("Bad file path: " + path));
        return GridParser.class.getResource(DAT_PATH + path.substring(GRD_PATH.length()));
    }

    private void readRateInfo(String line) {
        this.timeSpan = NSHMP_Utils.readDouble(line, 0);
        int rateTypeVal = NSHMP_Utils.readInt(line, 1);
        this.rateType = rateTypeVal == 0 ? RateType.INCREMENTAL : RateType.CUMULATIVE;
    }

    private String generateInfo() {
        return IOUtils.LINE_SEPARATOR + "=========== Grid Config ============" + IOUtils.LINE_SEPARATOR + "            Name: " + this.srcName + IOUtils.LINE_SEPARATOR + "       Lat range: " + this.minLat + " " + this.maxLat + IOUtils.LINE_SEPARATOR + "       Lon range: " + this.minLon + " " + this.maxLon + IOUtils.LINE_SEPARATOR + "     [dLat dLon]: " + this.dLat + " " + this.dLon + IOUtils.LINE_SEPARATOR + "    Source count: " + this.srcLocs.size() + IOUtils.LINE_SEPARATOR + "   Rup top M<6.5: " + this.depths[0] + IOUtils.LINE_SEPARATOR + "   Rup top M\u22656.5: " + this.depths[1] + IOUtils.LINE_SEPARATOR + "    Mech weights: " + "SS=" + this.mechWtMap.get((Object)FocalMech.STRIKE_SLIP) + " R=" + this.mechWtMap.get((Object)FocalMech.REVERSE) + " N=" + this.mechWtMap.get((Object)FocalMech.NORMAL) + IOUtils.LINE_SEPARATOR + "   opt [dR rMax]: " + this.dR + " " + this.rMax + IOUtils.LINE_SEPARATOR + " GR [b M- M+ dM]: " + this.grSrc.bVal + " " + this.grSrc.mMin + " " + this.grSrc.mMax + " " + this.grSrc.dMag + IOUtils.LINE_SEPARATOR + "          a grid: " + StringUtils.substringAfter((String)this.aGridURL.toString(), (String)"/") + IOUtils.LINE_SEPARATOR + "          b grid: " + this.bGrid + " " + (this.bGridURL != null ? StringUtils.substringAfter((String)this.bGridURL.toString(), (String)"/") : "") + IOUtils.LINE_SEPARATOR + "       mMax grid: " + this.mMaxGrid + " " + (this.mMaxGridURL != null ? StringUtils.substringAfter((String)this.mMaxGridURL.toString(), (String)"/") : "") + IOUtils.LINE_SEPARATOR + "     weight grid: " + this.weightGrid + " " + (this.weightGridURL != null ? StringUtils.substringAfter((String)this.weightGridURL.toString(), (String)"/") : "") + IOUtils.LINE_SEPARATOR + "         M taper: " + this.mTaper + IOUtils.LINE_SEPARATOR + "       Time span: " + this.timeSpan + IOUtils.LINE_SEPARATOR + "            Rate: " + (Object)((Object)this.rateType) + IOUtils.LINE_SEPARATOR + "      Fault Code: " + (Object)((Object)this.fltCode) + IOUtils.LINE_SEPARATOR + "          Strike: " + this.strike + IOUtils.LINE_SEPARATOR;
    }

    private void ceusScaleRates() {
        this.initMasks();
        double[] craWt = wtmj_cra;
        double[] marWt = wtmj_ext;
        if (this.srcName.contains(".AB.")) {
            craWt = wtmab_cra;
            marWt = wtmab_ext;
        }
        for (int i = 0; i < this.srcIndices.length; ++i) {
            boolean marFlag;
            int flagIdx;
            boolean craFlag;
            IncrementalMagFreqDist mfd = this.mfdList.get(i);
            if (mfd == null || !((craFlag = cratonFlags[flagIdx = this.srcIndices[i]]) | (marFlag = marginFlags[flagIdx]))) continue;
            double[] weights = craFlag ? craWt : marWt;
            this.applyWeight(mfd, weights);
        }
    }

    private void applyWeight(IncrementalMagFreqDist mfd, double[] weights) {
        for (int i = 0; i < mfd.size(); ++i) {
            double weight = weights[i];
            if (weight == 1.0) continue;
            mfd.set(i, mfd.getY(i) * weight);
        }
    }

    private void initMasks() {
        if (cratonFlags == null) {
            URL craton = Utils.getResource("/imr/craton");
            URL margin = Utils.getResource("/imr/margin");
            int nRows = (int)Math.rint((this.maxLat - this.minLat) / this.dLat) + 1;
            int nCols = (int)Math.rint((this.maxLon - this.minLon) / this.dLon) + 1;
            cratonFlags = NSHMP_Utils.readBoolGrid(craton, nRows, nCols);
            marginFlags = NSHMP_Utils.readBoolGrid(margin, nRows, nCols);
        }
    }

    public static void main(String[] args) {
        Logger log = NSHMP_Utils.logger();
        Level level = Level.FINE;
        log.setLevel(level);
        for (Handler h : NSHMP_Utils.logger().getHandlers()) {
            h.setLevel(level);
        }
        ArrayList sources = Lists.newArrayList();
        sources.addAll(SourceMgr.get(SourceRegion.CA, SourceType.GRIDDED, "brawmap.in"));
        for (SourceFile sf : sources) {
            GridParser parser = new GridParser(log);
            System.out.println("Building: " + String.valueOf(sf));
            GridERF erf = parser.parse(sf);
            log.fine(erf.toString());
            System.out.println(erf.getMFD(new Location(32.9, -116.0)));
        }
    }
}

