/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf.source;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.net.URL;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.opensha.nshmp2.erf.source.SourceFile;
import org.opensha.nshmp2.util.SourceRegion;
import org.opensha.nshmp2.util.SourceType;
import org.opensha.nshmp2.util.Utils;

class SourceMgr {
    private static String datPath = "/sources/";
    private static List<SourceFile> srcFiles;
    private static final double[] CL_WTS_BASE;
    private static final double[] CL_WTS_1000;

    private SourceMgr() {
    }

    public static List<SourceFile> getAll() {
        return ImmutableList.copyOf(srcFiles);
    }

    public static List<SourceFile> get(SourceRegion region, SourceType type) {
        return SourceMgr.get(region, type, null);
    }

    public static List<SourceFile> get(SourceRegion region, SourceType type, String name) {
        return SourceMgr.get(region != null ? EnumSet.of(region) : null, type != null ? EnumSet.of(type) : null, (Set<String>)(StringUtils.isNotBlank((CharSequence)name) ? ImmutableSet.of((Object)name) : null));
    }

    public static List<SourceFile> get(EnumSet<SourceRegion> regions, EnumSet<SourceType> types, Set<String> names) {
        List<Predicate<SourceFile>> pList = SourceMgr.generateFilters(regions, types, names);
        Predicate p = Predicates.and(pList);
        return ImmutableList.copyOf((Collection)Collections2.filter(srcFiles, (Predicate)p));
    }

    /*
     * WARNING - void declaration
     */
    private static List<Predicate<SourceFile>> generateFilters(EnumSet<SourceRegion> regions, EnumSet<SourceType> types, Set<String> names) {
        void var5_12;
        Predicate rp = Predicates.alwaysTrue();
        if (regions != null && !regions.isEmpty()) {
            rp = Predicates.alwaysFalse();
            for (SourceRegion sourceRegion : regions) {
                rp = Predicates.or((Predicate)rp, (Predicate)new SourceFileRegion(sourceRegion));
            }
        }
        Predicate tp = Predicates.alwaysTrue();
        if (types != null && !types.isEmpty()) {
            tp = Predicates.alwaysFalse();
            for (SourceType type : types) {
                tp = Predicates.or((Predicate)tp, (Predicate)new SourceFileType(type));
            }
        }
        Predicate predicate = Predicates.alwaysTrue();
        if (names != null && !names.isEmpty()) {
            Predicate predicate2 = Predicates.alwaysFalse();
            for (String name : names) {
                void var5_10;
                Predicate predicate3 = Predicates.or((Predicate)var5_10, (Predicate)new SourceFileName(name));
            }
        }
        return ImmutableList.of((Object)rp, (Object)tp, (Object)var5_12);
    }

    private static SourceFile create(String resource, double weight) {
        String[] parts = StringUtils.split((String)resource, (char)'/');
        SourceRegion region = SourceRegion.valueOf(parts[0]);
        SourceType type = null;
        type = region == SourceRegion.CASC ? SourceType.SUBDUCTION : (resource.contains("cluster") ? SourceType.CLUSTER : (parts[1].equals("gridded") ? SourceType.GRIDDED : SourceType.FAULT));
        URL url = Utils.getResource(datPath + resource);
        return new SourceFile(url, region, type, weight);
    }

    private static void initSources() {
        srcFiles = Lists.newArrayList();
        srcFiles.add(SourceMgr.create("CA/faults/bFault.ch.in", 0.6667));
        srcFiles.add(SourceMgr.create("CA/faults/bFault.gr.in", 0.1667));
        srcFiles.add(SourceMgr.create("CA/faults/aFault_aPriori_D2.1.in", 0.45));
        srcFiles.add(SourceMgr.create("CA/faults/aFault_unseg.in", 0.05));
        srcFiles.add(SourceMgr.create("CA/faults/aFault_MoBal.in", 0.225));
        srcFiles.add(SourceMgr.create("CA/gridded/CAdeep.in", 1.0));
        srcFiles.add(SourceMgr.create("CA/gridded/CAmap.24.ch.in", 0.3333));
        srcFiles.add(SourceMgr.create("CA/gridded/CAmap.21.ch.in", 0.3334));
        srcFiles.add(SourceMgr.create("CA/gridded/CAmap.21.gr.in", 0.1666));
        srcFiles.add(SourceMgr.create("CA/gridded/CAmap.24.gr.in", 0.1667));
        srcFiles.add(SourceMgr.create("CA/gridded/brawmap.in", 1.0));
        srcFiles.add(SourceMgr.create("CA/gridded/creepmap.in", 1.0));
        srcFiles.add(SourceMgr.create("CA/gridded/sangorg.in", 1.0));
        srcFiles.add(SourceMgr.create("CA/gridded/mendo.in", 1.0));
        srcFiles.add(SourceMgr.create("CA/gridded/mojave.in", 1.0));
        srcFiles.add(SourceMgr.create("CA/gridded/impext.ch.in", 0.6667));
        srcFiles.add(SourceMgr.create("CA/gridded/impext.gr.in", 0.3333));
        srcFiles.add(SourceMgr.create("CA/gridded/shear1.in", 1.0));
        srcFiles.add(SourceMgr.create("CA/gridded/shear2.in", 1.0));
        srcFiles.add(SourceMgr.create("CA/gridded/shear3.in", 1.0));
        srcFiles.add(SourceMgr.create("CA/gridded/shear4.in", 1.0));
        srcFiles.add(SourceMgr.create("WUS/faults/brange.3dip.ch.in", 0.6666));
        srcFiles.add(SourceMgr.create("WUS/faults/brange.3dip.gr.in", 0.3334));
        srcFiles.add(SourceMgr.create("WUS/faults/brange.3dip.65.in", 1.0));
        srcFiles.add(SourceMgr.create("WUS/faults/nv.3dip.ch.in", 0.6666));
        srcFiles.add(SourceMgr.create("WUS/faults/nv.3dip.gr.in", 0.3334));
        srcFiles.add(SourceMgr.create("WUS/faults/nvut.3dip.65.in", 1.0));
        srcFiles.add(SourceMgr.create("WUS/faults/ut.3dip.ch.in", 0.6666));
        srcFiles.add(SourceMgr.create("WUS/faults/ut.3dip.gr.in", 0.3334));
        srcFiles.add(SourceMgr.create("WUS/faults/orwa_c.in", 0.5));
        srcFiles.add(SourceMgr.create("WUS/faults/orwa_n.3dip.ch.in", 0.6667));
        srcFiles.add(SourceMgr.create("WUS/faults/orwa_n.3dip.gr.in", 0.3333));
        srcFiles.add(SourceMgr.create("WUS/faults/wasatch.3dip.ch.in", 1.0));
        srcFiles.add(SourceMgr.create("WUS/faults/wasatch.3dip.gr.in", 1.0));
        srcFiles.add(SourceMgr.create("WUS/faults/wasatch.3dip.74.in", 1.0));
        srcFiles.add(SourceMgr.create("WUS/gridded/WUSmap.ch.in", 0.25));
        srcFiles.add(SourceMgr.create("WUS/gridded/WUSmap.gr.in", 0.25));
        srcFiles.add(SourceMgr.create("WUS/gridded/EXTmap.ch.in", 0.6667));
        srcFiles.add(SourceMgr.create("WUS/gridded/EXTmap.gr.in", 0.333));
        srcFiles.add(SourceMgr.create("WUS/gridded/nopuget.ch.in", 0.25));
        srcFiles.add(SourceMgr.create("WUS/gridded/nopuget.gr.in", 0.25));
        srcFiles.add(SourceMgr.create("WUS/gridded/puget.ch.in", 0.25));
        srcFiles.add(SourceMgr.create("WUS/gridded/puget.gr.in", 0.25));
        srcFiles.add(SourceMgr.create("WUS/gridded/pnwdeep.in", 1.0));
        srcFiles.add(SourceMgr.create("WUS/gridded/portdeep.in", 1.0));
        srcFiles.add(SourceMgr.create("CASC/cascadia.top.8387.in", 0.0051282));
        srcFiles.add(SourceMgr.create("CASC/cascadia.mid.8387.in", 0.0102564));
        srcFiles.add(SourceMgr.create("CASC/cascadia.bot.8387.in", 0.0102564));
        srcFiles.add(SourceMgr.create("CASC/cascadia.older2.8387.in", 0.025644));
        srcFiles.add(SourceMgr.create("CASC/cascadia.top.8082.in", 0.0025641));
        srcFiles.add(SourceMgr.create("CASC/cascadia.mid.8082.in", 0.0051282));
        srcFiles.add(SourceMgr.create("CASC/cascadia.bot.8082.in", 0.0051282));
        srcFiles.add(SourceMgr.create("CASC/cascadia.older2.8082.in", 0.012833));
        srcFiles.add(SourceMgr.create("CASC/cascadia.top.9pm.in", 0.06666667));
        srcFiles.add(SourceMgr.create("CASC/cascadia.mid.9pm.in", 0.13333));
        srcFiles.add(SourceMgr.create("CASC/cascadia.bot.9pm.in", 0.13333));
        srcFiles.add(SourceMgr.create("CASC/cascadia.older2.9pm.in", 0.3333));
        srcFiles.add(SourceMgr.create("CEUS/faults/NMSZnocl.500yr.5branch.in", 0.45));
        srcFiles.add(SourceMgr.create("CEUS/faults/NMSZnocl.1000yr.5branch.in", 0.05));
        srcFiles.add(SourceMgr.create("CEUS/faults/CEUScm.in", 1.0));
        srcFiles.add(SourceMgr.create("CEUS/gridded/CEUS.2007all8.AB.in", 0.5));
        srcFiles.add(SourceMgr.create("CEUS/gridded/CEUS.2007all8.J.in", 0.5));
        srcFiles.add(SourceMgr.create("CEUS/gridded/CEUSchar.73.in", 0.45));
        srcFiles.add(SourceMgr.create("CEUS/gridded/CEUSchar.71.in", 0.2));
        srcFiles.add(SourceMgr.create("CEUS/gridded/CEUSchar.75.in", 0.15));
        srcFiles.add(SourceMgr.create("CEUS/gridded/CEUSchar.68.in", 0.2));
        srcFiles.add(SourceMgr.create("CEUS/faults/newmad.500.cluster.in", 1.0));
        srcFiles.add(SourceMgr.create("CEUS/faults/newmad.750.cluster.in", 1.0));
        srcFiles.add(SourceMgr.create("CEUS/faults/newmad.1000.cluster.in", 1.0));
        srcFiles.add(SourceMgr.create("CEUS/faults/newmad.1500.cluster.in", 1.0));
    }

    static double getClusterWeight(String name, int group) {
        double[] wts = name.contains(".1000.") ? CL_WTS_1000 : CL_WTS_BASE;
        return wts[group - 1];
    }

    public static void main(String[] args) {
        List<SourceFile> files = SourceMgr.getAll();
        for (SourceFile f : files) {
            System.out.println(f);
        }
    }

    static {
        SourceMgr.initSources();
        CL_WTS_BASE = new double[]{0.01125, 0.0225, 0.1575, 0.0225, 0.01125};
        CL_WTS_1000 = new double[]{0.0025, 0.005, 0.035, 0.005, 0.0025};
    }

    private static class SourceFileRegion
    implements Predicate<SourceFile> {
        SourceRegion region;

        SourceFileRegion(SourceRegion region) {
            this.region = region;
        }

        public boolean apply(SourceFile input) {
            return input.getRegion().equals((Object)this.region);
        }

        public String toString() {
            return this.region.toString();
        }
    }

    private static class SourceFileType
    implements Predicate<SourceFile> {
        SourceType type;

        SourceFileType(SourceType type) {
            this.type = type;
        }

        public boolean apply(SourceFile input) {
            return input.getType().equals((Object)this.type);
        }

        public String toString() {
            return this.type.toString();
        }
    }

    private static class SourceFileName
    implements Predicate<SourceFile> {
        String name;

        SourceFileName(String name) {
            this.name = name;
        }

        public boolean apply(SourceFile input) {
            return input.getName().equals(this.name);
        }

        public String toString() {
            return this.name;
        }
    }
}

