/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf.source;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensha.nshmp2.erf.source.ClusterERF;
import org.opensha.nshmp2.erf.source.ClusterParser;
import org.opensha.nshmp2.erf.source.FaultERF;
import org.opensha.nshmp2.erf.source.FaultParser;
import org.opensha.nshmp2.erf.source.GridERF;
import org.opensha.nshmp2.erf.source.GridParser;
import org.opensha.nshmp2.erf.source.NSHMP_ERF;
import org.opensha.nshmp2.erf.source.SourceFile;
import org.opensha.nshmp2.erf.source.SourceMgr;
import org.opensha.nshmp2.erf.source.SubductionERF;
import org.opensha.nshmp2.erf.source.SubductionParser;
import org.opensha.nshmp2.util.NSHMP_Utils;
import org.opensha.nshmp2.util.SourceRegion;
import org.opensha.nshmp2.util.SourceType;

public class Sources {
    private static Logger log = NSHMP_Utils.logger();

    public static NSHMP_ERF get(String name) {
        SourceRegion region = Sources.regionForSource(name);
        SourceType type = Sources.typeForSource(name);
        if (region == null && type == null) {
            return null;
        }
        switch (type) {
            case GRIDDED: {
                return Sources.getGrid(name);
            }
            case FAULT: {
                return Sources.getFault(name);
            }
            case CLUSTER: {
                return Sources.getCluster(name);
            }
            case SUBDUCTION: {
                return Sources.getSub(name);
            }
        }
        return null;
    }

    public static ClusterERF getCluster(String name) {
        List<SourceFile> files = SourceMgr.get(null, SourceType.CLUSTER, name);
        if (files == null) {
            return null;
        }
        ClusterParser parser = new ClusterParser(log);
        return parser.parse(files.get(0));
    }

    public static GridERF getGrid(String name) {
        List<SourceFile> files = SourceMgr.get(null, SourceType.GRIDDED, name);
        if (files == null) {
            return null;
        }
        GridParser parser = new GridParser(log);
        return parser.parse(files.get(0));
    }

    public static FaultERF getFault(String name) {
        List<SourceFile> files = SourceMgr.get(null, SourceType.FAULT, name);
        if (files == null) {
            return null;
        }
        FaultParser parser = new FaultParser(log);
        return parser.parse(files.get(0));
    }

    public static SubductionERF getSub(String name) {
        List<SourceFile> files = SourceMgr.get(null, SourceType.SUBDUCTION, name);
        if (files == null) {
            return null;
        }
        SubductionParser parser = new SubductionParser(log);
        return parser.parse(files.get(0));
    }

    public static List<ClusterERF> getClusterList(SourceRegion region) {
        ArrayList erfs = Lists.newArrayList();
        List<SourceFile> files = SourceMgr.get(region, SourceType.CLUSTER);
        if (files == null) {
            return null;
        }
        for (SourceFile sf : files) {
            ClusterParser parser = new ClusterParser(log);
            ClusterERF erf = parser.parse(sf);
            log.fine(erf.toString());
            erfs.add(erf);
        }
        return erfs;
    }

    public static List<GridERF> getGridList(SourceRegion region) {
        ArrayList erfs = Lists.newArrayList();
        List<SourceFile> files = SourceMgr.get(region, SourceType.GRIDDED);
        if (files == null) {
            return null;
        }
        for (SourceFile sf : files) {
            GridParser parser = new GridParser(log);
            GridERF erf = parser.parse(sf);
            log.fine(erf.toString());
            erfs.add(erf);
        }
        return erfs;
    }

    public static List<FaultERF> getFaultList(SourceRegion region) {
        ArrayList erfs = Lists.newArrayList();
        List<SourceFile> files = SourceMgr.get(region, SourceType.FAULT);
        if (files == null) {
            return null;
        }
        for (SourceFile sf : files) {
            FaultParser parser = new FaultParser(log);
            FaultERF erf = parser.parse(sf);
            erfs.add(erf);
        }
        return erfs;
    }

    public static List<SubductionERF> getSubductionList(SourceRegion region) {
        ArrayList erfs = Lists.newArrayList();
        List<SourceFile> files = SourceMgr.get(region, SourceType.SUBDUCTION);
        if (files == null) {
            return null;
        }
        for (SourceFile sf : files) {
            SubductionParser parser = new SubductionParser(log);
            SubductionERF erf = parser.parse(sf);
            erfs.add(erf);
        }
        return erfs;
    }

    public static SourceRegion regionForSource(String name) {
        List<SourceFile> sfl = SourceMgr.get(null, null, name);
        if (sfl.isEmpty()) {
            return null;
        }
        return sfl.get(0).getRegion();
    }

    public static SourceType typeForSource(String name) {
        List<SourceFile> sfl = SourceMgr.get(null, null, name);
        if (sfl.isEmpty()) {
            return null;
        }
        return sfl.get(0).getType();
    }

    public static void main(String[] args) {
        System.out.println(Sources.getFaultList(SourceRegion.WUS));
    }

    static {
        Level level = Level.SEVERE;
        log.setLevel(level);
        for (Handler h : NSHMP_Utils.logger().getHandlers()) {
            h.setLevel(level);
        }
    }
}

