/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf.source;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opensha.commons.geo.Location;
import org.opensha.nshmp2.erf.source.FaultParser;
import org.opensha.nshmp2.erf.source.GR_Data;
import org.opensha.nshmp2.erf.source.SourceFile;
import org.opensha.nshmp2.erf.source.SourceMgr;
import org.opensha.nshmp2.erf.source.SubductionERF;
import org.opensha.nshmp2.erf.source.SubductionSource;
import org.opensha.nshmp2.util.FaultType;
import org.opensha.nshmp2.util.NSHMP_Utils;
import org.opensha.nshmp2.util.SourceIMR;
import org.opensha.nshmp2.util.SourceRegion;
import org.opensha.nshmp2.util.SourceType;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.util.FocalMech;

public class SubductionParser {
    private Logger log;

    SubductionParser(Logger log) {
        this.log = log;
    }

    SubductionERF parse(SourceFile sf) {
        ArrayList srcList = Lists.newArrayList();
        String name = sf.getName();
        SourceRegion srcRegion = sf.getRegion();
        SourceType srcType = sf.getType();
        SourceIMR srcIMR = SourceIMR.imrForSource(srcType, srcRegion, name, null);
        double srcWt = sf.getWeight();
        List<String> dat = sf.readLines();
        Iterator<String> srcLines = dat.iterator();
        SubductionParser.skipHeader(srcLines);
        double rMax = NSHMP_Utils.readDouble(srcLines.next(), 1);
        while (srcLines.hasNext()) {
            Object[] fltDat = StringUtils.split((String)srcLines.next());
            SubductionSource ss = new SubductionSource();
            ss.file = sf;
            ss.mfds = Lists.newArrayList();
            ss.type = FaultType.typeForID(NSHMP_Utils.readInt((String[])fltDat, 0));
            ss.mech = FocalMech.typeForID(NSHMP_Utils.readInt((String[])fltDat, 1));
            try {
                ss.nMag = NSHMP_Utils.readInt((String[])fltDat, 2);
                ss.name = StringUtils.join((Object[])fltDat, (char)' ', (int)3, (int)fltDat.length);
            }
            catch (NumberFormatException nfe) {
                ss.nMag = 1;
                ss.name = StringUtils.join((Object[])fltDat, (char)' ', (int)2, (int)fltDat.length);
            }
            List<String> mfdSrcDat = NSHMP_Utils.readLines(srcLines, ss.nMag);
            this.generateMFDs(ss, mfdSrcDat);
            this.generateTraces(srcLines, ss);
            SubductionParser.toLog(this.log, ss);
            srcList.add(ss);
        }
        return new SubductionERF(name, srcList, srcRegion, srcIMR, srcWt, rMax);
    }

    private void generateMFDs(SubductionSource ss, List<String> lines) {
        for (String line : lines) {
            GR_Data gr = new GR_Data(line, SourceType.SUBDUCTION);
            if (gr.nMag > 1 && gr.mMin < 8.8) {
                ss.floats = true;
            }
            double tmr = NSHMP_Utils.totalMoRate(gr.mMin, gr.nMag, gr.dMag, gr.aVal, gr.bVal);
            GutenbergRichterMagFreqDist mfd = new GutenbergRichterMagFreqDist(gr.mMin, gr.nMag, gr.dMag);
            mfd.setAllButTotCumRate(gr.mMin, gr.mMin + (double)(gr.nMag - 1) * gr.dMag, gr.weight * tmr, gr.bVal);
            ss.mfds.add(mfd);
            if (!this.log.isLoggable(Level.FINE)) continue;
            this.log.fine(IOUtils.LINE_SEPARATOR + "GR MFD: " + IOUtils.LINE_SEPARATOR + mfd.getMetadataString());
        }
    }

    private void generateTraces(Iterator<String> it, SubductionSource ss) {
        int upperTraceLen = NSHMP_Utils.readInt(it.next(), 0);
        ss.trace = SubductionParser.generateTrace(it, upperTraceLen, ss.name + " Upper Trace");
        int lowerTraceLen = NSHMP_Utils.readInt(it.next(), 0);
        ss.lowerTrace = SubductionParser.generateTrace(it, lowerTraceLen, ss.name + " Lower Trace");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(IOUtils.LINE_SEPARATOR + ss.trace.toString());
            this.log.fine(IOUtils.LINE_SEPARATOR + ss.lowerTrace.toString());
        }
    }

    private static FaultTrace generateTrace(Iterator<String> it, int traceCount, String name) {
        FaultTrace trace = new FaultTrace(name);
        List<String> traceDat = NSHMP_Utils.readLines(it, traceCount);
        for (String ptDat : traceDat) {
            String[] locDat = StringUtils.split((String)ptDat);
            trace.add(new Location(NSHMP_Utils.readDouble(locDat, 0), NSHMP_Utils.readDouble(locDat, 1), NSHMP_Utils.readDouble(locDat, 2)));
        }
        return trace;
    }

    private static void skipHeader(Iterator<String> it) {
        int numSta = NSHMP_Utils.readInt(it.next(), 0);
        Iterators.advance(it, (int)(numSta > 0 ? numSta : 2));
        it.next();
        int nP = NSHMP_Utils.readInt(it.next(), 0);
        for (int i = 0; i < nP; ++i) {
            it.next();
            it.next();
            int nAR = NSHMP_Utils.readInt(it.next(), 0);
            Iterators.advance(it, (int)nAR);
            it.next();
            it.next();
        }
        it.next();
    }

    static void toLog(Logger log, SubductionSource ss) {
        if (log.isLoggable(Level.INFO)) {
            log.info(IOUtils.LINE_SEPARATOR + ss.toString());
        }
    }

    public static void main(String[] args) {
        Logger log = NSHMP_Utils.logger();
        Level level = Level.FINE;
        log.setLevel(level);
        for (Handler h : NSHMP_Utils.logger().getHandlers()) {
            h.setLevel(level);
        }
        log.info(String.valueOf(new Date()) + " " + FaultParser.class.getName());
        SubductionParser dev = new SubductionParser(log);
        SourceFile sf = SourceMgr.get(SourceRegion.CASC, SourceType.SUBDUCTION, "cascadia.bot.8082.in").get(0);
        log.info("Source: " + sf.getName());
        SubductionERF erf = dev.parse(sf);
        for (ProbEqkSource source : erf) {
            ((SubductionSource)source).init();
            System.out.println("Source: " + source.getName());
            System.out.println("  size: " + source.getNumRuptures());
        }
    }
}

