/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.imr.impl;

import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.nshmp2.util.Params;
import org.opensha.nshmp2.util.SiteType;
import org.opensha.nshmp2.util.Utils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;

public class Campbell_2003_AttenRel
extends AttenuationRelationship
implements ParameterChangeListener {
    public static final String SHORT_NAME = "Campbell2003";
    private static final long serialVersionUID = 1234567890987654353L;
    public static final String NAME = "Campbell (2003)";
    private double[] pd = new double[]{0.0, 0.2, 1.0, 0.1, 0.3, 0.4, 0.5, 2.0, 0.03, 0.04, 0.05};
    private double[] c1 = new double[]{0.4492, 0.1325, -0.3177, 0.4064, -0.1483, -0.17039, -0.1333, -1.2483, 1.68, 1.28, 0.87};
    private double[] c1h = new double[]{0.0305, -0.4328, -0.6104, -0.1475, -0.6906, -0.67076736, -0.5907, -1.4306, 1.186, 0.72857, 0.3736};
    private double[] c2 = new double[]{0.633, 0.617, 0.451, 0.613, 0.609, 0.5722637, 0.534, 0.459, 0.622, 0.618622, 0.616};
    private double[] c3 = new double[]{-0.0427, -0.0586, -0.209, -0.0353, -0.0786, -0.10939892, -0.1379, -0.2552, -0.0362, -0.035693, -0.0353};
    private double[] c4 = new double[]{-1.591, -1.32, -1.158, -1.369, -1.28, -1.244142, -1.216, -1.124, -1.691, -1.566, -1.469};
    private double[] c5 = new double[]{0.683, 0.399, 0.299, 0.484, 0.349, 0.32603806, 0.318, 0.31, 0.922, 0.75759, 0.63};
    private double[] c6 = new double[]{0.416, 0.493, 0.503, 0.467, 0.502, 0.5040741, 0.503, 0.499, 0.376, 0.40246, 0.423};
    private double[] c7 = new double[]{1.14, 1.25, 1.067, 1.096, 1.241, 1.1833254, 1.116, 1.015, 0.759, 0.76576, 0.771};
    private double[] c8 = new double[]{-0.873, -0.928, -0.482, -1.284, -0.753, -0.6529481, -0.606, -0.417, -0.922, -1.1005, -1.239};
    private double[] c9 = new double[]{-0.00428, -0.0046, -0.00255, -0.00454, -0.00414, -0.0037463151, -0.00341, -0.00187, -0.00367, -0.0037319, -0.00378};
    private double[] c10 = new double[]{4.83E-4, 3.37E-4, 1.41E-4, 4.6E-4, 2.63E-4, 2.1878805E-4, 1.94E-4, 1.03E-4, 5.01E-4, 5.0044E-4, 5.0E-4};
    private double[] c11 = new double[]{1.03, 1.077, 1.11, 1.059, 1.081, 1.0901983, 1.098, 1.093, 1.03, 1.037, 1.042};
    private double[] c12 = new double[]{-0.086, -0.0838, -0.0793, -0.0838, -0.0838, -0.083180725, -0.0824, -0.0758, -0.086, -0.0848, -0.0838};
    private double[] c13 = new double[]{0.414, 0.478, 0.543, 0.46, 0.482, 0.49511834, 0.508, 0.551, 0.414, 0.43, 0.443};
    private double[] clamp = new double[]{3.0, 6.0, 0.0, 6.0, 6.0, 6.0, 3.0, 0.0, 6.0, 6.0, 6.0};
    private HashMap<Double, Integer> indexFromPerHashMap;
    private int iper;
    private double rRup;
    private double mag;
    private SiteType siteType;
    private boolean clampMean;
    private boolean clampStd;
    private BooleanParameter clampMeanParam;
    private BooleanParameter clampStdParam;
    private EnumParameter<SiteType> siteTypeParam;
    private static final Double MAG_WARN_MIN = 4.0;
    private static final Double MAG_WARN_MAX = 8.0;
    private static final Double DISTANCE_RUP_WARN_MIN = 0.0;
    private static final Double DISTANCE_RUP_WARN_MAX = 1000.0;
    private transient ParameterChangeWarningListener warningListener = null;
    private static final double LOG_70 = 4.2484952;
    private static final double LOG_130 = 4.8675345;

    public Campbell_2003_AttenRel(ParameterChangeWarningListener listener) {
        this.warningListener = listener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = Maps.newHashMap();
        for (int i = 0; i < this.pd.length; ++i) {
            this.indexFromPerHashMap.put(this.pd[i], i);
        }
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
        this.setParamDefaults();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.siteTypeParam.setValue((SiteType)((Object)site.getParameter(this.siteTypeParam.getName()).getValue()));
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
        }
    }

    private void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("Intensity Measure Param not set");
        }
        this.iper = this.indexFromPerHashMap.get(this.saPeriodParam.getValue());
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.rRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getMean(this.iper, this.siteType, this.rRup, this.mag);
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getStdDev(this.iper, this.mag);
    }

    @Override
    public void setParamDefaults() {
        this.siteTypeParam.setValueAsDefault();
        this.clampMeanParam.setValueAsDefault();
        this.clampStdParam.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.siteType = (SiteType)((Object)this.siteTypeParam.getValue());
        this.clampMean = (Boolean)this.clampMeanParam.getValue();
        this.clampStd = (Boolean)this.clampStdParam.getValue();
        this.rRup = (Double)this.distanceRupParam.getValue();
        this.mag = (Double)this.magParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.siteTypeParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.magParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.siteTypeParam = Params.createSiteType();
        this.siteParams.clear();
        this.siteParams.addParameter(this.siteTypeParam);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_RUP_WARN_MIN, DISTANCE_RUP_WARN_MAX);
        warn.setNonEditable();
        this.distanceRupParam.addParameterChangeWarningListener(this.listener);
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint perConstraint = new DoubleDiscreteConstraint();
        for (int i = 0; i < this.pd.length; ++i) {
            perConstraint.addDouble((Double)this.pd[i]);
        }
        perConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(perConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.clampMeanParam = new BooleanParameter("Clamp Mean", true);
        this.clampStdParam = new BooleanParameter("Clamp Std. Dev.", true);
        this.otherParams.addParameter(this.clampMeanParam);
        this.otherParams.addParameter(this.clampStdParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        if (pName.equals("DistanceRup")) {
            this.rRup = (Double)val;
        } else if (pName.equals(this.siteTypeParam.getName())) {
            this.siteType = (SiteType)((Object)this.siteTypeParam.getValue());
        } else if (pName.equals(this.clampMeanParam.getName())) {
            this.clampMean = (Boolean)this.clampMeanParam.getValue();
        } else if (pName.equals(this.clampStdParam.getName())) {
            this.clampStd = (Boolean)this.clampStdParam.getValue();
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("SA Period")) {
            this.intensityMeasureChanged = true;
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.distanceRupParam.removeParameterChangeListener(this);
        this.siteTypeParam.removeParameterChangeListener(this);
        this.clampMeanParam.removeParameterChangeListener(this);
        this.clampStdParam.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.saPeriodParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceRupParam.addParameterChangeListener(this);
        this.siteTypeParam.addParameterChangeListener(this);
        this.clampMeanParam.addParameterChangeListener(this);
        this.clampMeanParam.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
    }

    public URL getAttenuationRelationshipURL() throws MalformedURLException {
        return null;
    }

    private double getMean(int iper, SiteType st, double rRup, double mag) {
        double period = this.pd[iper];
        double gnd0 = st == SiteType.HARD_ROCK ? this.c1h[iper] : this.c1[iper];
        double gndm = gnd0 + this.c2[iper] * mag + this.c3[iper] * (8.5 - mag) * (8.5 - mag);
        double cfac = Math.pow(this.c5[iper] * Math.exp(this.c6[iper] * mag), 2.0);
        double arg = Math.sqrt(rRup * rRup + cfac);
        double fac = 0.0;
        if (rRup > 70.0) {
            fac = this.c7[iper] * (Math.log(rRup) - 4.2484952);
        }
        if (rRup > 130.0) {
            fac += this.c8[iper] * (Math.log(rRup) - 4.8675345);
        }
        double gnd = gndm + this.c4[iper] * Math.log(arg) + fac + (this.c9[iper] + this.c10[iper] * mag) * rRup;
        if (this.clampMean) {
            gnd = Utils.ceusMeanClip(period, gnd);
        }
        return gnd;
    }

    private double getStdDev(int iper, double mag) {
        return mag < 7.16 ? this.c11[iper] + this.c12[iper] * mag : this.c13[iper];
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc imls) {
        return Utils.getExceedProbabilities(imls, this.getMean(), this.getStdDev(), this.clampStd, this.clamp[this.iper]);
    }
}

