/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.imr.impl;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.nshmp2.util.Params;
import org.opensha.nshmp2.util.SiteType;
import org.opensha.nshmp2.util.Utils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;

public class FrankelEtAl_1996_AttenRel
extends AttenuationRelationship
implements ParameterChangeListener {
    public static final String SHORT_NAME = "FrankelEtAl1996";
    private static final long serialVersionUID = 1234567890987654353L;
    public static final String NAME = "Frankel et al. (1996)";
    private List<GM_Table> gmTablesSoft;
    private List<GM_Table> gmTablesHard;
    double[] pd = new double[]{0.0, 0.2, 1.0, 0.1, 0.3, 0.5, 2.0};
    double[] bsigma = new double[]{0.326, 0.326, 0.347, 0.326, 0.326, 0.326, 0.347};
    double[] clamp = new double[]{3.0, 6.0, 0.0, 6.0, 6.0, 6.0, 0.0};
    String[] srTableNames = new String[]{"pgak01l.tbl", "t0p2k01l.tbl", "t1p0k01l.tbl", "t0p1k01l.tbl", "t0p3k01l.tbl", "t0p5k01l.tbl", "t2p0k01l.tbl"};
    String[] hrTableNames = new String[]{"pgak006.tbl", "t0p2k006.tbl", "t1p0k006.tbl", "t0p1k006.tbl", "t0p3k006.tbl", "t0p5k006.tbl", "t2p0k006.tbl"};
    private HashMap<Double, Integer> indexFromPerHashMap;
    private int iper;
    private double rRup;
    private double mag;
    private SiteType siteType;
    private boolean clampMean;
    private boolean clampStd;
    private BooleanParameter clampMeanParam;
    private BooleanParameter clampStdParam;
    private EnumParameter<SiteType> siteTypeParam;
    private static final Double MAG_WARN_MIN = 4.0;
    private static final Double MAG_WARN_MAX = 8.0;
    private static final Double DISTANCE_RUP_WARN_MIN = 0.0;
    private static final Double DISTANCE_RUP_WARN_MAX = 1000.0;
    private transient ParameterChangeWarningListener warningListener = null;

    public FrankelEtAl_1996_AttenRel(ParameterChangeWarningListener listener) {
        int i;
        this.warningListener = listener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = Maps.newHashMap();
        for (i = 0; i < this.pd.length; ++i) {
            this.indexFromPerHashMap.put(this.pd[i], i);
        }
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
        this.gmTablesSoft = Lists.newArrayList();
        this.gmTablesHard = Lists.newArrayList();
        try {
            for (i = 0; i < this.pd.length; ++i) {
                URL fSoft = Utils.getResource("/imr/" + this.srTableNames[i]);
                this.gmTablesSoft.add(new GM_Table(fSoft));
                URL fHard = Utils.getResource("/imr/" + this.hrTableNames[i]);
                this.gmTablesHard.add(new GM_Table(fHard));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.setParamDefaults();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.siteTypeParam.setValue((SiteType)((Object)site.getParameter(this.siteTypeParam.getName()).getValue()));
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
        }
    }

    private void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("Intensity Measure Param not set");
        }
        this.iper = this.indexFromPerHashMap.get(this.saPeriodParam.getValue());
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.rRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getMean(this.iper, this.siteType, this.rRup, this.mag);
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getStdDev(this.iper);
    }

    @Override
    public void setParamDefaults() {
        this.siteTypeParam.setValueAsDefault();
        this.clampMeanParam.setValueAsDefault();
        this.clampStdParam.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.siteType = (SiteType)((Object)this.siteTypeParam.getValue());
        this.clampMean = (Boolean)this.clampMeanParam.getValue();
        this.clampStd = (Boolean)this.clampStdParam.getValue();
        this.rRup = (Double)this.distanceRupParam.getValue();
        this.mag = (Double)this.magParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.siteTypeParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.stdDevIndependentParams.clear();
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.siteTypeParam = Params.createSiteType();
        this.siteParams.clear();
        this.siteParams.addParameter(this.siteTypeParam);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        this.distanceRupParam.addParameterChangeWarningListener(this.warningListener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_RUP_WARN_MIN, DISTANCE_RUP_WARN_MAX);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint perConstraint = new DoubleDiscreteConstraint();
        for (int i = 0; i < this.pd.length; ++i) {
            perConstraint.addDouble((Double)this.pd[i]);
        }
        perConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(perConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.clampMeanParam = new BooleanParameter("Clamp Mean", true);
        this.clampStdParam = new BooleanParameter("Clamp Std. Dev.", true);
        this.otherParams.addParameter(this.clampMeanParam);
        this.otherParams.addParameter(this.clampStdParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        if (pName.equals("DistanceRup")) {
            this.rRup = (Double)val;
        } else if (pName.equals(this.siteTypeParam.getName())) {
            this.siteType = (SiteType)((Object)this.siteTypeParam.getValue());
        } else if (pName.equals(this.clampMeanParam.getName())) {
            this.clampMean = (Boolean)this.clampMeanParam.getValue();
        } else if (pName.equals(this.clampStdParam.getName())) {
            this.clampStd = (Boolean)this.clampStdParam.getValue();
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("SA Period")) {
            this.intensityMeasureChanged = true;
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.distanceRupParam.removeParameterChangeListener(this);
        this.siteTypeParam.removeParameterChangeListener(this);
        this.clampMeanParam.removeParameterChangeListener(this);
        this.clampStdParam.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.saPeriodParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceRupParam.addParameterChangeListener(this);
        this.siteTypeParam.addParameterChangeListener(this);
        this.clampMeanParam.addParameterChangeListener(this);
        this.clampMeanParam.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
    }

    public URL getAttenuationRelationshipURL() throws MalformedURLException {
        return null;
    }

    private double getMean(int iper, SiteType st, double rRup, double mag) {
        GM_Table table = st == SiteType.HARD_ROCK ? this.gmTablesHard.get(iper) : this.gmTablesSoft.get(iper);
        double gnd = table.get(mag, rRup);
        if (this.clampMean) {
            gnd = Utils.ceusMeanClip(this.pd[iper], gnd);
        }
        return gnd;
    }

    private double getStdDev(int iper) {
        return this.bsigma[iper] * 2.302585093;
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc imls) {
        return Utils.getExceedProbabilities(imls, this.getMean(), this.getStdDev(), this.clampStd, this.clamp[this.iper]);
    }

    static class GM_Table {
        static final Range<Double> mRange = Range.closed((Comparable)Double.valueOf(4.4), (Comparable)Double.valueOf(8.2));
        static final Range<Double> dRange = Range.closed((Comparable)Double.valueOf(1.0), (Comparable)Double.valueOf(3.0));
        static final int M_IDX = 19;
        static final int D_IDX = 20;
        List<List<Double>> gmTable;

        GM_Table(URL data) throws IOException {
            this.gmTable = (List)Resources.readLines((URL)data, (Charset)Charsets.US_ASCII, (LineProcessor)new TableParser());
        }

        double get(double mag, double dist) {
            dist = Math.log10(dist);
            if (!mRange.contains((Comparable)Double.valueOf(mag))) {
                mag = mag < (Double)mRange.lowerEndpoint() ? (Double)mRange.lowerEndpoint() : (Double)mRange.upperEndpoint();
            }
            if (!dRange.contains((Comparable)Double.valueOf(dist))) {
                dist = dist < (Double)dRange.lowerEndpoint() ? (Double)dRange.lowerEndpoint() : (Double)dRange.upperEndpoint();
            }
            int mIdx = GM_Table.idxForMag(mag);
            int dIdx = GM_Table.idxForDist(dist);
            int mIdx1 = Math.min(mIdx + 1, 19);
            int dIdx1 = Math.min(dIdx + 1, 20);
            double mFrac = (mag - GM_Table.magForIdx(mIdx)) / 0.2;
            double dFrac = (dist - GM_Table.distForIdx(dIdx)) / 0.1;
            double gm1 = this.gmTable.get(dIdx).get(mIdx);
            double gm2 = this.gmTable.get(dIdx).get(mIdx1);
            double gm3 = this.gmTable.get(dIdx1).get(mIdx);
            double gm4 = this.gmTable.get(dIdx1).get(mIdx1);
            double gmDlo = gm1 + mFrac * (gm2 - gm1);
            double gmDhi = gm3 + mFrac * (gm4 - gm3);
            double gm = gmDlo + dFrac * (gmDhi - gmDlo);
            return gm * 2.302587647998821;
        }

        private static double magForIdx(int idx) {
            return (double)idx * 0.2 + (Double)mRange.lowerEndpoint();
        }

        private static int idxForMag(double mag) {
            return (int)(mag * 10.0 - (Double)mRange.lowerEndpoint() * 10.0) / 2;
        }

        private static double distForIdx(int idx) {
            return (double)idx * 0.1 + (Double)dRange.lowerEndpoint();
        }

        private static int idxForDist(double dist) {
            return (int)(dist * 10.0 - (Double)dRange.lowerEndpoint() * 10.0);
        }
    }

    static class TableParser
    implements LineProcessor<List<List<Double>>> {
        boolean firstLine = true;
        List<List<Double>> data = Lists.newArrayList();

        TableParser() {
        }

        public List<List<Double>> getResult() {
            return this.data;
        }

        public boolean processLine(String line) throws IOException {
            if (this.firstLine) {
                this.firstLine = false;
                return true;
            }
            Object[] values = StringUtils.split((String)line);
            values = (String[])ArrayUtils.remove((Object[])values, (int)0);
            this.data.add(Utils.stringsToDoubles((String[])values));
            return true;
        }
    }
}

