/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.imr.ngaw2;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.nshmp2.util.Period;
import org.opensha.nshmp2.util.Utils;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.attenRelImpl.ngaw2.CB_2014;
import org.opensha.sha.imr.attenRelImpl.ngaw2.FaultStyle;
import org.opensha.sha.imr.attenRelImpl.ngaw2.IMT;
import org.opensha.sha.imr.attenRelImpl.ngaw2.NGAW2_GMM;
import org.opensha.sha.imr.attenRelImpl.ngaw2.ScalarGroundMotion;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;

public class NSHMP14_WUS_CB_EpiUp
extends AttenuationRelationship
implements ParameterChangeListener {
    public static final String NAME = "NSHMP 2013 Western US Combined";
    public static final String SHORT_NAME = "NSHMP14_WUS";
    private NGAW2_GMM gmpe;
    public static final String IMR_UNCERT_PARAM_NAME = "IMR uncertainty";
    private boolean epi = false;
    private IMT imt = null;
    private double Mw = Double.NaN;
    private double rJB = Double.NaN;
    private double rRup = Double.NaN;
    private double rX = Double.NaN;
    private double dip = Double.NaN;
    private double width = Double.NaN;
    private double zTop = Double.NaN;
    private double zHyp = Double.NaN;
    private double vs30 = Double.NaN;
    private boolean vsInf = true;
    private double z2p5 = Double.NaN;
    private double z1p0 = Double.NaN;
    private FaultStyle style = FaultStyle.UNKNOWN;
    private static final int EPI_CT = 3;
    private static final double[] EPI_SIGN = new double[]{-1.0, 0.0, 1.0, 0.0};
    private static final double[] EPI_WT = new double[]{0.185, 0.63, 0.185};
    private static final double[][] EPI_VAL = new double[][]{{0.375, 0.25, 0.4}, {0.22, 0.23, 0.36}, {0.22, 0.23, 0.33}};

    public NSHMP14_WUS_CB_EpiUp() {
        this.gmpe = new CB_2014();
        BooleanParameter imrUncertParam = new BooleanParameter(IMR_UNCERT_PARAM_NAME, this.epi);
        imrUncertParam.addParameterChangeListener(this);
        this.otherParams.addParameter(imrUncertParam);
        this.initSupportedIntensityMeasureParams();
    }

    @Override
    public void setParamDefaults() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        ArrayList perVals = Lists.newArrayList();
        for (Period p : Period.getWUS()) {
            perVals.add(p.getValue());
        }
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint(perVals);
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint, 1.0, false);
        this.saPeriodParam.addParameterChangeListener(this);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    @Override
    protected void initSiteParams() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void initEqkRuptureParams() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void initPropagationEffectParams() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setPropagationEffectParams() {
        throw new UnsupportedOperationException();
    }

    private void updateArgs() {
        this.vs30 = (Double)this.site.getParameter("Vs30").getValue();
        this.z2p5 = Double.NaN;
        this.z1p0 = Double.NaN;
        this.Mw = this.eqkRupture.getMag();
        RuptureSurface surf = this.eqkRupture.getRuptureSurface();
        Location loc = this.site.getLocation();
        this.rJB = surf.getDistanceJB(loc);
        this.rRup = surf.getDistanceRup(loc);
        this.rX = surf.getDistanceX(loc);
        this.dip = surf.getAveDip();
        this.width = surf.getAveWidth();
        this.zTop = surf.getAveRupTopDepth();
        this.zHyp = this.zTop + Math.sin(this.dip * GeoTools.TO_RAD) * this.width / 2.0;
        this.style = this.getFaultStyleForRake(this.eqkRupture.getAveRake());
    }

    private void initGMPE() {
        this.gmpe.set_IMT(this.imt);
        this.gmpe.set_Mw(this.Mw);
        this.gmpe.set_rJB(this.rJB);
        this.gmpe.set_rRup(this.rRup);
        this.gmpe.set_rX(this.rX);
        this.gmpe.set_dip(this.dip);
        this.gmpe.set_width(this.width);
        this.gmpe.set_zTop(this.zTop);
        this.gmpe.set_zHyp(this.zHyp);
        this.gmpe.set_vs30(this.vs30);
        this.gmpe.set_vsInf(this.vsInf);
        this.gmpe.set_z2p5(this.z2p5);
        this.gmpe.set_z1p0(this.z1p0);
        this.gmpe.set_fault(this.style);
    }

    private FaultStyle getFaultStyleForRake(double rake) {
        return rake >= 45.0 && rake <= 135.0 ? FaultStyle.REVERSE : (rake >= -135.0 && rake <= -45.0 ? FaultStyle.NORMAL : FaultStyle.STRIKE_SLIP);
    }

    @Override
    public double getMean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getStdDev() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getEpsilon() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getEpsilon(double iml) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc imls) throws ParameterException {
        this.updateArgs();
        this.initGMPE();
        ScalarGroundMotion sgm = this.gmpe.calc();
        double mean = sgm.mean() + NSHMP14_WUS_CB_EpiUp.getUncertainty(this.Mw, this.rJB);
        double sigma = sgm.stdDev();
        return Utils.getExceedProbabilities(imls, mean, sigma, false, 0.0);
    }

    @Override
    public double getExceedProbability() throws ParameterException, IMRException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected double getExceedProbability(double mean, double stdDev, double iml) throws ParameterException, IMRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getExceedProbability(double iml) throws ParameterException, IMRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getIML_AtExceedProb() throws ParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getIML_AtExceedProb(double exceedProb) throws ParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DiscretizedFunc getSA_ExceedProbSpectrum(double iml) throws ParameterException, IMRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DiscretizedFunc getSA_IML_AtExceedProbSpectrum(double exceedProb) throws ParameterException, IMRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setIntensityMeasureLevel(Double iml) throws ParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setIntensityMeasureLevel(Object iml) throws ParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setIntensityMeasure(String intensityMeasureName) throws ParameterException {
        super.setIntensityMeasure(intensityMeasureName);
        if (intensityMeasureName.equals("PGA")) {
            this.imt = IMT.PGA;
        }
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        if (e.getParameterName().equals("SA Period")) {
            double period = (Double)this.getParameter("SA Period").getValue();
            IMT iMT = this.imt = period == 0.0 ? IMT.PGA : IMT.getSA((Double)this.getParameter("SA Period").getValue());
        }
        if (e.getParameterName().equals(IMR_UNCERT_PARAM_NAME)) {
            this.epi = (Boolean)e.getParameter().getValue();
        }
    }

    private static double getUncertainty(double M, double D) {
        int mi;
        int n = M < 6.0 ? 0 : (mi = M < 7.0 ? 1 : 2);
        int di = D < 10.0 ? 0 : (D < 30.0 ? 1 : 2);
        return EPI_VAL[di][mi];
    }
}

