/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.util;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;

public enum Period {
    GM0P00(0.0, Values.per0p00, "PGA"),
    GM0P10(0.1, Values.per0p10, "10Hz"),
    GM0P20(0.2, Values.per0p20, "5Hz"),
    GM0P30(0.3, Values.per0p30, "3.3Hz"),
    GM0P50(0.5, Values.per0p50, "2Hz"),
    GM0P75(0.75, Values.per0p75, "1.5Hz"),
    GM1P00(1.0, Values.per1p00, "1Hz"),
    GM1P50(1.5, Values.per1p50, "1.5sec"),
    GM2P00(2.0, Values.per2p00, "2sec"),
    GM3P00(3.0, Values.per3p00, "3sec"),
    GM4P00(4.0, Values.per4p00, "4sec"),
    GM5P00(5.0, Values.per5p00, "5sec");

    private List<Double> imls;
    private double period;
    private String label;

    private Period(double period, double[] valueArray, String label) {
        this.period = period;
        this.label = label;
        this.imls = ImmutableList.copyOf((Collection)Doubles.asList((double[])valueArray));
    }

    public List<Double> getIMLs() {
        return this.imls;
    }

    public double getValue() {
        return this.period;
    }

    public String getLabel() {
        return this.label;
    }

    public static Period valueForPeriod(double period) {
        for (Period p : Period.values()) {
            if (p.period != period) continue;
            return p;
        }
        return null;
    }

    public ArbitrarilyDiscretizedFunc getFunction() {
        ArbitrarilyDiscretizedFunc f = new ArbitrarilyDiscretizedFunc();
        for (double d : this.getIMLs()) {
            f.set(d, 1.0);
        }
        return f;
    }

    public ArbitrarilyDiscretizedFunc getLogFunction() {
        ArbitrarilyDiscretizedFunc f = new ArbitrarilyDiscretizedFunc();
        for (double d : this.getIMLs()) {
            f.set(Math.log(d), 1.0);
        }
        return f;
    }

    public static EnumSet<Period> getWUS() {
        return EnumSet.allOf(Period.class);
    }

    public static EnumSet<Period> getCEUS() {
        return EnumSet.of(GM0P00, GM0P20, GM0P50, GM1P00, GM2P00);
    }

    private static class Values {
        static double[] per0p00 = new double[]{0.005, 0.007, 0.0098, 0.0137, 0.0192, 0.0269, 0.0376, 0.0527, 0.0738, 0.103, 0.145, 0.203, 0.284, 0.397, 0.556, 0.778, 1.09, 1.52, 2.13};
        static double[] per0p10 = new double[]{0.0025, 0.006, 0.0098, 0.0137, 0.0192, 0.0269, 0.0376, 0.0527, 0.0738, 0.103, 0.145, 0.203, 0.284, 0.397, 0.556, 0.778, 1.09, 1.52, 2.13, 3.3};
        static double[] per0p20 = new double[]{0.005, 0.0075, 0.0113, 0.0169, 0.0253, 0.038, 0.057, 0.0854, 0.128, 0.192, 0.288, 0.432, 0.649, 0.973, 1.46, 2.19, 3.28, 4.92, 7.38};
        static double[] per0p30 = new double[]{0.0025, 0.005, 0.0075, 0.0113, 0.0169, 0.0253, 0.038, 0.057, 0.0854, 0.128, 0.192, 0.288, 0.432, 0.649, 0.973, 1.46, 2.19, 3.28, 4.92, 7.38};
        static double[] per0p50 = per0p30;
        static double[] per1p00 = new double[]{0.0025, 0.00375, 0.00563, 0.00844, 0.0127, 0.019, 0.0285, 0.0427, 0.0641, 0.0961, 0.144, 0.216, 0.324, 0.487, 0.73, 1.09, 1.64, 2.46, 3.69, 5.54};
        static double[] per1p50 = per1p00;
        static double[] per2p00 = per1p00;
        static double[] per3p00 = per1p00;
        static double[] per4p00 = per1p00;
        static double[] per5p00 = per1p00;
        static double[] per0p75 = per1p00;

        private Values() {
        }
    }
}

