/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.util;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.EnumMap;
import java.util.Map;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.nshmp2.imr.NSHMP08_CEUS;
import org.opensha.nshmp2.imr.NSHMP08_CEUS_Grid;
import org.opensha.nshmp2.imr.NSHMP08_SUB_Interface;
import org.opensha.nshmp2.imr.NSHMP08_SUB_SlabGrid;
import org.opensha.nshmp2.imr.NSHMP08_WUS;
import org.opensha.nshmp2.imr.NSHMP08_WUS_Grid;
import org.opensha.nshmp2.imr.ngaw2.NSHMP14_WUS_ASK;
import org.opensha.nshmp2.imr.ngaw2.NSHMP14_WUS_ASK_EpiDn;
import org.opensha.nshmp2.imr.ngaw2.NSHMP14_WUS_ASK_EpiUp;
import org.opensha.nshmp2.imr.ngaw2.NSHMP14_WUS_BSSA;
import org.opensha.nshmp2.imr.ngaw2.NSHMP14_WUS_BSSA_EpiDn;
import org.opensha.nshmp2.imr.ngaw2.NSHMP14_WUS_BSSA_EpiUp;
import org.opensha.nshmp2.imr.ngaw2.NSHMP14_WUS_CB;
import org.opensha.nshmp2.imr.ngaw2.NSHMP14_WUS_CB_EpiDn;
import org.opensha.nshmp2.imr.ngaw2.NSHMP14_WUS_CB_EpiUp;
import org.opensha.nshmp2.imr.ngaw2.NSHMP14_WUS_CY;
import org.opensha.nshmp2.imr.ngaw2.NSHMP14_WUS_CY_EpiDn;
import org.opensha.nshmp2.imr.ngaw2.NSHMP14_WUS_CY_EpiUp;
import org.opensha.nshmp2.imr.ngaw2.NSHMP14_WUS_GK;
import org.opensha.nshmp2.imr.ngaw2.NSHMP14_WUS_Idriss;
import org.opensha.nshmp2.imr.ngaw2.NSHMP14_WUS_Idriss_EpiDn;
import org.opensha.nshmp2.imr.ngaw2.NSHMP14_WUS_Idriss_EpiUp;
import org.opensha.nshmp2.util.FaultCode;
import org.opensha.nshmp2.util.Period;
import org.opensha.nshmp2.util.SourceRegion;
import org.opensha.nshmp2.util.SourceType;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.attenRelImpl.ngaw2.NSHMP14_WUS;

public enum SourceIMR {
    WUS_FAULT(NSHMP08_WUS.class),
    WUS_FAULT_14(NSHMP14_WUS.class),
    WUS_FAULT_14_AS(NSHMP14_WUS_ASK.class),
    WUS_FAULT_14_BS(NSHMP14_WUS_BSSA.class),
    WUS_FAULT_14_CB(NSHMP14_WUS_CB.class),
    WUS_FAULT_14_CY(NSHMP14_WUS_CY.class),
    WUS_FAULT_14_GK(NSHMP14_WUS_GK.class),
    WUS_FAULT_14_ID(NSHMP14_WUS_Idriss.class),
    WUS_FAULT_14_AS_EPI_UP(NSHMP14_WUS_ASK_EpiUp.class),
    WUS_FAULT_14_BS_EPI_UP(NSHMP14_WUS_BSSA_EpiUp.class),
    WUS_FAULT_14_CB_EPI_UP(NSHMP14_WUS_CB_EpiUp.class),
    WUS_FAULT_14_CY_EPI_UP(NSHMP14_WUS_CY_EpiUp.class),
    WUS_FAULT_14_ID_EPI_UP(NSHMP14_WUS_Idriss_EpiUp.class),
    WUS_FAULT_14_AS_EPI_DN(NSHMP14_WUS_ASK_EpiDn.class),
    WUS_FAULT_14_BS_EPI_DN(NSHMP14_WUS_BSSA_EpiDn.class),
    WUS_FAULT_14_CB_EPI_DN(NSHMP14_WUS_CB_EpiDn.class),
    WUS_FAULT_14_CY_EPI_DN(NSHMP14_WUS_CY_EpiDn.class),
    WUS_FAULT_14_ID_EPI_DN(NSHMP14_WUS_Idriss_EpiDn.class),
    WUS_GRID(NSHMP08_WUS_Grid.class),
    WUS_SLAB(NSHMP08_SUB_SlabGrid.class),
    WUS_SUB(NSHMP08_SUB_Interface.class),
    CEUS_FAULT(NSHMP08_CEUS.class),
    CEUS_GRID(NSHMP08_CEUS_Grid.class);

    private Class<? extends ScalarIMR> clazz;

    private SourceIMR(Class<? extends ScalarIMR> clazz) {
        this.clazz = clazz;
    }

    public static Map<SourceIMR, ScalarIMR> map(Period p) {
        EnumMap map = Maps.newEnumMap(SourceIMR.class);
        for (SourceIMR simr : SourceIMR.values()) {
            map.put(simr, simr.instance(p));
        }
        return map;
    }

    public ScalarIMR instance(Period p) {
        try {
            Constructor<? extends ScalarIMR> con = this.clazz.getConstructor(new Class[0]);
            ScalarIMR imr = con.newInstance(new Object[0]);
            imr.setIntensityMeasure(p == Period.GM0P00 ? "PGA" : "SA");
            try {
                imr.getParameter("SA Period").setValue(p.getValue());
            }
            catch (ConstraintException constraintException) {
                // empty catch block
            }
            return imr;
        }
        catch (Exception e) {
            System.out.println(e.getCause());
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static SourceIMR imrForSource(SourceType type, SourceRegion region, String name, FaultCode code) {
        switch (type) {
            case GRIDDED: {
                if (region == SourceRegion.CEUS) {
                    return code == FaultCode.FIXED ? CEUS_FAULT : CEUS_GRID;
                }
                if (name.contains("deep")) {
                    return WUS_SLAB;
                }
                return code == FaultCode.FIXED ? WUS_FAULT : WUS_GRID;
            }
            case FAULT: {
                if (region == SourceRegion.CEUS) {
                    return CEUS_FAULT;
                }
                return WUS_FAULT;
            }
            case CLUSTER: {
                return CEUS_FAULT;
            }
            case SUBDUCTION: {
                return WUS_SUB;
            }
        }
        return null;
    }
}

