/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.rowset.CachedRowSet;
import org.opensha.refFaultParamDb.dao.db.CombinedDisplacementInfoDB_DAO;
import org.opensha.refFaultParamDb.dao.db.CombinedNumEventsInfoDB_DAO;
import org.opensha.refFaultParamDb.dao.db.CombinedSlipRateInfoDB_DAO;
import org.opensha.refFaultParamDb.dao.db.ContributorDB_DAO;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.EventSequenceDB_DAO;
import org.opensha.refFaultParamDb.dao.db.PaleoSitePublicationsDB_DAO;
import org.opensha.refFaultParamDb.dao.db.ReferenceDB_DAO;
import org.opensha.refFaultParamDb.dao.db.TimeInstanceDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.vo.CombinedDisplacementInfo;
import org.opensha.refFaultParamDb.vo.CombinedEventsInfo;
import org.opensha.refFaultParamDb.vo.CombinedNumEventsInfo;
import org.opensha.refFaultParamDb.vo.CombinedSlipRateInfo;
import org.opensha.refFaultParamDb.vo.EventSequence;
import org.opensha.refFaultParamDb.vo.Reference;

public class CombinedEventsInfoDB_DAO {
    private static final String TABLE_NAME = "Combined_Events_Info";
    private static final String SEQUENCE_NAME = "Combined_Events_Sequence";
    private static final String INFO_ID = "Info_Id";
    private static final String SITE_ID = "Site_Id";
    private static final String SITE_ENTRY_DATE = "Site_Entry_Date";
    private static final String ENTRY_DATE = "Entry_Date";
    private static final String CONTRIBUTOR_ID = "Contributor_Id";
    private static final String START_TIME_ID = "Start_Time_Id";
    private static final String END_TIME_ID = "End_Time_Id";
    private static final String DATED_FEATURE_COMMENTS = "Dated_Feature_Comments";
    private static final String NEOKINEMA_FAULT_NUMBER = "NeoKinema_Fault_Number";
    private static final String FAULT_SECTION_ID = "Fault_Section_Id";
    private static final String DATA_SOURCE = "Data_Source";
    private static final String REFERENCES_TABLE_NAME = "Combined_Events_References";
    private static final String COMBINED_EVENTS_ID = "Combined_Events_Id";
    private static final String COMBINED_EVENTS_ENTRY_DATE = "Combined_Events_Entry_Date";
    private static final String REFERENCE_ID = "Reference_Id";
    private static final String IS_EXPERT_OPINION = "Is_Expert_Opinion";
    private static final String IS_RECORD_DELETED = "Is_Record_Deleted";
    private static final String NO = "N";
    private static final String YES = "Y";
    private DB_AccessAPI dbAccess;
    private TimeInstanceDB_DAO timeInstanceDAO;
    private ReferenceDB_DAO referenceDAO;
    private ContributorDB_DAO contributorDAO;
    private CombinedDisplacementInfoDB_DAO combinedDispInfoDB_DAO;
    private CombinedNumEventsInfoDB_DAO combinedNumEventsInfoDB_DAO;
    private CombinedSlipRateInfoDB_DAO combinedSlipRateInfoDB_DAO;
    private EventSequenceDB_DAO eventSequenceDAO;
    private PaleoSitePublicationsDB_DAO paleoSitePublicationDAO;

    public CombinedEventsInfoDB_DAO(DB_AccessAPI dbAccess) {
        this.setDB_Connection(dbAccess);
    }

    public void setDB_Connection(DB_AccessAPI dbAccess) {
        this.dbAccess = dbAccess;
        this.timeInstanceDAO = new TimeInstanceDB_DAO(dbAccess);
        this.referenceDAO = new ReferenceDB_DAO(dbAccess);
        this.contributorDAO = new ContributorDB_DAO(dbAccess);
        this.combinedDispInfoDB_DAO = new CombinedDisplacementInfoDB_DAO(dbAccess);
        this.combinedNumEventsInfoDB_DAO = new CombinedNumEventsInfoDB_DAO(dbAccess);
        this.combinedSlipRateInfoDB_DAO = new CombinedSlipRateInfoDB_DAO(dbAccess);
        this.eventSequenceDAO = new EventSequenceDB_DAO(dbAccess);
        this.paleoSitePublicationDAO = new PaleoSitePublicationsDB_DAO(dbAccess);
    }

    public void addCombinedEventsInfo(CombinedEventsInfo combinedEventsInfo) {
        String systemDate;
        int infoId;
        try {
            infoId = this.dbAccess.getNextSequenceNumber(SEQUENCE_NAME);
            systemDate = this.dbAccess.getSystemDate();
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        Object colNames = "";
        Object colVals = "";
        if (combinedEventsInfo.getStartTime() != null) {
            int startTimeId = this.timeInstanceDAO.addTimeInstance(combinedEventsInfo.getStartTime());
            colNames = (String)colNames + "Start_Time_Id,";
            colVals = (String)colVals + startTimeId + ",";
        }
        if (combinedEventsInfo.getEndTime() != null) {
            int endTimeId = this.timeInstanceDAO.addTimeInstance(combinedEventsInfo.getEndTime());
            colNames = (String)colNames + "End_Time_Id,";
            colVals = (String)colVals + endTimeId + ",";
        }
        if (combinedEventsInfo.getDataSource() != null) {
            colNames = (String)colNames + "Data_Source,";
            colVals = (String)colVals + "'" + combinedEventsInfo.getDataSource() + "',";
        }
        String expertOpinion = NO;
        if (combinedEventsInfo.getIsExpertOpinion()) {
            expertOpinion = YES;
        }
        String sql = "insert into Combined_Events_Info(Info_Id,Site_Id,Site_Entry_Date,Entry_Date,Contributor_Id," + (String)colNames + "Dated_Feature_Comments,Is_Expert_Opinion,Is_Record_Deleted,NeoKinema_Fault_Number) values (" + infoId + "," + combinedEventsInfo.getSiteId() + ",'" + combinedEventsInfo.getSiteEntryDate() + "','" + systemDate + "'," + SessionInfo.getContributor().getId() + "," + (String)colVals + "'" + combinedEventsInfo.getDatedFeatureComments() + "','" + expertOpinion + "','N','" + combinedEventsInfo.getNeokinemaFaultNumber() + "')";
        try {
            ArrayList<EventSequence> eventSequenceList;
            CombinedNumEventsInfo combinedNumEventsInfo;
            CombinedSlipRateInfo combinedSlipRateInfo;
            this.dbAccess.insertUpdateOrDeleteData(sql);
            this.paleoSitePublicationDAO.addPaleoSitePublicationInfo(combinedEventsInfo.getPaleoSitePublication());
            CombinedDisplacementInfo combinedDispInfo = combinedEventsInfo.getCombinedDisplacementInfo();
            if (combinedDispInfo != null) {
                this.combinedDispInfoDB_DAO.addDisplacementInfo(infoId, systemDate, combinedDispInfo);
            }
            if ((combinedSlipRateInfo = combinedEventsInfo.getCombinedSlipRateInfo()) != null) {
                this.combinedSlipRateInfoDB_DAO.addSlipRateInfo(infoId, systemDate, combinedSlipRateInfo);
            }
            if ((combinedNumEventsInfo = combinedEventsInfo.getCombinedNumEventsInfo()) != null) {
                this.combinedNumEventsInfoDB_DAO.addNumEventsInfo(infoId, systemDate, combinedNumEventsInfo);
            }
            if ((eventSequenceList = combinedEventsInfo.getEventSequence()) != null && eventSequenceList.size() != 0) {
                this.eventSequenceDAO.addEventSequence(infoId, systemDate, eventSequenceList);
            }
            ArrayList<Reference> referenceList = combinedEventsInfo.getReferenceList();
            for (int i = 0; i < referenceList.size(); ++i) {
                int referenceId = referenceList.get(i).getReferenceId();
                sql = "insert into Combined_Events_References(Combined_Events_Id,Combined_Events_Entry_Date,Reference_Id) values (" + infoId + ",'" + systemDate + "'," + referenceId + ")";
                this.dbAccess.insertUpdateOrDeleteData(sql);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new InsertException(e.getMessage());
        }
    }

    public ArrayList<CombinedEventsInfo> getCombinedEventsInfoList(int siteId, int referenceId) {
        String condition = " where Site_Id=" + siteId + " and Is_Record_Deleted='N'";
        return this.query(condition, referenceId);
    }

    private ArrayList<CombinedEventsInfo> query(String condition, int referenceId) {
        ArrayList<CombinedEventsInfo> combinedInfoList = new ArrayList<CombinedEventsInfo>();
        String sql = "select Info_Id,Site_Id,to_char(Site_Entry_Date) as Site_Entry_Date,to_char(Entry_Date) as Entry_Date,Start_Time_Id,End_Time_Id,Contributor_Id,Dated_Feature_Comments,Is_Expert_Opinion,NeoKinema_Fault_Number,Data_Source,Fault_Section_Id from Combined_Events_Info" + condition;
        try {
            CachedRowSet rs = this.dbAccess.queryData(sql);
            while (rs.next()) {
                ArrayList<Reference> referenceList = new ArrayList<Reference>();
                sql = "select Reference_Id from Combined_Events_References where Combined_Events_Id=" + rs.getInt(INFO_ID) + " and Combined_Events_Entry_Date='" + rs.getString(ENTRY_DATE) + "'";
                CachedRowSet referenceResultSet = this.dbAccess.queryData(sql);
                boolean found = false;
                while (referenceResultSet.next()) {
                    int refId = referenceResultSet.getInt(REFERENCE_ID);
                    if (refId == referenceId) {
                        found = true;
                    }
                    referenceList.add(this.referenceDAO.getReference(refId));
                }
                referenceResultSet.close();
                if (!found) continue;
                CombinedEventsInfo combinedEventsInfo = new CombinedEventsInfo();
                combinedEventsInfo.setReferenceList(referenceList);
                combinedEventsInfo.setInfoId(rs.getInt(INFO_ID));
                combinedEventsInfo.setFaultSectionId(rs.getInt(FAULT_SECTION_ID));
                combinedEventsInfo.setEntryDate(rs.getString(ENTRY_DATE));
                combinedEventsInfo.setSiteId(rs.getInt(SITE_ID));
                combinedEventsInfo.setSiteEntryDate(rs.getString(SITE_ENTRY_DATE));
                int startTimeId = rs.getInt(START_TIME_ID);
                if (!rs.wasNull()) {
                    combinedEventsInfo.setStartTime(this.timeInstanceDAO.getTimeInstance(startTimeId));
                }
                int endTimeId = rs.getInt(END_TIME_ID);
                if (!rs.wasNull()) {
                    combinedEventsInfo.setEndTime(this.timeInstanceDAO.getTimeInstance(endTimeId));
                }
                String dataSource = rs.getString(DATA_SOURCE);
                if (!rs.wasNull()) {
                    combinedEventsInfo.setDataSource(dataSource);
                }
                combinedEventsInfo.setDatedFeatureComments(rs.getString(DATED_FEATURE_COMMENTS));
                combinedEventsInfo.setNeokinemaFaultNumber(rs.getString(NEOKINEMA_FAULT_NUMBER));
                combinedEventsInfo.setCombinedDisplacementInfo(this.combinedDispInfoDB_DAO.getDisplacementInfo(rs.getInt(INFO_ID), rs.getString(ENTRY_DATE)));
                combinedEventsInfo.setCombinedNumEventsInfo(this.combinedNumEventsInfoDB_DAO.getCombinedNumEventsInfo(rs.getInt(INFO_ID), rs.getString(ENTRY_DATE)));
                combinedEventsInfo.setCombinedSlipRateInfo(this.combinedSlipRateInfoDB_DAO.getCombinedSlipRateInfo(rs.getInt(INFO_ID), rs.getString(ENTRY_DATE)));
                combinedEventsInfo.setEventSequenceList(this.eventSequenceDAO.getSequences(rs.getInt(INFO_ID), rs.getString(ENTRY_DATE)));
                combinedEventsInfo.setContributorName(this.contributorDAO.getContributor(rs.getInt(CONTRIBUTOR_ID)).getName());
                if (rs.getString(IS_EXPERT_OPINION).equalsIgnoreCase(YES)) {
                    combinedEventsInfo.setIsExpertOpinion(true);
                } else {
                    combinedEventsInfo.setIsExpertOpinion(false);
                }
                combinedInfoList.add(combinedEventsInfo);
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new QueryException(e.getMessage());
        }
        return combinedInfoList;
    }
}

