/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.rowset.CachedRowSet;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.EstimateInstancesDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;
import org.opensha.refFaultParamDb.vo.DeformationModel;
import org.opensha.refFaultParamDb.vo.EstimateInstances;

public class DeformationModelDB_DAO {
    private static final String TABLE_NAME = "Deformation_Model";
    private static final String DEF_MODEL_ID = "Deformation_Model_Id";
    private static final String SECTION_ID = "Section_Id";
    private static final String AVE_LONG_TERM_SLIP_RATE = "Ave_Long_Term_Slip_Rate_Est";
    private static final String AVE_ASEISMIC_SLIP_EST = "Average_Aseismic_Slip_Est";
    private EstimateInstancesDB_DAO estimateInstancesDAO;
    private DB_AccessAPI dbAccessAPI;

    public DeformationModelDB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.dbAccessAPI = dbAccessAPI;
        this.estimateInstancesDAO = new EstimateInstancesDB_DAO(dbAccessAPI);
    }

    public void updateSlipRate(int deformationModelId, int faultSectionId, EstimateInstances slipRateEstimate) {
        Object colVals = "";
        if (slipRateEstimate != null) {
            int slipRateEstId = this.estimateInstancesDAO.addEstimateInstance(slipRateEstimate);
            colVals = (String)colVals + slipRateEstId;
        } else {
            colVals = (String)colVals + "NULL";
        }
        String sql = "update Deformation_Model set Ave_Long_Term_Slip_Rate_Est=" + (String)colVals + " where Deformation_Model_Id=" + deformationModelId + " and Section_Id=" + faultSectionId;
        try {
            this.dbAccessAPI.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
    }

    public void updateAseimsicSlipFactor(int deformationModelId, int faultSectionId, EstimateInstances aseismicSlipFactorEstimate) {
        Object colVals = "";
        if (aseismicSlipFactorEstimate != null) {
            int slipRateEstId = this.estimateInstancesDAO.addEstimateInstance(aseismicSlipFactorEstimate);
            colVals = (String)colVals + slipRateEstId;
        } else {
            colVals = (String)colVals + "NULL";
        }
        String sql = "update Deformation_Model set Average_Aseismic_Slip_Est=" + (String)colVals + " where Deformation_Model_Id=" + deformationModelId + " and Section_Id=" + faultSectionId;
        try {
            this.dbAccessAPI.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
    }

    public EstimateInstances getSlipRateEstimate(int deformationModelId, int faultSectionId) {
        String sql = "select Ave_Long_Term_Slip_Rate_Est from Deformation_Model where Deformation_Model_Id=" + deformationModelId + " and Section_Id=" + faultSectionId;
        EstimateInstances slipRateEst = null;
        try {
            CachedRowSet rs = this.dbAccessAPI.queryData(sql);
            while (rs.next()) {
                int slipRateEstId = rs.getInt(AVE_LONG_TERM_SLIP_RATE);
                if (rs.wasNull()) continue;
                slipRateEst = this.estimateInstancesDAO.getEstimateInstance(slipRateEstId);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return slipRateEst;
    }

    public EstimateInstances getAseismicSlipEstimate(int deformationModelId, int faultSectionId) {
        String sql = "select Average_Aseismic_Slip_Est from Deformation_Model where Deformation_Model_Id=" + deformationModelId + " and Section_Id=" + faultSectionId;
        EstimateInstances aseismicSlipEst = null;
        try {
            CachedRowSet rs = this.dbAccessAPI.queryData(sql);
            while (rs.next()) {
                int aseimicFactorEstId = rs.getInt(AVE_ASEISMIC_SLIP_EST);
                if (rs.wasNull()) continue;
                aseismicSlipEst = this.estimateInstancesDAO.getEstimateInstance(aseimicFactorEstId);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return aseismicSlipEst;
    }

    public ArrayList<Integer> getFaultSectionIdsForDeformationModel(int deformationModelId) {
        ArrayList<Integer> faultSectionIdList = new ArrayList<Integer>();
        String sql = "select Section_Id from Deformation_Model where Deformation_Model_Id=" + deformationModelId;
        try {
            CachedRowSet rs = this.dbAccessAPI.queryData(sql);
            while (rs.next()) {
                faultSectionIdList.add(rs.getInt(SECTION_ID));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return faultSectionIdList;
    }

    public DeformationModel getDeformationModel(int deformationModelId) {
        String sql = "select Deformation_Model_Id,Section_Id,Ave_Long_Term_Slip_Rate_Est,Average_Aseismic_Slip_Est from Deformation_Model where Deformation_Model_Id=" + deformationModelId;
        DeformationModel deformationModel = new DeformationModel();
        deformationModel.setDeformationModelId(deformationModelId);
        try {
            CachedRowSet rs = this.dbAccessAPI.queryData(sql);
            while (rs.next()) {
                int faultSectionId = rs.getInt(SECTION_ID);
                deformationModel.addFaultSection(faultSectionId);
                int slipRateEstId = rs.getInt(AVE_LONG_TERM_SLIP_RATE);
                if (!rs.wasNull()) {
                    deformationModel.setSlipRateEstimate(faultSectionId, this.estimateInstancesDAO.getEstimateInstance(slipRateEstId));
                }
                deformationModel.setAseismicSlipFactorEstimate(faultSectionId, this.estimateInstancesDAO.getEstimateInstance(rs.getInt(AVE_ASEISMIC_SLIP_EST)));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return deformationModel;
    }

    public int removeSectionFromAllModels(int faultSectionId) {
        String sql = "delete from Deformation_Model where Section_Id=" + faultSectionId;
        try {
            return this.dbAccessAPI.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
    }

    protected void removeModel(int deformationModelId) {
        String sql = "delete from Deformation_Model where Deformation_Model_Id=" + deformationModelId;
        try {
            this.dbAccessAPI.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
    }

    public static void main(String[] args) {
        DB_AccessAPI db = DB_ConnectionPool.getDirectLatestReadWriteConnection();
        DeformationModelDB_DAO def = new DeformationModelDB_DAO(db);
        def.removeModel(82);
        def.removeModel(83);
        def.removeModel(84);
        def.removeModel(85);
        def.removeModel(86);
        def.removeModel(87);
        try {
            db.destroy();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

