/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.sql.rowset.CachedRowSet;
import org.opensha.commons.data.estimate.NormalEstimate;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.PrintAndExitUncaughtExceptionHandler;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DeformationModelDB_DAO;
import org.opensha.refFaultParamDb.dao.db.DeformationModelSummaryDB_DAO;
import org.opensha.refFaultParamDb.dao.db.PrefFaultSectionDataDB_DAO;
import org.opensha.refFaultParamDb.dao.db.ServerDB_Access;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.vo.DeformationModelSummary;
import org.opensha.refFaultParamDb.vo.EstimateInstances;
import org.opensha.refFaultParamDb.vo.FaultSectionData;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;

public class DeformationModelPrefDataDB_DAO {
    private static final String TABLE_NAME = "Pref_Deformation_Model_Data";
    private static final String DEFORMATION_MODEL_ID = "Deformation_Model_Id";
    private static final String SECTION_ID = "Section_Id";
    private static final String PREF_LONG_TERM_SLIP_RATE = "Pref_Long_Term_Slip_Rate";
    private static final String SLIP_STD_DEV = "Slip_Std_Dev";
    private static final String PREF_ASEISMIC_SLIP = "Pref_Aseismic_Slip";
    private HashMap<Integer, Double> slipRateMap;
    private HashMap<Integer, Double> aseismicSlipMap;
    private HashMap<Integer, Double> stdDevMap;
    private int selectedDefModelId = -1;
    private DB_AccessAPI dbAccess;
    private PrefFaultSectionDataDB_DAO prefFaultSectionDAO;
    private DeformationModelDB_DAO deformationModelDB_DAO;
    private static ArrayList<Integer> faultSectionIdList;

    public DeformationModelPrefDataDB_DAO(DB_AccessAPI dbAccess) {
        this.setDB_Connection(dbAccess);
    }

    public void setDB_Connection(DB_AccessAPI dbAccess) {
        this.dbAccess = dbAccess;
        this.prefFaultSectionDAO = new PrefFaultSectionDataDB_DAO(dbAccess);
        this.deformationModelDB_DAO = new DeformationModelDB_DAO(dbAccess);
    }

    public void rePopulatePrefDataTable() {
        this.removeAll();
        DeformationModelSummaryDB_DAO defModelSumDAO = new DeformationModelSummaryDB_DAO(this.dbAccess);
        ArrayList<DeformationModelSummary> deformationModelList = defModelSumDAO.getAllDeformationModels();
        for (int i = 0; i < deformationModelList.size(); ++i) {
            DeformationModelSummary defModelSummary = deformationModelList.get(i);
            int deformationModelId = defModelSummary.getDeformationModelId();
            ArrayList<Integer> faultSectionIdList = this.deformationModelDB_DAO.getFaultSectionIdsForDeformationModel(deformationModelId);
            for (int j = 0; j < faultSectionIdList.size(); ++j) {
                int faultSectionId = faultSectionIdList.get(j);
                double aseismicSlipFactor = FaultSectionData.getPrefForEstimate(this.deformationModelDB_DAO.getAseismicSlipEstimate(deformationModelId, faultSectionId));
                EstimateInstances estimateInstance = this.deformationModelDB_DAO.getSlipRateEstimate(deformationModelId, faultSectionId);
                double slipRate = FaultSectionData.getPrefForEstimate(estimateInstance);
                double slipRateStdDev = Double.NaN;
                if (!Double.isNaN(slipRate) && estimateInstance.getEstimate() instanceof NormalEstimate) {
                    slipRateStdDev = ((NormalEstimate)estimateInstance.getEstimate()).getStdDev();
                }
                this.addToTable(deformationModelId, faultSectionId, aseismicSlipFactor, slipRate, slipRateStdDev);
            }
        }
    }

    private void addToTable(int deformationModelId, int faultSectionId, double aseismicSlipFactor, double slipRate, double slipRateStdDev) {
        Object columnNames = "";
        Object colVals = "";
        if (!Double.isNaN(slipRate)) {
            columnNames = (String)columnNames + "Pref_Long_Term_Slip_Rate,";
            colVals = (String)colVals + slipRate + ",";
        }
        if (!Double.isNaN(slipRateStdDev)) {
            columnNames = (String)columnNames + "Slip_Std_Dev,";
            colVals = (String)colVals + slipRateStdDev + ",";
        }
        String sql = "insert into Pref_Deformation_Model_Data (Deformation_Model_Id,Section_Id," + (String)columnNames + "Pref_Aseismic_Slip) values (" + deformationModelId + "," + faultSectionId + "," + (String)colVals + aseismicSlipFactor + ")";
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    public ArrayList<Integer> getFaultSectionIdsForDeformationModel(int deformationModelId) {
        if (this.selectedDefModelId != deformationModelId) {
            this.cache(deformationModelId);
        }
        return faultSectionIdList;
    }

    public FaultSectionPrefData getFaultSectionPrefData(int deformationModelId, int faultSectionId) {
        FaultSectionPrefData faultSectionPrefData = this.prefFaultSectionDAO.getFaultSectionPrefData(faultSectionId).clone();
        faultSectionPrefData.setAseismicSlipFactor(this.getAseismicSlipFactor(deformationModelId, faultSectionId));
        faultSectionPrefData.setAveSlipRate(this.getSlipRate(deformationModelId, faultSectionId));
        faultSectionPrefData.setSlipRateStdDev(this.getSlipStdDev(deformationModelId, faultSectionId));
        return faultSectionPrefData;
    }

    public double getSlipRate(int deformationModelId, int faultSectionId) {
        Double slipRate;
        if (this.selectedDefModelId != deformationModelId) {
            this.cache(deformationModelId);
        }
        if ((slipRate = this.slipRateMap.get(faultSectionId)) == null) {
            return Double.NaN;
        }
        return slipRate;
    }

    public double getSlipStdDev(int deformationModelId, int faultSectionId) {
        Double stdDev;
        if (this.selectedDefModelId != deformationModelId) {
            this.cache(deformationModelId);
        }
        if ((stdDev = this.stdDevMap.get(faultSectionId)) == null) {
            return Double.NaN;
        }
        return stdDev;
    }

    public double getAseismicSlipFactor(int deformationModelId, int faultSectionId) {
        Double aseismicSlip;
        if (this.selectedDefModelId != deformationModelId) {
            this.cache(deformationModelId);
        }
        if ((aseismicSlip = this.aseismicSlipMap.get(faultSectionId)) == null) {
            return Double.NaN;
        }
        return aseismicSlip;
    }

    public void cacheEverything(int defModelId) {
        this.prefFaultSectionDAO.getAllFaultSectionPrefData();
    }

    private void cache(int defModelId) {
        this.slipRateMap = new HashMap();
        this.aseismicSlipMap = new HashMap();
        this.stdDevMap = new HashMap();
        faultSectionIdList = new ArrayList();
        String sql = "select Section_Id, (Pref_Aseismic_Slip+0) Pref_Aseismic_Slip, (Slip_Std_Dev+0) Slip_Std_Dev, (Pref_Long_Term_Slip_Rate+0) Pref_Long_Term_Slip_Rate from Pref_Deformation_Model_Data where Deformation_Model_Id=" + defModelId;
        double aseismicSlipFactor = Double.NaN;
        double slip = Double.NaN;
        double stdDev = Double.NaN;
        try {
            CachedRowSet rs = this.dbAccess.queryData(sql);
            while (rs.next()) {
                aseismicSlipFactor = rs.getFloat(PREF_ASEISMIC_SLIP);
                if (rs.wasNull()) {
                    aseismicSlipFactor = Double.NaN;
                }
                slip = rs.getFloat(PREF_LONG_TERM_SLIP_RATE);
                if (rs.wasNull()) {
                    slip = Double.NaN;
                }
                stdDev = rs.getFloat(SLIP_STD_DEV);
                if (rs.wasNull()) {
                    stdDev = Double.NaN;
                }
                Integer sectionId = rs.getInt(SECTION_ID);
                faultSectionIdList.add(sectionId);
                this.slipRateMap.put(sectionId, slip);
                this.aseismicSlipMap.put(sectionId, aseismicSlipFactor);
                this.stdDevMap.put(sectionId, stdDev);
            }
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        this.selectedDefModelId = defModelId;
    }

    private void removeAll() {
        String sql = "delete from Pref_Deformation_Model_Data";
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
    }

    public static void main(String[] args) {
        try {
            String pass;
            String user;
            Thread.setDefaultUncaughtExceptionHandler(new PrintAndExitUncaughtExceptionHandler());
            ServerDB_Access dbAccessAPI = new ServerDB_Access(ServerDB_Access.SERVLET_URL_DB3);
            Preconditions.checkArgument((args.length == 2 ? 1 : 0) != 0, (Object)"Must have 2 arguments!");
            if (args[0].equals("--file")) {
                if (!new File(args[1]).exists()) {
                    throw new FileNotFoundException("Password file not found: " + args[1]);
                }
                String[] up = FileUtils.loadFile(args[1]).get(0).trim().split(":");
                Preconditions.checkState((up.length == 2 ? 1 : 0) != 0, (Object)"user/pass file has incorrect format (should be 'user:pass'");
                user = up[0];
                pass = up[1];
            } else {
                user = args[0];
                pass = args[1];
            }
            SessionInfo.setUserName(user);
            SessionInfo.setPassword(pass);
            SessionInfo.setContributorInfo();
            DeformationModelPrefDataDB_DAO defModelPrefDataDB_DAO = new DeformationModelPrefDataDB_DAO(dbAccessAPI);
            defModelPrefDataDB_DAO.rePopulatePrefDataTable();
            System.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

