/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.rowset.CachedRowSet;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;
import org.opensha.refFaultParamDb.data.ExactTime;

public class ExactTimeDB_DAO {
    private static final String TABLE_NAME = "Exact_Time_Info";
    private static final String TIME_INSTANCE_ID = "Time_Instance_Id";
    private static final String YEAR = "Year";
    private static final String MONTH = "Month";
    private static final String DAY = "Day";
    private static final String HOUR = "Hour";
    private static final String MINUTE = "Minute";
    private static final String SECOND = "Second";
    private static final String ERA = "Era";
    private static final String IS_NOW = "Is_Now";
    private static final String YES_IS_NOW = "Y";
    private static final String NOT_IS_NOW = "N";
    private DB_AccessAPI dbAccessAPI;

    public ExactTimeDB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public ExactTimeDB_DAO() {
    }

    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.dbAccessAPI = dbAccessAPI;
    }

    public void addExactTime(int timeInstanceId, ExactTime exactTime) throws InsertException {
        String isNow = NOT_IS_NOW;
        if (exactTime.getIsNow()) {
            isNow = YES_IS_NOW;
        }
        String sql = "insert into Exact_Time_Info(Time_Instance_Id,Year,Month,Day,Hour,Minute,Second,Era,Is_Now) values (" + timeInstanceId + "," + exactTime.getYear() + "," + exactTime.getMonth() + "," + exactTime.getDay() + "," + exactTime.getHour() + "," + exactTime.getMinute() + "," + exactTime.getSecond() + ",'" + exactTime.getEra() + "','" + isNow + "')";
        try {
            this.dbAccessAPI.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    public ExactTime getExactTime(int timeInstanceId) throws QueryException {
        ExactTime exactTime = null;
        String condition = " where Time_Instance_Id=" + timeInstanceId;
        ArrayList<ExactTime> exactTimeList = this.query(condition);
        if (exactTimeList.size() > 0) {
            exactTime = exactTimeList.get(0);
        }
        return exactTime;
    }

    public boolean removeTime(int timeInstanceId) throws UpdateException {
        String sql = "delete from Exact_Time_Info  where Time_Instance_Id=" + timeInstanceId;
        try {
            int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            if (numRows == 1) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
        return false;
    }

    private ArrayList<ExactTime> query(String condition) throws QueryException {
        ArrayList<ExactTime> exactTimeList = new ArrayList<ExactTime>();
        String sql = "select Time_Instance_Id,Year,Month,Day,Hour,Minute,Second,Era,Is_Now from Exact_Time_Info " + condition;
        try {
            CachedRowSet rs = this.dbAccessAPI.queryData(sql);
            while (rs.next()) {
                boolean isNow = false;
                if (rs.getString(IS_NOW).equalsIgnoreCase(YES_IS_NOW)) {
                    isNow = true;
                }
                ExactTime exactTime = new ExactTime(rs.getInt(YEAR), rs.getInt(MONTH), rs.getInt(DAY), rs.getInt(HOUR), rs.getInt(MINUTE), rs.getInt(SECOND), rs.getString(ERA), isNow);
                exactTimeList.add(exactTime);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return exactTimeList;
    }
}

