/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.rowset.CachedRowSet;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;

public class FaultModelDB_DAO {
    private static final String TABLE_NAME = "Fault_Model";
    private static final String FAULT_MODEL_ID = "Fault_Model_Id";
    private static final String SECTION_ID = "Section_Id";
    private DB_AccessAPI dbAccessAPI;

    public FaultModelDB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.dbAccessAPI = dbAccessAPI;
    }

    public void replaceFaultSectionIDs(int faultModelId, ArrayList<Integer> faultSectionsIdList) {
        block5: {
            try {
                if (faultSectionsIdList != null && faultSectionsIdList.size() > 0) {
                    ArrayList<String> sqls = new ArrayList<String>();
                    sqls.add(this.getRemoveSQL(faultModelId));
                    Object sql = "INSERT ALL";
                    for (int i = 0; i < faultSectionsIdList.size(); ++i) {
                        sql = (String)sql + "\n INTO Fault_Model (Fault_Model_Id,Section_Id) VALUES ";
                        sql = (String)sql + "(" + faultModelId + "," + String.valueOf(faultSectionsIdList.get(i)) + ")";
                    }
                    sql = (String)sql + "\nselect * from dual";
                    sqls.add((String)sql);
                    int[] ret = this.dbAccessAPI.insertUpdateOrDeleteBatch(sqls, true);
                    if (ret == null) {
                        throw new RuntimeException("Replace failed...unknown reason.");
                    }
                    break block5;
                }
                throw new RuntimeException("Can't replace...no fault sections!");
            }
            catch (SQLException e) {
                throw new InsertException(e.getMessage());
            }
        }
    }

    public ArrayList<Integer> getFaultSectionIdList(int faultModelId) {
        String sql = "select Section_Id from Fault_Model where Fault_Model_Id=" + faultModelId;
        ArrayList<Integer> faultSectionIdList = new ArrayList<Integer>();
        try {
            CachedRowSet rs = this.dbAccessAPI.queryData(sql);
            while (rs.next()) {
                faultSectionIdList.add(rs.getInt(SECTION_ID));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return faultSectionIdList;
    }

    public int removeSectionFromAllModels(int faultSectionId) {
        String sql = "delete from Fault_Model where Section_Id=" + faultSectionId;
        try {
            return this.dbAccessAPI.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
    }

    private String getRemoveSQL(int faultModelId) {
        return "delete from Fault_Model where Fault_Model_Id=" + faultModelId;
    }

    private void removeModel(int faultModelId) {
        String sql = this.getRemoveSQL(faultModelId);
        try {
            this.dbAccessAPI.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
    }

    public static void main(String[] args) {
        DB_AccessAPI ucerf2read = DB_ConnectionPool.getDB2ReadOnlyConn();
        FaultModelDB_DAO fm_2_read = new FaultModelDB_DAO(ucerf2read);
        FaultModelDB_DAO fm_3_write = new FaultModelDB_DAO(DB_ConnectionPool.getDirectLatestReadWriteConnection());
        ArrayList<Integer> ids = fm_2_read.getFaultSectionIdList(41);
        fm_3_write.replaceFaultSectionIDs(81, ids);
        System.exit(0);
    }
}

