/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.rowset.CachedRowSet;
import oracle.spatial.geometry.JGeometry;
import org.opensha.commons.geo.Location;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.SpatialQueryResult;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.vo.FaultSection2002;
import org.opensha.sha.faultSurface.FaultTrace;

public class FaultSection2002DB_DAO {
    private static final String TABLE_NAME = "Fault_Section_Ght_ca";
    private static final String FAULT_ID = "Fault_Id";
    private static final String SECTION_NAME = "Section_Name";
    private static final String ENTRY_DATE = "Entry_Date";
    private static final String FAULT_MODEL = "Fault_Model";
    private static final String COMMENTS = "Comments";
    private static final String AVE_LT_SLIP_RATE_EST = "Ave_Lt_Slip_Rate_Est";
    private static final String AVE_DIP_EST = "Ave_Dip_Est";
    private static final String AVE_UPPER_SD_EST = "Ave_Upper_Sd_Est";
    private static final String AVE_LOWER_SD_EST = "Ave_Lower_Sd_Est";
    private static final String FAULT_GEOM = "Fault_Geom";
    private static final String SECTION_ID = "Section_Id";
    private static final String NSHM02_ID = "NSHM02_ID";
    private DB_AccessAPI dbAccessAPI;

    public FaultSection2002DB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.dbAccessAPI = dbAccessAPI;
    }

    public ArrayList<FaultSection2002> getAllFaultSections() {
        String condition = " order by Section_Name";
        return this.query(condition);
    }

    private ArrayList<FaultSection2002> query(String condition) {
        ArrayList<FaultSection2002> faultSectionList = new ArrayList<FaultSection2002>();
        String sqlWithSpatialColumnName = "select Fault_Id,Section_Name,to_char(Entry_Date) as Entry_Date,Fault_Model,Comments,Ave_Lt_Slip_Rate_Est,Fault_Geom,Ave_Dip_Est,Ave_Upper_Sd_Est,Ave_Lower_Sd_Est,Section_Id,NSHM02_ID from Fault_Section_Ght_ca" + condition;
        String sqlWithNoSpatialColumnName = "select Fault_Id,Section_Name,to_char(Entry_Date) as Entry_Date,Fault_Model,Comments,Ave_Lt_Slip_Rate_Est,Ave_Dip_Est,Ave_Upper_Sd_Est,Ave_Lower_Sd_Est,Section_Id,NSHM02_ID from Fault_Section_Ght_ca" + condition;
        try {
            ArrayList<String> spatialColumnList = new ArrayList<String>();
            spatialColumnList.add(FAULT_GEOM);
            SpatialQueryResult spatialQueryResult = this.dbAccessAPI.queryData(sqlWithSpatialColumnName, sqlWithNoSpatialColumnName, spatialColumnList);
            CachedRowSet rs = spatialQueryResult.getCachedRowSet();
            int i = 0;
            while (rs.next()) {
                FaultSection2002 faultSection = new FaultSection2002();
                faultSection.setFaultId(rs.getString(FAULT_ID));
                faultSection.setSectionName(rs.getString(SECTION_NAME));
                faultSection.setEntryDate(rs.getString(ENTRY_DATE));
                faultSection.setFaultModel(rs.getString(FAULT_MODEL));
                faultSection.setComments(rs.getString(COMMENTS));
                faultSection.setAveLongTermSlipRate(rs.getFloat(AVE_LT_SLIP_RATE_EST));
                faultSection.setAveDip(rs.getFloat(AVE_DIP_EST));
                faultSection.setAveUpperSeisDepth(rs.getFloat(AVE_UPPER_SD_EST));
                faultSection.setAveLowerSeisDepth(rs.getFloat(AVE_LOWER_SD_EST));
                faultSection.setSectionId(rs.getString(SECTION_ID));
                faultSection.setNshm02Id(rs.getString(NSHM02_ID));
                FaultTrace faultTrace = new FaultTrace(rs.getString(SECTION_NAME));
                JGeometry faultTraceGeom = spatialQueryResult.getGeometryObjectsList(i++).get(0);
                int numPoints = faultTraceGeom.getNumPoints();
                double[] ordinatesArray = faultTraceGeom.getOrdinatesArray();
                for (int j = 0; j < numPoints; ++j) {
                    faultTrace.add(new Location(ordinatesArray[2 * j + 1], ordinatesArray[2 * j]));
                }
                faultSection.setFaultTrace(faultTrace);
                faultSectionList.add(faultSection);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new QueryException(e.getMessage());
        }
        return faultSectionList;
    }
}

