/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.rowset.CachedRowSet;
import oracle.spatial.geometry.JGeometry;
import org.opensha.commons.geo.Location;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.SpatialQueryResult;
import org.opensha.refFaultParamDb.dao.db.SpatialUtils;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;
import org.opensha.refFaultParamDb.vo.FaultSectionConnection;
import org.opensha.refFaultParamDb.vo.FaultSectionConnectionList;

public class FaultSectionConnectionsDB_DAO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TABLE_NAME = "FAULT_SECTION_CONNECTIONS";
    private static final String ID_1 = "SECTION_ID_1";
    private static final String ID_2 = "SECTION_ID_2";
    private static final String LOCATION_1 = "LOCATION_1";
    private static final String LOCATION_2 = "LOCATION_2";
    private DB_AccessAPI dbAccessAPI;

    public FaultSectionConnectionsDB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.dbAccessAPI = dbAccessAPI;
    }

    public void addConnection(FaultSectionConnection connection) throws InsertException {
        JGeometry geom1 = SpatialUtils.getSinglePointGeometry(connection.getLoc1());
        JGeometry geom2 = SpatialUtils.getSinglePointGeometry(connection.getLoc2());
        ArrayList geomLists = Lists.newArrayList((Object[])new JGeometry[]{geom1, geom2});
        String sql = "insert into FAULT_SECTION_CONNECTIONS(SECTION_ID_1,SECTION_ID_2,LOCATION_1,LOCATION_2)  values (" + connection.getId1() + "," + connection.getId2() + ",?,?)";
        try {
            this.dbAccessAPI.insertUpdateOrDeleteData(sql, geomLists);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    public boolean removeConnection(int id1, int id2) throws UpdateException {
        String sql = "delete from FAULT_SECTION_CONNECTIONS  where (SECTION_ID_1=" + id1 + " AND SECTION_ID_2=" + id2 + ") OR (SECTION_ID_1=" + id2 + " AND SECTION_ID_2=" + id1 + ")";
        try {
            int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            return numRows >= 1;
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
    }

    public int removeAllConnections(int id) throws UpdateException {
        String sql = "delete from FAULT_SECTION_CONNECTIONS  where SECTION_ID_1=" + id + " OR SECTION_ID_2=" + id;
        try {
            int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            return numRows;
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
    }

    public FaultSectionConnectionList getAllConnections() throws QueryException {
        return this.query(" ");
    }

    private FaultSectionConnectionList query(String condition) throws QueryException {
        FaultSectionConnectionList conns = new FaultSectionConnectionList();
        String sqlWithSpatialColumnNames = "select SECTION_ID_1,SECTION_ID_2,LOCATION_1,LOCATION_2 from FAULT_SECTION_CONNECTIONS" + condition;
        String sqlWithNoSpatialColumnNames = "select SECTION_ID_1,SECTION_ID_2 from FAULT_SECTION_CONNECTIONS" + condition;
        ArrayList<String> spatialColumnNames = new ArrayList<String>();
        spatialColumnNames.add(LOCATION_1);
        spatialColumnNames.add(LOCATION_2);
        try {
            SpatialQueryResult spatialQueryResult = this.dbAccessAPI.queryData(sqlWithSpatialColumnNames, sqlWithNoSpatialColumnNames, spatialColumnNames);
            CachedRowSet rs = spatialQueryResult.getCachedRowSet();
            int i = 0;
            while (rs.next()) {
                ArrayList<JGeometry> geometries;
                int id1 = rs.getInt(ID_1);
                int id2 = rs.getInt(ID_2);
                Preconditions.checkState(((geometries = spatialQueryResult.getGeometryObjectsList(i++)).size() == 2 ? 1 : 0) != 0);
                Location loc1 = SpatialUtils.loadSinglePointGeometry(geometries.get(0), 0.0);
                Location loc2 = SpatialUtils.loadSinglePointGeometry(geometries.get(1), 0.0);
                conns.add(new FaultSectionConnection(id1, id2, loc1, loc2));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return conns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        DB_AccessAPI db = null;
        try {
            db = DB_ConnectionPool.getDB3ReadOnlyConn();
            FaultSectionConnectionsDB_DAO connsDB = new FaultSectionConnectionsDB_DAO(db);
            for (FaultSectionConnection conn : connsDB.getAllConnections()) {
                System.out.println(conn);
            }
        }
        catch (QueryException e) {
            e.printStackTrace();
        }
        finally {
            if (db != null) {
                try {
                    db.destroy();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        System.exit(0);
    }
}

