/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import javax.sql.rowset.CachedRowSet;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.data.estimate.PDF_Estimate;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.refFaultParamDb.dao.EstimateDAO_API;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.XY_EstimateDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;

public class PDF_EstimateDB_DAO
implements EstimateDAO_API {
    private static final String TABLE_NAME = "PDF_Est";
    private static final String EST_ID = "Est_Id";
    private static final String MIN_X = "Min_X";
    private static final String DELTA_X = "Delta_X";
    private static final String NUM = "Num";
    public static final String EST_TYPE_NAME = "PDF_Estimate";
    private static final String ERR_MSG = "This class just deals with PDF Estimates";
    private XY_EstimateDB_DAO xyEstimateDB_DAO = new XY_EstimateDB_DAO();
    private DB_AccessAPI dbAccessAPI;

    public PDF_EstimateDB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public PDF_EstimateDB_DAO() {
    }

    @Override
    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.dbAccessAPI = dbAccessAPI;
        this.xyEstimateDB_DAO.setDB_Connection(dbAccessAPI);
    }

    @Override
    public void addEstimate(int estimateInstanceId, Estimate estimate) throws InsertException {
        if (!(estimate instanceof PDF_Estimate)) {
            throw new InsertException(ERR_MSG);
        }
        PDF_Estimate pdfEstimate = (PDF_Estimate)estimate;
        EvenlyDiscretizedFunc evenlyDiscFunc = (EvenlyDiscretizedFunc)pdfEstimate.getFunc();
        String sql = "insert into PDF_Est(Est_Id,Min_X,Delta_X,Num) values (" + estimateInstanceId + "," + evenlyDiscFunc.getMinX() + "," + evenlyDiscFunc.getDelta() + "," + evenlyDiscFunc.size() + ")";
        try {
            this.dbAccessAPI.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException sqlException) {
            throw new InsertException(sqlException.getMessage());
        }
        this.xyEstimateDB_DAO.addEstimate(estimateInstanceId, pdfEstimate.getValues());
    }

    @Override
    public Estimate getEstimate(int estimateInstanceId) throws QueryException {
        String sql = "select Est_Id,(Min_X+0) Min_X,(Delta_X+0) Delta_X,Num from PDF_Est where Est_Id=" + estimateInstanceId;
        EvenlyDiscretizedFunc evenlyDiscFunc = null;
        try {
            CachedRowSet rs = this.dbAccessAPI.queryData(sql);
            while (rs.next()) {
                evenlyDiscFunc = new EvenlyDiscretizedFunc((double)rs.getFloat(MIN_X), rs.getInt(NUM), rs.getFloat(DELTA_X));
            }
        }
        catch (SQLException ex) {
            throw new QueryException(ex.getMessage());
        }
        this.xyEstimateDB_DAO.getEstimate(estimateInstanceId, evenlyDiscFunc);
        PDF_Estimate estimate = new PDF_Estimate(evenlyDiscFunc, false);
        return estimate;
    }

    @Override
    public boolean removeEstimate(int estimateInstanceId) throws UpdateException {
        boolean isRemovedFromXY_Est = this.xyEstimateDB_DAO.removeEstimate(estimateInstanceId);
        String sql = "delete from PDF_Est where Est_Id=" + estimateInstanceId;
        try {
            int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            if (numRows == 1 && isRemovedFromXY_Est) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
        return false;
    }

    @Override
    public String getEstimateTypeName() {
        return EST_TYPE_NAME;
    }
}

