/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.rowset.CachedRowSet;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;
import org.opensha.refFaultParamDb.vo.Reference;

public class ReferenceDB_DAO {
    private static final String SEQUENCE_NAME = "Reference_Sequence";
    private static final String TABLE_NAME = "Reference";
    private static final String REFERENCE_ID = "Reference_Id";
    private static final String REF_YEAR = "Ref_Year";
    private static final String REF_AUTH = "Ref_Auth";
    private static final String FULL_BIBLIOGRAPHIC_REFERENCE = "Full_Bibliographic_Reference";
    private static final String QFAULT_REFERENCE_ID = "QFault_Reference_Id";
    private DB_AccessAPI dbAccessAPI;
    private static ArrayList<Reference> referenceList;

    public ReferenceDB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.dbAccessAPI = dbAccessAPI;
    }

    public int addReference(Reference reference) throws InsertException {
        int referenceId = -1;
        try {
            referenceId = this.dbAccessAPI.getNextSequenceNumber(SEQUENCE_NAME);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        String sql = "insert into Reference(Reference_Id,Ref_Auth,Ref_Year,Full_Bibliographic_Reference) values (" + referenceId + ",'" + reference.getRefAuth() + "','" + reference.getRefYear() + "','" + reference.getFullBiblioReference() + "')";
        try {
            this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            if (referenceList != null) {
                referenceList.add(reference);
            }
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        return referenceId;
    }

    public boolean updateReference(int referenceId, Reference reference) throws UpdateException {
        String sql = "update Reference set Ref_Auth= '" + reference.getRefAuth() + "',Ref_Year=" + reference.getRefYear() + ",Full_Bibliographic_Reference='" + reference.getFullBiblioReference() + "' where Reference_Id=" + referenceId;
        try {
            int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            if (numRows == 1) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
        return false;
    }

    public Reference getReference(int referenceId) throws QueryException {
        Reference reference = null;
        String condition = " where Reference_Id=" + referenceId;
        ArrayList<Reference> referenceList = this.query(condition);
        if (referenceList.size() > 0) {
            reference = referenceList.get(0);
        }
        return reference;
    }

    public Reference getReference(String author, String year) throws QueryException {
        Reference reference = null;
        String condition = " where Ref_Auth='" + author + "' and Ref_Year='" + year + "'";
        ArrayList<Reference> referenceList = this.query(condition);
        if (referenceList.size() > 0) {
            reference = referenceList.get(0);
        }
        return reference;
    }

    public Reference getReferenceByQfaultId(int qfaultReferenceId) throws QueryException {
        Reference reference = null;
        String condition = " where QFault_Reference_Id=" + qfaultReferenceId;
        ArrayList<Reference> referenceList = this.query(condition);
        if (referenceList.size() > 0) {
            reference = referenceList.get(0);
        }
        return reference;
    }

    public boolean removeReference(int referenceId) throws UpdateException {
        String sql = "delete from Reference  where Reference_Id=" + referenceId;
        try {
            int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            if (numRows == 1) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
        return false;
    }

    public ArrayList<Reference> getAllReferences() throws QueryException {
        return this.query(" ");
    }

    public ArrayList<Reference> getAllReferencesSummary() throws QueryException {
        if (referenceList != null) {
            return referenceList;
        }
        referenceList = new ArrayList();
        String sql = "select Reference_Id,Ref_Year,Ref_Auth from Reference order by Ref_Auth";
        try {
            CachedRowSet rs = this.dbAccessAPI.queryData(sql);
            while (rs.next()) {
                Reference referenceSummary = new Reference();
                referenceSummary.setRefAuth(rs.getString(REF_AUTH));
                referenceSummary.setReferenceId(rs.getInt(REFERENCE_ID));
                referenceSummary.setRefYear(rs.getString(REF_YEAR));
                referenceList.add(referenceSummary);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return referenceList;
    }

    private ArrayList<Reference> query(String condition) throws QueryException {
        ArrayList<Reference> referenceList = new ArrayList<Reference>();
        String sql = "select Reference_Id,Ref_Year,Ref_Auth,QFault_Reference_Id,Full_Bibliographic_Reference from Reference " + condition + " order by Ref_Auth";
        try {
            CachedRowSet rs = this.dbAccessAPI.queryData(sql);
            while (rs.next()) {
                Reference reference = new Reference(rs.getInt(REFERENCE_ID), rs.getString(REF_AUTH), rs.getString(REF_YEAR), rs.getString(FULL_BIBLIOGRAPHIC_REFERENCE));
                int qFaultRefId = rs.getInt(QFAULT_REFERENCE_ID);
                if (!rs.wasNull()) {
                    reference.setQfaultReferenceId(qFaultRefId);
                }
                referenceList.add(reference);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return referenceList;
    }
}

