/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.rowset.CachedRowSet;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.ExactTimeDB_DAO;
import org.opensha.refFaultParamDb.dao.db.ReferenceDB_DAO;
import org.opensha.refFaultParamDb.dao.db.TimeEstimateDB_DAO;
import org.opensha.refFaultParamDb.dao.db.TimeTypeDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;
import org.opensha.refFaultParamDb.data.ExactTime;
import org.opensha.refFaultParamDb.data.TimeAPI;
import org.opensha.refFaultParamDb.data.TimeEstimate;
import org.opensha.refFaultParamDb.vo.Reference;

public class TimeInstanceDB_DAO {
    private static final String TABLE_NAME = "Time_Instances";
    private static final String REFERENCES_TABLE_NAME = "Time_Instances_References";
    private static final String SEQUENCE_NAME = "Time_Instances_Sequence";
    private static final String TIME_ID = "Time_Id";
    private static final String TIME_TYPE_ID = "Time_Type_Id";
    private static final String COMMENTS = "Comments";
    private static final String REFERENCE_ID = "Reference_Id";
    private DB_AccessAPI dbAccessAPI;

    public TimeInstanceDB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.dbAccessAPI = dbAccessAPI;
    }

    public int addTimeInstance(TimeAPI timeInstance) throws InsertException {
        String timeType = timeInstance instanceof ExactTime ? "Exact Time" : "Time Estimate";
        TimeTypeDB_DAO timeTypeDB_DAO = new TimeTypeDB_DAO(this.dbAccessAPI);
        int timeTypeId = timeTypeDB_DAO.getTimeTypeId(timeType);
        int timeInstanceId = -1;
        try {
            timeInstanceId = this.dbAccessAPI.getNextSequenceNumber(SEQUENCE_NAME);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        String sql = "insert into Time_Instances(Time_Id,Time_Type_Id,Comments) values(" + timeInstanceId + "," + timeTypeId + ",'" + timeInstance.getDatingComments() + "')";
        try {
            this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            if (timeType.equalsIgnoreCase("Exact Time")) {
                this.addExactTimeToDatabase(timeInstanceId, (ExactTime)timeInstance);
            } else {
                this.addTimeEstimateToDatabase(timeInstanceId, (TimeEstimate)timeInstance);
            }
            ArrayList<Reference> referenceList = timeInstance.getReferencesList();
            for (int i = 0; i < referenceList.size(); ++i) {
                int referenceId = referenceList.get(i).getReferenceId();
                sql = "insert into Time_Instances_References(Time_Id,Reference_Id) values (" + timeInstanceId + "," + referenceId + ")";
                this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            }
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        return timeInstanceId;
    }

    private void addExactTimeToDatabase(int timeInstanceId, ExactTime timeInstance) {
        ExactTimeDB_DAO exactTimeDAO = new ExactTimeDB_DAO(this.dbAccessAPI);
        exactTimeDAO.addExactTime(timeInstanceId, timeInstance);
    }

    private boolean removeExactTimeFromDatabase(int timeInstanceId) {
        ExactTimeDB_DAO exactTimeDAO = new ExactTimeDB_DAO(this.dbAccessAPI);
        return exactTimeDAO.removeTime(timeInstanceId);
    }

    private ExactTime getExactTimeFromDatabase(int timeInstanceId) {
        ExactTimeDB_DAO exactTimeDAO = new ExactTimeDB_DAO(this.dbAccessAPI);
        return exactTimeDAO.getExactTime(timeInstanceId);
    }

    private void addTimeEstimateToDatabase(int timeInstanceId, TimeEstimate timeInstance) {
        TimeEstimateDB_DAO timeEstimateDAO = new TimeEstimateDB_DAO(this.dbAccessAPI);
        timeEstimateDAO.addTimeEstimate(timeInstanceId, timeInstance);
    }

    private TimeEstimate getTimeEstimateFromDatabase(int timeInstanceId) {
        TimeEstimateDB_DAO timeEstimateDAO = new TimeEstimateDB_DAO(this.dbAccessAPI);
        return timeEstimateDAO.getTimeEstimate(timeInstanceId);
    }

    private boolean removeTimeEstimateFromDatabase(int timeInstanceId) {
        TimeEstimateDB_DAO timeEstimateDAO = new TimeEstimateDB_DAO(this.dbAccessAPI);
        return timeEstimateDAO.removeTimeEstimate(timeInstanceId);
    }

    public TimeAPI getTimeInstance(int timeInstanceId) throws QueryException {
        TimeAPI timAPI = null;
        String condition = " where Time_Id=" + timeInstanceId;
        ArrayList<TimeAPI> timeInstancesList = this.query(condition);
        if (timeInstancesList.size() > 0) {
            timAPI = timeInstancesList.get(0);
        }
        return timAPI;
    }

    public boolean removeTimeInstance(int timeInstanceId) throws UpdateException {
        String sql = "select Time_Id,Time_Type_Id,Comments from Time_Instances where Time_Id=" + timeInstanceId;
        try {
            CachedRowSet rs = this.dbAccessAPI.queryData(sql);
            TimeTypeDB_DAO timeTypeDB_DAO = new TimeTypeDB_DAO(this.dbAccessAPI);
            while (rs.next()) {
                String timeTypeName = timeTypeDB_DAO.getTimeType(rs.getInt(TIME_TYPE_ID));
                if (timeTypeName.equalsIgnoreCase("Exact Time")) {
                    this.removeExactTimeFromDatabase(timeInstanceId);
                } else {
                    this.removeTimeEstimateFromDatabase(timeInstanceId);
                }
                String referencesDelSql = "delete from Time_Instances_References where Time_Id =" + timeInstanceId;
                this.dbAccessAPI.insertUpdateOrDeleteData(referencesDelSql);
                String delSql = "delete from Time_Instances where Time_Id=" + timeInstanceId;
                int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(delSql);
                if (numRows != 1) continue;
                return true;
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return false;
    }

    private ArrayList<TimeAPI> query(String condition) throws QueryException {
        ArrayList<TimeAPI> timeInstancesList = new ArrayList<TimeAPI>();
        String sql = "select Time_Id,Time_Type_Id,Comments from Time_Instances " + condition;
        try {
            CachedRowSet rs = this.dbAccessAPI.queryData(sql);
            TimeTypeDB_DAO timeTypeDB_DAO = new TimeTypeDB_DAO(this.dbAccessAPI);
            ReferenceDB_DAO referenceDAO = new ReferenceDB_DAO(this.dbAccessAPI);
            while (rs.next()) {
                String timeTypeName = timeTypeDB_DAO.getTimeType(rs.getInt(TIME_TYPE_ID));
                TimeAPI timeAPI = timeTypeName.equalsIgnoreCase("Exact Time") ? this.getExactTimeFromDatabase(rs.getInt(TIME_ID)) : this.getTimeEstimateFromDatabase(rs.getInt(TIME_ID));
                timeAPI.setDatingComments(rs.getString(COMMENTS));
                ArrayList<Reference> referenceList = new ArrayList<Reference>();
                sql = "select Reference_Id,Time_Id from Time_Instances_References where Time_Id=" + rs.getInt(TIME_ID);
                CachedRowSet referenceResultSet = this.dbAccessAPI.queryData(sql);
                while (referenceResultSet.next()) {
                    referenceList.add(referenceDAO.getReference(referenceResultSet.getInt(REFERENCE_ID)));
                }
                referenceResultSet.close();
                timeAPI.setReferencesList(referenceList);
                timeInstancesList.add(timeAPI);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return timeInstancesList;
    }
}

