/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.excelToDatabase;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.opensha.commons.data.estimate.DiscreteValueEstimate;
import org.opensha.commons.data.estimate.MinMaxPrefEstimate;
import org.opensha.commons.data.estimate.NormalEstimate;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.FaultSectionVer2_DB_DAO;
import org.opensha.refFaultParamDb.vo.EstimateInstances;
import org.opensha.refFaultParamDb.vo.FaultSectionData;
import org.opensha.sha.faultSurface.FaultTrace;

public class PutFaultSectionsIntoDatabase {
    private static final String INPUT_FILE1 = "2006_fault_sections.MID";
    private static final String INPUT_FILE2 = "2006_fault_sections.MIF";
    private static final String NAME_CHANGE_FILE_NAME = "FaultSectionNameChanges.v1.xls";
    private static final String DIP_UNITS = "degrees";
    private static final String SLIP_RATE_UNITS = "mm/yr";
    private static final String DEPTH_UNITS = "km";
    private static final String RAKE_UNITS = "degrees";
    private static final String ASEISMIC_SLIP_FACTOR_UNITS = " ";
    private static final String PLINE = "Pline";
    private static final String PEN = "Pen";
    private ArrayList faultSectionTraceLines;
    private int nextTraceStartIndex = 0;
    private FaultSectionVer2_DB_DAO faultSectionDAO = new FaultSectionVer2_DB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
    private static final int MIN_ROW_NAME_CHANGES = 1;
    private static final int MAX_ROW_NAME_CHANGES = 256;
    private static final String SECTION_TRACE_FILE_NAME = "WGCEP_FaultSectionsTrace.txt";
    private String dipDirectionFromFile;

    public PutFaultSectionsIntoDatabase() {
        try {
            ArrayList<String> fileLines1 = FileUtils.loadFile(INPUT_FILE1);
            ArrayList<FaultSectionData> faultSectionsList = new ArrayList<FaultSectionData>();
            this.faultSectionTraceLines = FileUtils.loadFile(INPUT_FILE2);
            HashMap nameChangeMap = this.loadNameChangeFile(NAME_CHANGE_FILE_NAME);
            FileWriter fwSectionTrace = new FileWriter(SECTION_TRACE_FILE_NAME);
            for (int i = 0; i < fileLines1.size(); ++i) {
                try {
                    FaultTrace faultSectionTrace = this.getNextTrace("temp");
                    FaultSectionData faultSection = this.getFaultSection(fileLines1.get(i));
                    faultSectionTrace.setName(faultSection.getSectionName());
                    faultSectionsList.add(faultSection);
                    faultSection.setFaultTrace(faultSectionTrace);
                    this.calculateDipDirection(faultSection);
                    String newName = (String)nameChangeMap.get("" + (i + 1));
                    if (newName != null) {
                        faultSection.setSectionName(newName);
                    }
                    this.faultSectionDAO.addFaultSection(faultSection);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(0);
                }
            }
            fwSectionTrace.close();
            fileLines1 = null;
            this.faultSectionTraceLines = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void calculateDipDirection(FaultSectionData faultSection) {
        double dip = ((MinMaxPrefEstimate)faultSection.getAveDipEst().getEstimate()).getPreferred();
        if (dip == 90.0) {
            faultSection.setDipDirection(Float.NaN);
            return;
        }
        FaultTrace faultSectionTrace = faultSection.getFaultTrace();
        double dipDirectionFromOpenSHA = 90.0 + LocationUtils.vector((Location)faultSectionTrace.get(0), (Location)faultSectionTrace.get(faultSectionTrace.getNumLocations() - 1)).getAzimuth();
        if (dipDirectionFromOpenSHA < 0.0) {
            dipDirectionFromOpenSHA += 360.0;
        } else if (dipDirectionFromOpenSHA > 360.0) {
            dipDirectionFromOpenSHA -= 360.0;
        }
        faultSection.setDipDirection((float)dipDirectionFromOpenSHA);
        if (this.dipDirectionFromFile.equalsIgnoreCase("") || this.dipDirectionFromFile.equalsIgnoreCase("n/a")) {
            System.out.println("Dip direction not available for section:" + faultSection.getSectionName() + " with dip " + dip);
            return;
        }
        double dipDirFromString = 0.0;
        if (this.dipDirectionFromFile.equalsIgnoreCase("N")) {
            dipDirFromString = 0.0;
        } else if (this.dipDirectionFromFile.equalsIgnoreCase("NE")) {
            dipDirFromString = 45.0;
        } else if (this.dipDirectionFromFile.equalsIgnoreCase("E")) {
            dipDirFromString = 90.0;
        } else if (this.dipDirectionFromFile.equalsIgnoreCase("SE")) {
            dipDirFromString = 135.0;
        } else if (this.dipDirectionFromFile.equalsIgnoreCase("S")) {
            dipDirFromString = 180.0;
        } else if (this.dipDirectionFromFile.equalsIgnoreCase("SW")) {
            dipDirFromString = 225.0;
        } else if (this.dipDirectionFromFile.equalsIgnoreCase("W")) {
            dipDirFromString = 270.0;
        } else if (this.dipDirectionFromFile.equalsIgnoreCase("NW")) {
            dipDirFromString = 315.0;
        }
        double dipDirectionDiff = Math.abs(dipDirectionFromOpenSHA - dipDirFromString);
        if (dipDirectionDiff >= 135.0 && dipDirectionDiff <= 225.0) {
            faultSectionTrace.reverse();
        } else if (dipDirectionDiff > 45.0 && dipDirectionDiff < 135.0 || dipDirectionDiff > 225.0 && dipDirectionDiff < 315.0) {
            System.out.println("Please check the section:" + faultSection.getSectionName() + " as difference in dip direction is " + dipDirectionDiff);
        }
    }

    private FaultTrace getNextTrace(String faultSectionName) {
        boolean found = false;
        double lat = 0.0;
        FaultTrace sectionTrace = new FaultTrace(faultSectionName);
        while (!found) {
            String line = ((String)this.faultSectionTraceLines.get(this.nextTraceStartIndex)).trim();
            if (line.startsWith(PLINE)) {
                found = true;
                String locString = ((String)this.faultSectionTraceLines.get(++this.nextTraceStartIndex)).trim();
                while (!locString.startsWith(PEN)) {
                    StringTokenizer tokenizer = new StringTokenizer(locString);
                    double lon = Double.parseDouble(tokenizer.nextToken());
                    lat = Double.parseDouble(tokenizer.nextToken());
                    sectionTrace.add(new Location(lat, lon));
                    locString = ((String)this.faultSectionTraceLines.get(++this.nextTraceStartIndex)).trim();
                }
            }
            ++this.nextTraceStartIndex;
        }
        return sectionTrace;
    }

    private HashMap loadNameChangeFile(String fileName) {
        HashMap<String, String> nameChangesMap = new HashMap<String, String>();
        try {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(fileName));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(0);
            for (int r = 1; r <= 256; ++r) {
                HSSFRow row = sheet.getRow(r);
                HSSFCell cell1 = row.getCell(0);
                HSSFCell cell2 = row.getCell(2);
                if (cell2 == null || cell2.getCellType() == 3) continue;
                nameChangesMap.put(cell1.getStringCellValue().trim(), cell2.getStringCellValue().trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nameChangesMap;
    }

    private FaultSectionData getFaultSection(String line) {
        String fileName;
        String rank;
        String rake;
        String model;
        FaultSectionData faultSection = new FaultSectionData();
        Object comments = "";
        int index = line.indexOf("\",\"");
        faultSection.setSectionName(line.substring(1, index));
        System.out.println(faultSection.getSectionName());
        String line2 = line.substring(index + 2);
        index = line2.indexOf("\",\"");
        String qFaultId = this.removeQuotes(line2.substring(0, index + 1));
        if (!qFaultId.equalsIgnoreCase("")) {
            faultSection.setQFaultId(qFaultId);
        }
        if (!(model = this.removeQuotes((line2 = line2.substring(index + 2)).substring(0, (index = line2.indexOf("\",\"")) + 1))).equalsIgnoreCase("")) {
            comments = (String)comments + "Model=" + model + "\n";
        }
        StringTokenizer tokenizer = new StringTokenizer(line2.substring(index + 2), ",");
        faultSection.setSource(this.removeQuotes(tokenizer.nextToken().trim()));
        String faultType = this.removeQuotes(tokenizer.nextToken().trim());
        if (!faultType.equalsIgnoreCase("")) {
            comments = (String)comments + "FaultType=" + faultType + "\n";
        }
        if (!(rake = this.removeQuotes(tokenizer.nextToken().trim())).equalsIgnoreCase("")) {
            faultSection.setAveRakeEst(this.getMinMaxPrefEstimateInstance(this.removeQuotes(rake), "degrees"));
        }
        String dip = this.removeQuotes(tokenizer.nextToken().trim());
        faultSection.setAveDipEst(this.getMinMaxPrefEstimateInstance(dip, "degrees"));
        this.dipDirectionFromFile = this.removeQuotes(tokenizer.nextToken().trim());
        String slipRate = this.removeQuotes(tokenizer.nextToken().trim());
        String slipRateUncert = this.removeQuotes(tokenizer.nextToken().trim());
        if (!slipRate.equalsIgnoreCase("")) {
            NormalEstimate slipRateEst = new NormalEstimate(Double.parseDouble(slipRate), Double.parseDouble(slipRateUncert));
            faultSection.setAveLongTermSlipRateEst(new EstimateInstances(slipRateEst, SLIP_RATE_UNITS));
        }
        if (!(rank = this.removeQuotes(tokenizer.nextToken().trim())).equalsIgnoreCase("")) {
            comments = (String)comments + "Rank=" + rank + "\n";
        }
        String upperDepth = this.removeQuotes(tokenizer.nextToken().trim());
        faultSection.setAveUpperDepthEst(this.getMinMaxPrefEstimateInstance(upperDepth, DEPTH_UNITS));
        String lowerDepth = this.removeQuotes(tokenizer.nextToken().trim());
        faultSection.setAveLowerDepthEst(this.getMinMaxPrefEstimateInstance(lowerDepth, DEPTH_UNITS));
        String width = this.removeQuotes(tokenizer.nextToken().trim());
        if (!width.equalsIgnoreCase("")) {
            comments = (String)comments + "Width=" + width + "\n";
        }
        if (!(fileName = this.removeQuotes(tokenizer.nextToken().trim())).equalsIgnoreCase("")) {
            comments = (String)comments + "FileName=" + fileName + "\n";
        }
        double rfactor1 = 0.0;
        double rfactor1Wt = 0.0;
        double rfactor2 = 0.0;
        double rfactor2Wt = 0.0;
        double rfactor3 = 0.0;
        double rfactor3Wt = 0.0;
        String str = null;
        str = tokenizer.nextToken().trim();
        if (str.equalsIgnoreCase("")) {
            str = "0";
        }
        rfactor1 = Double.parseDouble(str);
        str = tokenizer.nextToken().trim();
        if (str.equalsIgnoreCase("")) {
            str = "0";
        }
        rfactor1Wt = Double.parseDouble(str);
        str = tokenizer.nextToken().trim();
        if (str.equalsIgnoreCase("")) {
            str = "1";
        }
        rfactor2 = Double.parseDouble(str);
        str = tokenizer.nextToken().trim();
        if (str.equalsIgnoreCase("")) {
            str = "1";
        }
        rfactor2Wt = Double.parseDouble(str);
        str = tokenizer.nextToken().trim();
        if (str.equalsIgnoreCase("")) {
            str = "0";
        }
        rfactor3 = Double.parseDouble(str);
        str = tokenizer.nextToken().trim();
        if (str.equalsIgnoreCase("")) {
            str = "0";
        }
        rfactor3Wt = Double.parseDouble(str);
        faultSection.setAseismicSlipFactorEst(this.getAsesmicEstimate(rfactor1, rfactor1Wt, rfactor2, rfactor2Wt, rfactor3, rfactor3Wt, ASEISMIC_SLIP_FACTOR_UNITS));
        return faultSection;
    }

    private String removeQuotes(String str) {
        if (str.charAt(0) == '\"') {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private EstimateInstances getAsesmicEstimate(double rfactor1, double rfactor1Wt, double rfactor2, double rfactor2Wt, double rfactor3, double rfactor3Wt, String units) {
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        func.set(1.0 - rfactor1, rfactor1Wt);
        func.set(1.0 - rfactor2, rfactor2Wt);
        func.set(1.0 - rfactor3, rfactor3Wt);
        DiscreteValueEstimate estimate = new DiscreteValueEstimate(func, false);
        return new EstimateInstances(estimate, units);
    }

    private EstimateInstances getMinMaxPrefEstimateInstance(String value, String units) {
        MinMaxPrefEstimate estimate = new MinMaxPrefEstimate(Double.NaN, Double.NaN, Double.parseDouble(value), Double.NaN, Double.NaN, Double.NaN);
        return new EstimateInstances(estimate, units);
    }

    public static void main(String[] args) {
        new PutFaultSectionsIntoDatabase();
    }
}

